#pragma once

#include "quantum.h"

void send_unicode_hex_string(const char* str);

/* use X(n) to call the  */
#ifdef UNICODEMAP_ENABLE
enum unicode_name {
  THINK, // thinking face 🤔
  GRIN, // grinning face 😊
  SMRK, // smirk 😏
  WEARY, // good shit 😩
  UNAMU, // unamused 😒

  SNEK, // snke 🐍
  PENGUIN, // 🐧
  DRAGON, // 🐉
  MONKEY, // 🐒
  CHICK, // 🐥
  BOAR, // 🐗

  OKOK, // 👌
  EFFU, // 🖕
  INUP, // 👆
  THUP, // 👍
  THDN, // 👎

  BBB, // dat B 🅱
  POO, // poop 💩
  HUNDR, // 100 💯
  EGGPL, // EGGPLANT 🍆
  WATER, // wet 💦
  TUMBLER, // 🥃

  LIT, // fire 🔥
  BANG, // ‽
  IRONY, // ⸮
  DEGREE // °
};


const uint32_t PROGMEM unicode_map[] = {
  [THINK]     = 0x1F914,
  [GRIN]      = 0x1F600,
  [BBB]       = 0x1F171,
  [POO]       = 0x1F4A9,
  [HUNDR]     = 0x1F4AF,
  [SMRK]      = 0x1F60F,
  [WEARY]     = 0x1F629,
  [EGGPL]     = 0x1F346,
  [WATER]     = 0x1F4A6,
  [LIT]       = 0x1F525,
  [UNAMU]     = 0x1F612,
  [SNEK]      = 0x1F40D,
  [PENGUIN]   = 0x1F427,
  [BOAR]      = 0x1F417,
  [MONKEY]    = 0x1F412,
  [CHICK]     = 0x1F425,
  [DRAGON]    = 0x1F409,
  [OKOK]      = 0x1F44C,
  [EFFU]      = 0x1F595,
  [INUP]      = 0x1F446,
  [THDN]      = 0x1F44E,
  [THUP]      = 0x1F44D,
  [TUMBLER]   = 0x1F943,
  [BANG]      = 0x0203D,
  [IRONY]     = 0x02E2E,
  [DEGREE]    = 0x000B0
 };
#endif // UNICODEMAP_ENABLE
