/* Copyright 2019
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Sendstring lookup tables for Slovenian layouts

#pragma once

#include "keymap_slovenian.h"
#include "quantum.h"

// clang-format off

const uint8_t ascii_to_shift_lut[16] PROGMEM = {
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),

    KCLUT_ENTRY(0, 1, 1, 1, 1, 1, 1, 0),
    KCLUT_ENTRY(1, 1, 1, 0, 0, 0, 0, 1),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 1, 1, 0, 1, 1, 1),
    KCLUT_ENTRY(0, 1, 1, 1, 1, 1, 1, 1),
    KCLUT_ENTRY(1, 1, 1, 1, 1, 1, 1, 1),
    KCLUT_ENTRY(1, 1, 1, 1, 1, 1, 1, 1),
    KCLUT_ENTRY(1, 1, 1, 0, 0, 0, 0, 1),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0)
};

const uint8_t ascii_to_altgr_lut[16] PROGMEM = {
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),

    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(1, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 1, 1, 1, 1, 0),
    KCLUT_ENTRY(1, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 1, 1, 1, 1, 0)
};

const uint8_t ascii_to_keycode_lut[128] PROGMEM = {
    // NUL   SOH      STX      ETX      EOT      ENQ      ACK      BEL
    XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
    // BS    TAB      LF       VT       FF       CR       SO       SI
    KC_BSPC, KC_TAB,  KC_ENT,  XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
    // DLE   DC1      DC2      DC3      DC4      NAK      SYN      ETB
    XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
    // CAN   EM       SUB      ESC      FS       GS       RS       US
    XXXXXXX, XXXXXXX, XXXXXXX, KC_ESC,  XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,

    //       !        "        #        $        %        &        '
    KC_SPC,  SI_1,    SI_2,    SI_3,    SI_4,    SI_5,    SI_6,    SI_QUOT,
    // (     )        *        +        ,        -        .        /
    SI_8,    SI_9,    SI_PLUS, SI_PLUS, SI_COMM, SI_MINS, SI_DOT,  SI_7,
    // 0     1        2        3        4        5        6        7
    SI_0,    SI_1,    SI_2,    SI_3,    SI_4,    SI_5,    SI_6,    SI_7,
    // 8     9        :        ;        <        =        >        ?
    SI_8,    SI_9,    SI_DOT,  SI_COMM, SI_LABK, SI_0,    SI_LABK, SI_QUOT,
    // @     A        B        C        D        E        F        G
    SI_V,    SI_A,    SI_B,    SI_C,    SI_D,    SI_E,    SI_F,    SI_G,
    // H     I        J        K        L        M        N        O
    SI_H,    SI_I,    SI_J,    SI_K,    SI_L,    SI_M,    SI_N,    SI_O,
    // P     Q        R        S        T        U        V        W
    SI_P,    SI_Q,    SI_R,    SI_S,    SI_T,    SI_U,    SI_V,    SI_W,
    // X     Y        Z        [        \        ]        ^        _
    SI_X,    SI_Y,    SI_Z,    SI_F,    SI_Q,    SI_G,    SI_3,    SI_MINS,
    // `     a        b        c        d        e        f        g
    SI_7,    SI_A,    SI_B,    SI_C,    SI_D,    SI_E,    SI_F,    SI_G,
    // h     i        j        k        l        m        n        o
    SI_H,    SI_I,    SI_J,    SI_K,    SI_L,    SI_M,    SI_N,    SI_O,
    // p     q        r        s        t        u        v        w
    SI_P,    SI_Q,    SI_R,    SI_S,    SI_T,    SI_U,    SI_V,    SI_W,
    // x     y        z        {        |        }        ~        DEL
    SI_X,    SI_Y,    SI_Z,    SI_B,    SI_W,    SI_N,    SI_1,    KC_DEL
};
