/* Copyright 2020
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Sendstring lookup tables for Icelandic layouts

#pragma once

#include "keymap_icelandic.h"
#include "quantum.h"

// clang-format off

const uint8_t ascii_to_shift_lut[16] PROGMEM = {
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),

    KCLUT_ENTRY(0, 1, 1, 1, 1, 1, 1, 0),
    KCLUT_ENTRY(1, 1, 1, 0, 0, 0, 0, 1),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 1, 1, 0, 1, 1, 1),
    KCLUT_ENTRY(0, 1, 1, 1, 1, 1, 1, 1),
    KCLUT_ENTRY(1, 1, 1, 1, 1, 1, 1, 1),
    KCLUT_ENTRY(1, 1, 1, 1, 1, 1, 1, 1),
    KCLUT_ENTRY(1, 1, 1, 0, 0, 0, 0, 1),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0)
};

const uint8_t ascii_to_altgr_lut[16] PROGMEM = {
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),

    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(1, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 1, 1, 1, 1, 0),
    KCLUT_ENTRY(1, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 1, 1, 1, 1, 0)
};

const uint8_t ascii_to_keycode_lut[128] PROGMEM = {
    // NUL   SOH      STX      ETX      EOT      ENQ      ACK      BEL
    XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
    // BS    TAB      LF       VT       FF       CR       SO       SI
    KC_BSPC, KC_TAB,  KC_ENT,  XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
    // DLE   DC1      DC2      DC3      DC4      NAK      SYN      ETB
    XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
    // CAN   EM       SUB      ESC      FS       GS       RS       US
    XXXXXXX, XXXXXXX, XXXXXXX, KC_ESC,  XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,

    //       !        "        #        $        %        &        '
    KC_SPC,  IS_1,    IS_2,    IS_3,    IS_4,    IS_5,    IS_6,    IS_QUOT,
    // (     )        *        +        ,        -        .        /
    IS_8,    IS_9,    IS_PLUS, IS_PLUS, IS_COMM, IS_MINS, IS_DOT,  IS_7,
    // 0     1        2        3        4        5        6        7
    IS_0,    IS_1,    IS_2,    IS_3,    IS_4,    IS_5,    IS_6,    IS_7,
    // 8     9        :        ;        <        =        >        ?
    IS_8,    IS_9,    IS_DOT,  IS_COMM, IS_LABK, IS_0,    IS_LABK, IS_QUOT,
    // @     A        B        C        D        E        F        G
    IS_Q,    IS_A,    IS_B,    IS_C,    IS_D,    IS_E,    IS_F,    IS_G,
    // H     I        J        K        L        M        N        O
    IS_H,    IS_I,    IS_J,    IS_K,    IS_L,    IS_M,    IS_N,    IS_O,
    // P     Q        R        S        T        U        V        W
    IS_P,    IS_Q,    IS_R,    IS_S,    IS_T,    IS_U,    IS_V,    IS_W,
    // X     Y        Z        [        \        ]        ^        _
    IS_X,    IS_Y,    IS_Z,    IS_8,    IS_ODIA, IS_9,    IS_ACUT, IS_MINS,
    // `     a        b        c        d        e        f        g
    IS_PLUS, IS_A,    IS_B,    IS_C,    IS_D,    IS_E,    IS_F,    IS_G,
    // h     i        j        k        l        m        n        o
    IS_H,    IS_I,    IS_J,    IS_K,    IS_L,    IS_M,    IS_N,    IS_O,
    // p     q        r        s        t        u        v        w
    IS_P,    IS_Q,    IS_R,    IS_S,    IS_T,    IS_U,    IS_V,    IS_W,
    // x     y        z        {        |        }        ~        DEL
    IS_X,    IS_Y,    IS_Z,    IS_7,    IS_LABK, IS_0,    IS_QUOT, KC_DEL
};
