/* Copyright 2019 kimat
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Sendstring lookup tables for Belgian layouts

#pragma once

#include "keymap_belgian.h"
#include "quantum.h"

// clang-format off

const uint8_t ascii_to_shift_lut[16] PROGMEM = {
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),

    KCLUT_ENTRY(0, 0, 0, 0, 0, 1, 0, 0),
    KCLUT_ENTRY(0, 0, 1, 1, 0, 0, 1, 1),
    KCLUT_ENTRY(1, 1, 1, 1, 1, 1, 1, 1),
    KCLUT_ENTRY(1, 1, 0, 0, 0, 0, 1, 1),
    KCLUT_ENTRY(0, 1, 1, 1, 1, 1, 1, 1),
    KCLUT_ENTRY(1, 1, 1, 1, 1, 1, 1, 1),
    KCLUT_ENTRY(1, 1, 1, 1, 1, 1, 1, 1),
    KCLUT_ENTRY(1, 1, 1, 0, 0, 0, 0, 1),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0)
};

const uint8_t ascii_to_altgr_lut[16] PROGMEM = {
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),

    KCLUT_ENTRY(0, 0, 0, 1, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(1, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 1, 1, 1, 1, 0),
    KCLUT_ENTRY(1, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 0, 0, 0, 0, 0),
    KCLUT_ENTRY(0, 0, 0, 1, 1, 1, 1, 0)
};

const uint8_t ascii_to_keycode_lut[128] PROGMEM = {
    // NUL   SOH      STX      ETX      EOT      ENQ      ACK      BEL
    XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
    // BS    TAB      LF       VT       FF       CR       SO       SI
    KC_BSPC, KC_TAB,  KC_ENT,  XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
    // DLE   DC1      DC2      DC3      DC4      NAK      SYN      ETB
    XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
    // CAN   EM       SUB      ESC      FS       GS       RS       US
    XXXXXXX, XXXXXXX, XXXXXXX, KC_ESC,  XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,

    //       !        "        #        $        %        &        '
    KC_SPC,  BE_EXLM, BE_DQUO, BE_DQUO, BE_DLR,  BE_UGRV, BE_AMPR, BE_QUOT,
    // (     )        *        +        ,        -        .        /
    BE_LPRN, BE_RPRN, BE_DLR,  BE_EQL,  BE_COMM, BE_MINS, BE_SCLN, BE_COLN,
    // 0     1        2        3        4        5        6        7
    BE_AGRV, BE_AMPR, BE_EACU, BE_DQUO, BE_QUOT, BE_LPRN, BE_SECT, BE_EGRV,
    // 8     9        :        ;        <        =        >        ?
    BE_EXLM, BE_CCED, BE_COLN, BE_SCLN, BE_LABK, BE_EQL,  BE_LABK, BE_COMM,
    // @     A        B        C        D        E        F        G
    BE_EACU, BE_A,    BE_B,    BE_C,    BE_D,    BE_E,    BE_F,    BE_G,
    // H     I        J        K        L        M        N        O
    BE_H,    BE_I,    BE_J,    BE_K,    BE_L,    BE_M,    BE_N,    BE_O,
    // P     Q        R        S        T        U        V        W
    BE_P,    BE_Q,    BE_R,    BE_S,    BE_T,    BE_U,    BE_V,    BE_W,
    // X     Y        Z        [        \        ]        ^        _
    BE_X,    BE_Y,    BE_Z,    BE_CIRC, BE_LABK, BE_DLR,  BE_SECT, BE_MINS,
    // `     a        b        c        d        e        f        g
    BE_MICR, BE_A,    BE_B,    BE_C,    BE_D,    BE_E,    BE_F,    BE_G,
    // h     i        j        k        l        m        n        o
    BE_H,    BE_I,    BE_J,    BE_K,    BE_L,    BE_M,    BE_N,    BE_O,
    // p     q        r        s        t        u        v        w
    BE_P,    BE_Q,    BE_R,    BE_S,    BE_T,    BE_U,    BE_V,    BE_W,
    // x     y        z        {        |        }        ~        DEL
    BE_X,    BE_Y,    BE_Z,    BE_CCED, BE_AMPR, BE_AGRV, BE_EQL,  KC_DEL
};
