/*
 * Copyright (c) 2012, 2013, Joel Bodenmann aka Tectu <joel@unormal.org>
 * Copyright (c) 2012, 2013, Andrew Hannam aka inmarket
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    * Neither the name of the <organization> nor the
 *      names of its contributors may be used to endorse or promote products
 *      derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "gfx.h"
#include "math.h"

// A set of data points that will be displayed in the graph
static const gPoint data[5] = {
    { -40, -40 },
    { 70, 40 },
    { 140, 60 },
    { 210, 60 },
    { 280, 200 }
};

// A graph styling
static GGraphStyle GraphStyle1 = {
    { GGRAPH_POINT_DOT, 0, GFX_BLUE },          // Point
    { GGRAPH_LINE_NONE, 2, GFX_GRAY },          // Line
    { GGRAPH_LINE_SOLID, 0, GFX_WHITE },        // X axis
    { GGRAPH_LINE_SOLID, 0, GFX_WHITE },        // Y axis
    { GGRAPH_LINE_DASH, 5, GFX_GRAY, 50 },      // X grid
    { GGRAPH_LINE_DOT, 7, GFX_YELLOW, 50 },     // Y grid
    GWIN_GRAPH_STYLE_POSITIVE_AXIS_ARROWS		// Flags
};

// Another graph styling 
static const GGraphStyle GraphStyle2 = {
    { GGRAPH_POINT_SQUARE, 5, GFX_RED },        // Point
    { GGRAPH_LINE_DOT, 2, GFX_PINK },           // Line
    { GGRAPH_LINE_SOLID, 0, GFX_WHITE },        // X axis
    { GGRAPH_LINE_SOLID, 0, GFX_WHITE },        // Y axis
    { GGRAPH_LINE_DASH, 5, GFX_GRAY, 50 },      // X grid
    { GGRAPH_LINE_DOT, 7, GFX_YELLOW, 50 },     // Y grid
    GWIN_GRAPH_STYLE_POSITIVE_AXIS_ARROWS   	// Flags
};
 
int main(void) {
    GHandle     gh;
    gU16    i;
 
    gfxInit();
 
    // Create the graph window
    {
        GWindowInit wi;
 
        wi.show = gTrue;
        wi.x = wi.y = 0;
        wi.width = gdispGetWidth();
        wi.height = gdispGetHeight();
        gh = gwinGraphCreate(0, &wi);
    }

    // Set the graph origin and style
    gwinGraphSetOrigin(gh, gwinGetWidth(gh)/2, gwinGetHeight(gh)/2);
    gwinGraphSetStyle(gh, &GraphStyle1);
    gwinGraphDrawAxis(gh);

    // Draw a sine wave
    for(i = 0; i < gwinGetWidth(gh); i++) {
        gwinGraphDrawPoint(gh, i-gwinGetWidth(gh)/2, 80*sin(2*0.2*GFX_PI*i/180));
    }

    // Modify the style
    gwinGraphStartSet(gh);
    GraphStyle1.point.color = GFX_GREEN;
    gwinGraphSetStyle(gh, &GraphStyle1);

    // Draw a different sine wave
    for(i = 0; i < gwinGetWidth(gh)*5; i++) {
        gwinGraphDrawPoint(gh, i/5-gwinGetWidth(gh)/2, 95*sin(2*0.2*GFX_PI*i/180));
    }

    // Change to a completely different style
    gwinGraphStartSet(gh);
    gwinGraphSetStyle(gh, &GraphStyle2);

    // Draw a set of points
    gwinGraphDrawPoints(gh, data, sizeof(data)/sizeof(data[0]));

    while(1) {
        gfxSleepMilliseconds(100);
    }
}
