# bredfield's 4x12 Ortho Keymap

## Overview
This is the layout that I use for all 4x12 boards, for writing and programming.

- Works with planck or split style boards
- Split spacebar; left position is backspace, which frees up the typical key for minus/undersc
- Targets mac os; linux variant to come
- Navigation layer is triggered via the `;` key, allowing for single-hand navigation without leaving the home row
- Brackets are located on the home row on raise, which is comfortable when programming
- Reduced mod / layer tap use, to avoid input lag
- LEDs are overrated

## Layers
### Main
```
 * ,-----------------------------------------------------------------------------------------------------------.
 * |   Tab  |    Q   |    W   |    E   |    R   |    T   |    Y   |    U   |    I   |    O   |    P   |   -    |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * | GUI/Esc|    A   |    S   |    D   |    F   |    G   |    H   |    J   |    K   |    L   |  ;/nav |   "    |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |  Shift |    Z   |    X   |    C   |    V   |    B   |    N   |    M   |    ,   |    .   |    /   | Sft/ent|
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * | Numpad |  Ctrl  |  Alt   |  GUI   |  Lower |  Bksp  |  Space | Raise  |  Ctrl  |  Alt   |   UI   |  Keybd |
 * `-----------------------------------------------------------------------------------------------------------'
 ```

 ### Lower
 ```
 * ,-----------------------------------------------------------------------------------------------------------.
 * |   `    |    !   |    @   |    #   |    $   |    %   |    ^   |    &   |    *   |   +    |    =   |    -   |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |    1   |    2   |    3   |    4   |    5   |    6   |    7   |    8   |    9   |    0   |    \   |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |        |        |        |   ,    |    .   |    /   |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |  Del   |        |        |        |        |        |        |
 * `-----------------------------------------------------------------------------------------------------------'
```

### Raise
```
 * ,-----------------------------------------------------------------------------------------------------------.
 * |   ~    |   F1   |   F2   |   F3   |   F4   |   F5   |   F6   |   F7   |   F8   |    F9  |  F10   |   _    |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |    {   |    [   |    (   |   <    |    >   |    )   |    ]   |    }   |        |   |    |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |        |        |        |        |        |        |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |   Del  |        |        |        |        |        |        |
 * `-----------------------------------------------------------------------------------------------------------'
```

### Numpad
```
 * ,-----------------------------------------------------------------------------------------------------------.
 * |        |        |        |        |        |        |        |   7    |    8   |   9    |   *    |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |        |        |   4    |    5   |   6    |   -    |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |        |        |   1    |    2   |   3    |   +    |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |        |        |   0    |    .   |   /    |        |        |
 * `-----------------------------------------------------------------------------------------------------------'
 ```

### Navigation
```
 * ,-----------------------------------------------------------------------------------------------------------.
 * |        |        |        |        |        |        |        |  Home  |   Up   |  End   |        |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |        |        |  Left  |  Down  | Right  |        |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |        |        |        |        |        |        |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |  Enter |        |        |   Del  |        |        |        |        |
 * `-----------------------------------------------------------------------------------------------------------'
```

### UI
```
 * ,--------------------------------------------------------------------------------+--------+-----------------.
 * | GUI Tab|        |        |        |        |        |        |        |        | GUI -  | GUI =  |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * | GUI `  | GUI 1  |  GUI 2 |  GUI 3 |  GUI 4 |  GUI 5 | GUI 6  | GUI 7  |        | GUI [  | GUI ]  |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------------------------+--------|
 * |        |Full SS | Area SS|        |        |        |        |        |        |        |        |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |  Prev  |  Play  | Next   |  Bri - |        |        |  Bri + |  Mute  | Vol -  | Vol +  |        |
 * `-----------------------------------------------------------------------------------------------------------'
```

### Keyboard
```
 * ,--------------------------------------------------------------------------------+--------+-----------------.
 * |        |        |        |        |        |        |        |        |        |        |        | RESET  |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |        |        |        |        |        |        | DEBUG  |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------------------------+--------|
 * |        |        |        |        |        |        |        |        |        |        |        |        |
 * |--------+--------+--------+--------+--------+-----------------+--------+--------+--------+--------+--------|
 * |        |        |        |        |        |        |        |        |        |        |        |        |
 * `-----------------------------------------------------------------------------------------------------------'
 */
 ```