# Roman's Layout

There are four layers:

- **BASE** is [Norman layout](https://normanlayout.info/).
- **SYMB** for numbers and symbols.
- **PLVR** is optimized for [Plover](http://www.openstenoproject.org).
- **ARRW** for navigation (same fingers for arrows as HJKL on QWERTY).

Looking for IJKL arrows? [Here we
go](../romanzolotarev-norman-plover-osx/).

[![keyboard-layout](https://i.imgur.com/uvMxLuJ.png)](http://www.keyboard-layout-editor.com/#/gists/56ffedceb0668dda47c993e7271563e0)

## Switching

- Tap `SYMB` to toggle **SYMB**.
- Tap `ARRW` to toggle **ARRW**.
- Hold `SYMB` (or `ARRW`) to activate **SYMB** (or **ARRW**) while holding.
- Tap `PLVR` to toggle **PLVR**.

## LEDs

- Red: SYMB is on.
- Green: PLVR is on.
- Blue: ARRW is on.

## Functional Keys

- Tap `F1` to mute microphone via [Shush](http://mizage.com/shush/).
- Tap `F2` to copy screenshot to the clipboard.
- Hold `SHIFT` and tap `F2` to save screenshot as a file.
- Tap `F3`, `F4`, `F5`, `F6` to resize a window via [Divvy](http://mizage.com/divvy/).
- Tap `F14`, `F15` to adjust display brightness.

**IMPORTANT**: If you have another keyboard connected via Bluetooth, then
`F14` and `F15` will not work. Turn off that Bluetooth keyboard. Re-plug
you ErgoDox. Enjoy!

## CTRL/ESC

Both of those keys are frequently used in Vim.

- Tap `CTRL/ESC` to send `ESC`.
- Hold `CTRL/ESC` to use as `CTRL`.

## Activate N-rollover

- While in **BASE** hold left `SHIFT` and right `SHIRT` and then tap `N`.
- Then you can activate **PLVR** and use ErgoDox EZ for steno.
