# J3RN's ErgoDox EZ keymap

## Motivation

I wanted a layout that was gave easy access to the CMD (LGui) key, and did not require finger gymnastics to use my beloved Emacs shortcuts.

## How is it different from the default ErgoDox EZ default_osx layout?

This layout more closely resembles that of the Mac keyboard, and has some other goodness baked in. Here is a rundown of what that means:

### Mac-like changes

- **The key to the right of "0" is Backspace instead of "-"** (misleadingly labeled "delete" on the Mac's keyboard). There was no room to fit in "-" and "=" between "0" and Backspace, unfortunately.
- **The rightmost big key on the left thumb is CMD (LGui) instead of Backspace.**
- **The key to the left of Alt-Shift is an Alt key**. This is close to it's position on the Mac keyboard, though slightly further left.

### Emacs changes
- **Holding "S" sends "left shift," holding "D" sends "left control," and holding "F" sends "left alt." This is mirrored on the right side with "J," "K," and "L."** This should make it easy to use those crazy Escape-Meta-Alt-Control-Shift bindings.

### Other changes

- **The button in the top-left is "Sleep."** Before macOS High Sierra, the power button was part of the key combination for triggering sleep. Since there's no power key in my layout, I was unable to sleep my laptop with this keyboard. By adding a dedicated sleep key, I fixed this. Now I just need a cool moon keycap for that key.
- **The middle-most big key on the right thumb is "Tab."** I use tab *a lot*, so I decided to make it incredibly convenient.
- **The button to the left of "Q" is Esc.** There is no functional reason for this other than to train me to use the tab under my right thumb.
- **The button to the left of "A" is Ctrl/Esc instead of Backspace.** This is actually how I have the keyboard on my Macbook set up to be, since it's loads more convenient than a CAPS LOCK key. This is the Ctrl key I find myself using most.
- **Mouse uses Vim-style navigation**. This allows you to move the mouse around with hjkl just like in Vim. Additionally, right and left click are the conveniently placed 'i' and 'o' keys.
- **The key to the right of "5" and the key to left of "6" are "[" and "]", respectively, instead of Left and Right.** There is a more convenient set of Left and Right already present. Truth be told, I don't really use these keys, as they are a stretch to reach.
- **The Toggle L1 keys in the center of the keyboard have been replaced by the otherwise displaced "-" and "=".** They are laid out, left-to-right, in the same order as on the Mac keyboard. Honestly, they are not terribly conveniently placed, and their placement might change in a later version. I found that the ~L1 would be better situated elsewhere.
- **The "~" key in the extreme bottom-left is now just momentary L1.** I go to L1 (the symbol layer) to get to "~".
- **The Home and End buttons have been shifted up on the left thumb, and ~L2 inserted below them.** Nearly all of my media layer changes are on the right side, so the ~L2 key is on the left side.
- **The Page Up and Page Down buttons have been shifted up on the right thumb, and ~L1 inserted below them.** I don't use either of the "Page" keys often, and use this ~L1 more than any other.
- **Traditional numpad layout.** The base of most numpads is a double-wide "0" key to the left of a "." key. This is reflected in my layout by having two "0" keys to the left of a "." key.
- **The function keys (F1-F12) have been moved to L2.** They were in the way in L1.
- **⏯ lives on ',' in the media layer, between ⏪ on 'm' and ⏩ on '.'.** This is the way they are laid out on the mac keyboard, and makes the most sense to me.
- **The keys on the bottom-right that were formerly "[" and "]" are now Alt-Shift and Alt, respectively.** This was originally for convenience with Emacs bindings, but since I've moved the modifiers to the home row the only purpose for this change is that the symmetry makes me happy.

**I'm always open to feedback and/or suggestions!**
