# coderkun’s Neo2 layout for the ErgoDox EZ

The idea of this layout is to use it for [Neo2](http://www.neo-layout.org) but also provide layers to use QWERTZ with activated Neo driver and to use (basic) Neo when no driver is available (standard QWERTZ driver is active) (e. g. on other computers, in virtual machines) and to make heavily use of thumb keys.

The main goal of the default layer is to provide a complete symmetric layout with each modifier equally placed for both hands (mirror, of course).

It also features a layer for additional keys like F-keys (F1 – F12), some mouse keys and some useful Unicode symbols.


## Build

    ```
    make clean
    make coderkun_neo2
    ```


## Keymap

0. Default layer for Neo2
1. Poor man’s QWERTZ
2. Poor man’s Neo
3. F-keys, mouse keys und Unicode symbols
4. Neo’s software layers 4 rebuilt in hardware


### Layer 0: Default layer for Neo2

    ┌───────┬─────┬─────┬─────┬─────┬─────┬─────┐     ┌─────┬─────┬─────┬─────┬─────┬─────┬───────┐
    │  TAB  │  1  │  2  │  3  │  4  │  5  │  `  │     │  ´  │  6  │  7  │  8  │  9  │  0  │ BKSPC │
    ├───────┼─────┼─────┼─────┼─────┼─────┼─────┤     ├─────┼─────┼─────┼─────┼─────┼─────┼───────┤
    │   Y   │  X  │  V  │  L  │  C  │  W  │ HOM │     │ END │  K  │  H  │  G  │  F  │  Q  │  ß    │
    ├───────┼─────┼─────┼─────╆─────╅─────┤  E  │     │     ├─────╆─────╅─────┼─────┼─────┼───────┤
    │ Mod3  │  U  │  I  │  A  │  E  │  O  ├─────┤     ├─────┤  S  │  N  │  R  │  T  │  D  │ Mod3  │
    ├───────┼─────┼─────┼─────╄─────╃─────┤ TL2 │     │ TL3 ├─────╄─────╃─────┼─────┼─────┼───────┤
    │ LSHFT │  Ü  │  Ö  │  Ä  │  P  │  Z  │     │     │     │  B  │  M  │  ,  │  .  │  J  │ Shift │
    └─┬─────┼─────┼─────┼─────┼─────┼─────┴─────┘     └─────┴─────┼─────┼─────┼─────┼─────┼─────┬─┘
      │ CTL │ ALT │ MO1 │ Win │ Mod4│                             │ Mod4│ Win │ MO1 │ Alt │ CTL │
      └─────┴─────┴─────┴─────┴─────┘ ┌─────┬─────┐ ┌─────┬─────┐ └─────┴─────┴─────┴─────┴─────┘
                                      │  ←  │  ↑  │ │  ↓  │  →  │
                                ┌─────┼─────┼─────┤ ├─────┼─────┼─────┐
                                │     │     │  ─  │ │  ─  │     │     │
                                │ SPC │ RTN ├─────┤ ├─────┤ RTN │ SPC │
                                │     │     │ HYP │ │ MEH │     │     │
                                └─────┴─────┴─────┘ └─────┴─────┴─────┘


### Layer 1: Poor man’s QWERTZ

    ┌───────┬─────┬─────┬─────┬─────┬─────┬─────┐     ┌─────┬─────┬─────┬─────┬─────┬─────┬───────┐
    │  TAB  │  1  │  2  │  3  │  4  │  5  │  `  │     │  ´  │  6  │  7  │  8  │  9  │  0  │ BKSPC │
    ├───────┼─────┼─────┼─────┼─────┼─────┼─────┤     ├─────┼─────┼─────┼─────┼─────┼─────┼───────┤
    │   C   │  P  │  T  │  F  │  K  │  L  │ HOM │     │ END │  B  │  A  │  S  │  G  │  V  │  Y    │
    ├───────┼─────┼─────┼─────╆─────╅─────┤  E  │     │     ├─────╆─────╅─────┼─────┼─────┼───────┤
    │ Mod3  │  D  │  H  │  Ö  │  O  │  I  ├─────┤     ├─────┤  U  │  -  │  Z  │  E  │  X  │ Mod3  │
    ├───────┼─────┼─────┼─────╄─────╃─────┤(TL2)│     │(TL3)├─────╄─────╃─────┼─────┼─────┼───────┤
    │ LSHFT │  Ä  │  Q  │  R  │  W  │  N  │     │     │     │  J  │  M  │  ,  │  .  │  ẞ  │ Shift │
    └─┬─────┼─────┼─────┼─────┼─────┼─────┴─────┘     └─────┴─────┼─────┼─────┼─────┼─────┼─────┬─┘
      │ CTL │ ALT │ MO1 │ Win │ MO4 │                             │ M04 │ Win │ MO1 │ Alt │ CTL │
      └─────┴─────┴─────┴─────┴─────┘ ┌─────┬─────┐ ┌─────┬─────┐ └─────┴─────┴─────┴─────┴─────┘
                                      │  ←  │  ↑  │ │  ↓  │  →  │
                                ┌─────┼─────┼─────┤ ├─────┼─────┼─────┐
                                │     │     │  ─  │ │  ─  │     │     │
                                │ SPC │ RTN ├─────┤ ├─────┤ RTN │ SPC │
                                │     │     │ HYP │ │ MEH │     │     │
                                └─────┴─────┴─────┘ └─────┴─────┴─────┘


### Layer 2: Poor man’s Neo

    ┌───────┬─────┬─────┬─────┬─────┬─────┬─────┐     ┌─────┬─────┬─────┬─────┬─────┬─────┬───────┐
    │  TAB  │  1  │  2  │  3  │  4  │  5  │  `  │     │  ´  │  6  │  7  │  8  │  9  │  0  │ BKSPC │
    ├───────┼─────┼─────┼─────┼─────┼─────┼─────┤     ├─────┼─────┼─────┼─────┼─────┼─────┼───────┤
    │   Y   │  X  │  V  │  L  │  C  │  W  │ HOM │     │ END │  K  │  H  │  G  │  F  │  Q  │  ß    │
    ├───────┼─────┼─────┼─────╆─────╅─────┤  E  │     │     ├─────╆─────╅─────┼─────┼─────┼───────┤
    │ Mod3  │  U  │  I  │  A  │  E  │  O  ├─────┤     ├─────┤  S  │  N  │  R  │  T  │  D  │ Mod3  │
    ├───────┼─────┼─────┼─────╄─────╃─────┤(TL2)│     │(TL3)├─────╄─────╃─────┼─────┼─────┼───────┤
    │ LSHFT │  Ü  │  Ö  │  Ä  │  P  │  Z  │     │     │     │  B  │  M  │  ,  │  .  │  J  │ Shift │
    └─┬─────┼─────┼─────┼─────┼─────┼─────┴─────┘     └─────┴─────┼─────┼─────┼─────┼─────┼─────┬─┘
      │ CTL │ ALT │ MO1 │ Win │ MO4 │                             │ M04 │ Win │ MO1 │ Alt │ CTL │
      └─────┴─────┴─────┴─────┴─────┘ ┌─────┬─────┐ ┌─────┬─────┐ └─────┴─────┴─────┴─────┴─────┘
                                      │  ←  │  ↑  │ │  ↓  │  →  │
                                ┌─────┼─────┼─────┤ ├─────┼─────┼─────┐
                                │     │     │  ─  │ │  ─  │     │     │
                                │ SPC │ RTN ├─────┤ ├─────┤ RTN │ SPC │
                                │     │     │ HYP │ │ MEH │     │     │
                                └─────┴─────┴─────┘ └─────┴─────┴─────┘


### Layer 3: F-keys, mouse keys und Unicode symbols

    ┌───────┬─────┬─────┬─────┬─────┬─────┬─────┐     ┌─────┬─────┬─────┬─────┬─────┬─────┬───────┐
    │       │ F1  │ F2  │ F3  │ F4  │ F5  │ F6  │     │ F7  │ F8  │ F9  │ F10 │ F11 │ F12 │       │
    ├───────┼─────┼─────┼─────┼─────┼─────┼─────┤     ├─────┼─────┼─────┼─────┼─────┼─────┼───────┤
    │       │  ┌  │  ┬  │  ┐  │  ─  │  │  │     │     │     │  ↔  │  ←  │  →  │  ↑  │  ↓  │       │
    ├───────┼─────┼─────┼─────╆─────╅─────┤     │     │     ├─────╆─────╅─────┼─────┼─────┼───────┤
    │       │  ├  │  ┼  │  ┤  │ 〈  │  〉 ├─────┤     ├─────┤     │  ✓  │  ✕  │  •  │  ∶  │       │
    ├───────┼─────┼─────┼─────╄─────╃─────┤(TL2)│     │(TL3)├─────╄─────╃─────┼─────┼─────┼───────┤
    │       │  └  │  ┴  │  ┘  │     │     │     │     │     │  ⇔  │  ⇐  │  ⇒  │  ⇑  │  ⇓  │       │
    └─┬─────┼─────┼─────┼─────┼─────┼─────┴─────┘     └─────┴─────┼─────┼─────┼─────┼─────┼─────┬─┘
      │     │     │(MO1)│     │(MO4)│                             │(MO4)│     │(MO1)│     │     │
      └─────┴─────┴─────┴─────┴─────┘ ┌─────┬─────┐ ┌─────┬─────┐ └─────┴─────┴─────┴─────┴─────┘
                                      │ Ms← │ Ms↑ │ │ Ms↓ │ Ms→ │
                                ┌─────┼─────┼─────┤ ├─────┼─────┼─────┐
                                │     │     │ MLC │ │ MRC │     │     │
                                │     │     ├─────┤ ├─────┤     │     │
                                │     │     │     │ │     │     │     │
                                └─────┴─────┴─────┘ └─────┴─────┴─────┘


### Layer 4: Neo’s software layers 4 rebuilt in hardware

    ┌───────┬─────┬─────┬─────┬─────┬─────┬─────┐     ┌─────┬─────┬─────┬─────┬─────┬─────┬───────┐
    │       │     │     │     │     │     │     │     │     │     │     │     │     │     │       │
    ├───────┼─────┼─────┼─────┼─────┼─────┼─────┤     ├─────┼─────┼─────┼─────┼─────┼─────┼───────┤
    │       │ PgUp│ BSpc│  ↑  │ Del │ PgDn│     │     │     │     │  7  │  8  │  9  │  +  │   −   │
    ├───────┼─────┼─────┼─────╆─────╅─────┤     │     │     ├─────╆─────╅─────┼─────┼─────┼───────┤
    │       │ Home│  ←  │  ↓  │  →  │ End ├─────┤     ├─────┤     │  4  │  5  │  6  │  ,  │   .   │
    ├───────┼─────┼─────┼─────╄─────╃─────┤(TL2)│     │(TL3)├─────╄─────╃─────┼─────┼─────┼───────┤
    │       │ Esc │ Tab │ Ins │ Ret │ Undo│     │     │     │     │  1  │  2  │  3  │     │       │
    └─┬─────┼─────┼─────┼─────┼─────┼─────┴─────┘     └─────┴─────┼─────┼─────┼─────┼─────┼─────┬─┘
      │     │     │(MO1)│     │(MO4)│                             │(MO4)│     │(MO1)│     │     │
      └─────┴─────┴─────┴─────┴─────┘ ┌─────┬─────┐ ┌─────┬─────┐ └─────┴─────┴─────┴─────┴─────┘
                                      │     │     │ │     │     │
                                ┌─────┼─────┼─────┤ ├─────┼─────┼─────┐
                                │     │     │     │ │     │     │     │
                                │     │     ├─────┤ ├─────┤     │     │
                                │     │     │     │ │     │     │     │
                                └─────┴─────┴─────┘ └─────┴─────┴─────┘
