#!/usr/bin/env python3

import os
import sys

charmap = {
    '9': [[1, 0]],
    '7': [[2, 0]], '@': [[2, 5], [2, 0]],
    '5': [[3, 0]], '*': [[2, 5], [3, 0]],
    '3': [[4, 0]], '^': [[2, 5], [4, 0]],
    '1': [[5, 0]], '$': [[2, 5], [5, 0]],
    '0': [[8, 0]], '%': [[2, 5], [8, 0]],
    '2': [[9, 0]], '!': [[2, 5], [9, 0]],
    '4': [[10, 0]], '#': [[2, 5], [10, 0]],
    '6': [[11, 0]], '&': [[2, 5], [11, 0]],
    '8': [[12, 0]],

    '\\': [[0, 1]], '|': [[2, 5], [0, 1]],
    'x': [[1, 1]], 'X': [[2, 5], [1, 1]],
    'w': [[2, 1]], 'W': [[2, 5], [2, 1]],
    'c': [[3, 1]], 'C': [[2, 5], [3, 1]],
    'h': [[4, 1]], 'H': [[2, 5], [4, 1]],
    'f': [[5, 1]], 'F': [[2, 5], [5, 1]],
    '[': [[6, 1]], '{': [[2, 5], [6, 1]], '(': [[6, 1], [6, 1]],
    ']': [[7, 1]], '}': [[2, 5], [7, 1]], ')': [[7, 1], [7, 1]],
    'm': [[8, 1]], 'M': [[2, 5], [8, 1]],
    'g': [[9, 1]], 'G': [[2, 5], [9, 1]],
    'l': [[10, 1]], 'L': [[2, 5], [10, 1]],
    'p': [[11, 1]], 'P': [[2, 5], [11, 1]],
    '/': [[12, 1]], '?': [[2, 5], [12, 1]],
    '`': [[13, 1]], '~': [[2, 5], [13, 1]],

    '\t': [[0, 2]],
    'a': [[1, 2]], 'A': [[2, 5], [1, 2]],
    'o': [[2, 2]], 'O': [[2, 5], [2, 2]],
    'e': [[3, 2]], 'E': [[2, 5], [3, 2]],
    'i': [[4, 2]], 'I': [[2, 5], [4, 2]],
    'u': [[5, 2]], 'U': [[2, 5], [5, 2]],
    'd': [[8, 2]], 'D': [[2, 5], [8, 2]],
    'r': [[9, 2]], 'R': [[2, 5], [9, 2]],
    't': [[10, 2]], 'T': [[2, 5], [10, 2]],
    'n': [[11, 2]], 'N': [[2, 5], [11, 2]],
    's': [[12, 2]], 'S': [[2, 5], [12, 2]],
    '=': [[13, 2]], '+': [[2, 5], [13, 2]],

    'z': [[1, 3]], 'Z': [[2, 5], [1, 3]],
    'q': [[2, 3]], 'Q': [[2, 5], [2, 3]],
    '\'': [[3, 3]], '"': [[2, 5], [3, 3]],
    ',': [[4, 3]], '<': [[2, 5], [4, 3]],
    '.': [[5, 3]], '>': [[2, 5], [5, 3]],
    'b': [[8, 3]], 'B': [[2, 5], [8, 3]],
    'k': [[9, 3]], 'K': [[2, 5], [9, 3]],
    'v': [[10, 3]], 'V': [[2, 5], [10, 3]],
    'y': [[11, 3]], 'Y': [[2, 5], [11, 3]],
    'j': [[12, 3]], 'J': [[2, 5], [12, 3]],

    ':': [[4, 4]], ';': [[4, 4], [4, 4]],
    '-': [[9, 4]], '_': [[2, 5], [9, 4]],

    ' ': [[10, 5]],
    '\n': [[11, 5]],

    ## Layered things
    # Hungarian
    'á': [[9, 5], [1, 2]],  'Á': [[2, 5], [9, 5], [1, 2]],
    'ó': [[9, 5], [2, 2]],  'Ó': [[2, 5], [9, 5], [2, 2]],
    'ő': [[9, 5], [2, 1]],  'Ő': [[2, 5], [9, 5], [2, 1]],
    'ö': [[9, 5], [2, 3]],  'Ö': [[2, 5], [9, 5], [2, 3]],
    'é': [[9, 5], [3, 2]],  'É': [[2, 5], [9, 5], [3, 2]],
    'ú': [[9, 5], [4, 2]],  'Ú': [[2, 5], [9, 5], [4, 2]],
    'ű': [[9, 5], [4, 1]],  'Ű': [[2, 5], [9, 5], [4, 1]],
    'ü': [[9, 5], [4, 3]],  'Ü': [[2, 5], [9, 5], [4, 3]],
    'í': [[9, 5], [5, 2]],  'Í': [[2, 5], [9, 5], [5, 2]],
}

def lookup_char(layer, ch):
    if ch in charmap:
        return charmap[ch]
    return None

def process_char(layer, ch, out=sys.stdout):
    keys = lookup_char(layer, ch)
    if not keys:
        print ("Unknown char: %s" % ch, file=sys.stderr)
    else:
        for (c, r) in keys:
            print ("KL: col=%d, row=%d, pressed=1, layer=%s" % (r, c, layer), file=out)
            print ("KL: col=%d, row=%d, pressed=0, layer=%s" % (r, c, layer), file=out)

def process_file(fn, layer, out=sys.stdout):
    with open(fn, "r") as f:
        ch = f.read(1)
        while ch:
            process_char(layer, ch, out)
            ch = f.read(1)

if sys.argv[1] == '-':
    out='/dev/stdin'
else:
    out=sys.argv[1]

if len(sys.argv) >= 2:
    layer = 'ADORE'
else:
    layer = sys.argv[2]

process_file(out, layer = layer)
