# ErgoDox EZ Configuration for typing like a boss.

This layout has 7 layers:
0. Base layers
1. Symbols and F-keys
2. Number pad (with hexadecimal)
3. Cursor keys
4. Mouse movement and clicks
5. Keyword macros
6. Emacs

There are also some leader keys defined for frequently used commands (git etc).

## The layers

Double hashes (`##`) indicate transparent keys (`KC_TRNS`) and blanks indicate no key (`KC_NO`).

### 0. Base layer

```
,--------------------------------------------------.           ,--------------------------------------------------.
| ESC    |   1  |   2  |   3  |   4  |   5  | SfLt |           | SfRt |   6  |   7  |   8  |   9  |   0  | BkSp   |
|--------|------|------|------|------|-------------|           |------|------|------|------|------|------|--------|
| Tab    |   Q  |   W  |   E  |   R  |   T  |  L1  |           |  L1  |   Y  |   U  |   I  |   O  |   P  | Del    |
|--------|------|------|------|------|------|      |           |      |------|------|------|------|------|--------|
| Caps/L2|   A  |   S  |   D  |   F  |   G  |------|           |------|   H  |   J  |   K  |   L  |   ;  |Enter/L2|
|--------|------|------|------|------|------|  L6  |           |  L6  |------|------|------|------|------|--------|
| LSft/( |   Z  |   X  |   C  | V/L3 | B/L4 |      |           |      | N/L4 | M/L3 |   ,  |   .  |   /  | RSft/) |
`--------|------|------|------|------|-------------'           `-------------|------|------|------|------|--------'
  |Ctrl/[| Alt/]|   #  | Left |Right |                                       |  Up  | Down |   -  | Alt/[|Ctrl/]|
  `----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |  L2  | lead |       | lead |  Ins |
                                ,------|------|------|       |------|------|------.
                                | Space| BkSp | Home |       | PgUp | Enter|Space |
                                |  /   |  /   |------|       |------|   /  |  /   |
                                | Ctrl | Alt  |End/L5|       |PDn/L5|  Alt | Ctrl |
                                `--------------------'       `--------------------'
```

Space Cadet shift is enabled. Ctrl and Alt doubles up as normal keys when tapped.  
SfLt and SfRt sends Shift + left and Shift + Right respectively - for use with emacs with `windmove-default-keybindings`.  
Caps and Enter may be held down to activate layer 2 (hexadecimal number pad).  
Please see `matrix_scan_user` function in `keymap.c` for list of commands available via `lead` key.

### 1. Symbols and F-keys

```
,--------------------------------------------------.           ,--------------------------------------------------.
|   ##   |  F1  |  F2  |  F3  |  F4  |  F5  |  ##  |           |  ##  |  F6  |  F7  |  F8  |  F9  |  F10 |   F11  |
|--------|------|------|------|------|------|------|           |------|------|------|------|------|------|--------|
|   ##   |   !  |   "  |   £  |   $  |   %  |  ##  |           |  ##  |   -  |   +  |   =  |   @  |   ~  |   F12  |
|--------|------|------|------|------|------|      |           |      |------|------|------|------|------|--------|
|   ##   |   ^  |   &  |   *  |   _  |   #  |------|           |------|   {  |   }  |   ;  |   '  |   #  |   ##   |
|--------|------|------|------|------|------|  ##  |           |  ##  |------|------|------|------|------|--------|
|   ##   |   \  |   |  |   `  |   -  |   /  |      |           |      |   [  |   ]  |   <  |   >  |   ?  |   ##   |
`--------|------|------|------|------|-------------'           `-------------|------|------|------|------|--------'
  |  ##  |  ##  |  ##  |  ##  |  ##  |                                       |  ##  |  ##  |  ##  |  ##  |  ##  |
  `----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |  ##  |  ##  |       |  ##  |  ##  |
                                ,------|------|------|       |------|------|------.
                                |      |      |  ##  |       |  ##  |      |      |
                                |  ##  |  ##  |------|       |------|  ##  |  ##  |
                                |      |      |  ##  |       |  ##  |      |      |
                                `--------------------'       `--------------------'
```

### 2. Number pad (with hexadecimal)

```
,---------------------------------------------------.           ,--------------------------------------------------.
|   ##    |  A   |  B   |  C   |  D   |  E   |  F   |           |  A   |  B   |  C   |  D   |   E  |   F  |   ##   |
|---------|------|------|------|------|------|------|           |------|------|------|------|------|------|--------|
|   ##    |  *   |  7   |  8   |  9   |  *   |  0x  |           |  0x  |  *   |   7  |   8  |   9  |   *  |   ##   |
|---------|------|------|------|------|------|      |           |      |------|------|------|------|------|--------|
|   ##    |  /   |  4   |  5   |  6   |  /   |------|           |------|  /   |   4  |   5  |   6  |   /  |   ##   |
|---------|------|------|------|------|------|  ##  |           |  ##  |------|------|------|------|------|--------|
|   ##    |  -   |  1   |  2   |  3   |  -   |      |           |      |  -   |   1  |   2  |   3  |   -  |   ##   |
`---------|------|------|------|------|-------------'           `-------------|------|------|------|------|--------'
  |   =   |  +   |  0   |  ,   |  .   |                                       |   0  |   ,  |   .  |   +  |  =   |
  `-----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |  ##  |  ##  |       |  ##  |  ##  |
                                ,------|------|------|       |------|------|------.
                                |      |      |  ##  |       |  ##  |      |      |
                                |  ##  |  ##  |------|       |------|  ##  |  ##  |
                                |      |      |  ##  |       |  ##  |      |      |
                                `--------------------'       `--------------------'
```

### 3. Cursor keys

```
,---------------------------------------------------.           ,--------------------------------------------------.
|         |      |      |      |      |      |      |           |      |      |      |      |      |      |        |
|---------|------|------|------|------|------|------|           |------|------|------|------|------|------|--------|
|         | Home |      |  Up  |      | PgUp |      |           |      | PgUp |      |  Up  |      | Home |        |
|---------|------|------|------|------|------|      |           |      |------|------|------|------|------|--------|
|         | End  | Left | Down | Right| PgDn |------|           |------| PgDn | Left | Down | Right| End  |        |
|---------|------|------|------|------|------|      |           |      |------|------|------|------|------|--------|
|   ##    |  Up  |      | Down |  ##  |      |      |           |      |      |  ##  | Down |      |  Up  |   ##   |
`---------|------|------|------|------|-------------'           `-------------|------|------|------|------|--------'
  | Left  | Down | Right|      |      |                                       |      |      | Left | Down | Right|
  `-----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |      |      |       |      |      |
                                ,------|------|------|       |------|------|------.
                                |      |      |      |       |      |      |      |
                                |  ##  |  ##  |------|       |------|  ##  |  ##  |
                                |      |      |      |       |      |      |      |
                                `--------------------'       `--------------------'
```

### 4. Mouse movement and clicks

```
,--------------------------------------------------.           ,--------------------------------------------------.
|        |      |      |      |      |      |      |           |      |      |      |      |      |      |        |
|--------|------|------|------|------|-------------|           |------|------|------|------|------|------|--------|
|        |      | Lclk | MsUp | Rclk |      |      |           |      |      | Lclk | MsUp | Rclk |      |        |
|--------|------|------|------|------|------|      |           |      |------|------|------|------|------|--------|
|        |      |MsLeft|MsDown|MsRght|      |------|           |------|      |MsLeft|MsDown|MsRght|      |        |
|--------|------|------|------|------|------|      |           |      |------|------|------|------|------|--------|
|  Lclk  | MsUp | Rclk |MsDown|      |  ##  |      |           |      |  ##  |      |MsDown| Lclk | MsUp | Rclk   |
`--------|------|------|------|------|-------------'           `-------------|------|------|------|------|--------'
  |MsLeft|MsDown|MsRight      |      |                                       |      |      |MsLeft|MsDown|MsRght|
  `----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |      |      |       |      |      |
                                ,------|------|------|       |------|------|------.
                                |      |      |      |       |      |      |      |
                                |      |      |------|       |------|      |      |
                                |      |      |      |       |      |      |      |
                                `--------------------'       `--------------------'
```

### 5. Keyword macros

```
,---------------------------------------------------.           ,--------------------------------------------------.
|         |      |      | scarf| sadf | smily|      |           |      | decaf|      |      |      |      |        |
|---------|------|------|------|------|------|------|           |------|------|------|------|------|------|--------|
|         | const| volat| oper |  ret | tmpl |      |           |      | typen| cont |  prv |  pro | pub  |        |
|---------|------|------|------|------|------|      |           |      |------|------|------|------|------|--------|
|         |      |  str |  obj |      | gitl |------|           |------|      |      |      | nulp |      |        |
|---------|------|------|------|------|------|      |           |      |------|------|------|------|------|--------|
|         |      | extr |  cls | virt | break|      |           |      |namesp| goodm| goodn|      |      |        |
`---------|------|------|------|------|-------------'           `-------------|------|------|------|------|--------'
  |       |      |  inc |      |      |                                       |      |      |      |      |      |
  `-----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |      |      |       | ecet | ecets|
                                ,------|------|------|       |------|------|------.
                                |      |      |      |       |      |      |      |
                                |      |      |------|       |------|      |      |
                                |      |      |  ##  |       |  ##  |      |      |
                                `--------------------'       `--------------------'
```
Please see `keymap.c` for the keywords/commands.
Some are const, volatile, operator, return, template, typename, continue, private,
protected, public, struct, class, extern, virtual, break, namespace.
Also a git log command I use a lot (`git log --oneline --graph --decorate=short` (I know git can be configured but that is boring)).

### 6. Emacs

```
,---------------------------------------------------.           ,--------------------------------------------------.
|         |      |      |      |      |      | empb |           | emnb | emfs | emfb |      |      |      |        |
|---------|------|------|------|------|------|------|           |------|------|------|------|------|------|--------|
|         | emtr |      |      |      |      |      |           |      | emun | emre | w-up |      |      |        |
|---------|------|------|------|------|------|      |           |      |------|------|------|------|------|--------|
|         |      | emwr |      |      |      |------|           |------|      |w-left|w-down|w-rght|      |        |
|---------|------|------|------|------|------|  ##  |           |  ##  |------|------|------|------|------|--------|
|         |      |      |      |      |      |      |           |      |      |      |w-down|      |      |        |
`---------|------|------|------|------|-------------'           `-------------|------|------|------|------|--------'
  |       |      |      |      |      |                                       |      |      |      |      |      |
  `-----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |      |      |       |      |      |
                                ,------|------|------|       |------|------|------.
                                |      |      |      |       |      |      |      |
                                |      |      |------|       |------|      |      |
                                |      |      |      |       |      |      |      |
                                `--------------------'       `--------------------'
```
Some emacs shortcuts like toggle read/write mode (emtr), write file (emwr), previous-buffer (empb),
next-buffer (emnb), smaller font(emfs), larger font (emfb), undo (emun), redo (emre) and switching between windows in a frame.
