/* Copyright 2019
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "xd96.h"

#define CAPS_PIN B6
#define NUMLOCK_PIN C6

void keyboard_pre_init_kb(void) {
  setPinOutput(CAPS_PIN);
  setPinOutput(NUMLOCK_PIN);

  keyboard_pre_init_user();
}

void led_set_kb(uint8_t usb_led) {
  if (IS_LED_ON(usb_led, USB_LED_CAPS_LOCK)) {
    writePinLow(CAPS_PIN);
  } else {
    writePinHigh(CAPS_PIN);
  }
  
  if (IS_LED_ON(usb_led, USB_LED_NUM_LOCK)) {
    writePinLow(NUMLOCK_PIN);
  } else {
    writePinHigh(NUMLOCK_PIN);
  }

  led_set_user(usb_led);
}
