#ifndef UK78_H
#define UK78_H

#include "quantum.h"

// readability
#define ____ KC_NO

/* Re: Right Shift
 *
 * Per a conversation I had on reddit with Rozakiin, matrix positions K312,
 * K313 and K314 are never in use all together at the same time.
 *
 * A 2.75u-sized right Shift uses position K313, rendering K312 and K314
 * inaccessible.
 *
 * A split right Shift, in either 1.75u/1u or 1u/1.75u (JIS layout) uses
 * positions K312 and K314, rendering K313 inaccessible.
 *
 *                                                            - @noroadsleft
 *                                                             July 13, 2018
 */

#define LAYOUT_all( \
	  K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015, K016, K017, K018, \
	  K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112,       K114, K115, K116, K117, K118, \
	  K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212,       K214, K215, K216, K217, K218, \
	  K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, K316, K317, K318, \
	  K400, K401, K402,                   K406,                   K410, K411, K412, K413, K414, K415, K416, K417, K418  \
) { \
  { K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015, K016, K017, K018 }, \
  { K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, ____, K114, K115, K116, K117, K118 }, \
  { K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, ____, K214, K215, K216, K217, K218 }, \
  { K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, K316, K317, K318 }, \
  { K400, K401, K402, ____, ____, ____, K406, ____, ____, ____, K410, K411, K412, K413, K414, K415, K416, K417, K418 } \
}

/* LAYOUT_ansi
 *
 * This layout uses:
 *
 *   - Split Backspace (K013 and K014)
 *   - ANSI Enter (K214)
 *   - ANSI 2.25u Left Shift (K300)
 *   - Compact right Shift (K312 and K314)
 *   - Two 1.5u modifiers (K410 and K412) between the spacebar and the Left
 *     arrow key
 * ,---------------------------------------------------------------------------.
 * |Esc|  1|  2|  3|  4|  5|  6|  7|  8|  9|  0| -_| =+| \||Bsp|Del|P/ |P* |P- |
 * |---------------------------------------------------------------------------|
 * |Tab  |  Q|  W|  E|  R|  T|  Y|  U|  I|  O|  P| [{| ]}|   \||P7 |P8 |P9 |P= |
 * |---------------------------------------------------------------------------|
 * |Caps  |  A|  S|  D|  F|  G|  H|  J|  K|  L| ;:| '"|   Enter|P4 |P5 |P6 |P+ |
 * |---------------------------------------------------------------------------|
 * |Shift   |  Z|  X|  C|  V|  B|  N|  M| ,<| .>| /?| Shift| Up|P1 |P2 |P3 |SLk|
 * |---------------------------------------------------------------------------|
 * |Ctrl|GUI |Alt |                        |  Alt|   Fn|Lft|Dwn|Rgh|P0 |P. |Ent|
 * `---------------------------------------------------------------------------'
 */
#define LAYOUT_ansi( \
	  K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014,     K015, K016, K017, K018, \
	  K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112,       K114,     K115, K116, K117, K118, \
	  K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211,             K214,     K215, K216, K217, K218, \
	  K300,       K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312,         K314,   K315, K316, K317, K318, \
	  K400, K401, K402,                   K406,                     K410,   K412,     K413, K414, K415,   K416, K417, K418  \
) { \
  { K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015, K016, K017, K018 }, \
  { K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, ____, K114, K115, K116, K117, K118 }, \
  { K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, ____, ____, K214, K215, K216, K217, K218 }, \
  { K300, ____, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, ____, K314, K315, K316, K317, K318 }, \
  { K400, K401, K402, ____, ____, ____, K406, ____, ____, ____, K410, ____, K412, K413, K414, K415, K416, K417, K418 } \
}

/* LAYOUT_iso
 *
 * This layout uses:
 *
 *   - Split Backspace (K013 and K014)
 *   - ISO Enter (K114)
 *   - ISO Left Shift and 1u (K300 and K301)
 *   - Compact right Shift (K312 and K314)
 *   - Two 1.5u modifiers (K410 and K412) between the spacebar and the Left
 *     arrow key
 * ,---------------------------------------------------------------------------.
 * |Esc|  1|  2|  3|  4|  5|  6|  7|  8|  9|  0| -_| =+| \||Bsp|Del|P/ |P* |P- |
 * |---------------------------------------------------------------------------|
 * |Tab  |  Q|  W|  E|  R|  T|  Y|  U|  I|  O|  P| [{| ]}|Enter|P7 |P8 |P9 |P= |
 * |------------------------------------------------------.    ----------------|
 * |Caps  |  A|  S|  D|  F|  G|  H|  J|  K|  L| ;:| '@| #~|    |P4 |P5 |P6 |P+ |
 * |---------------------------------------------------------------------------|
 * |Sft | \||  Z|  X|  C|  V|  B|  N|  M| ,<| .>| /?| Shift| Up|P1 |P2 |P3 |SLk|
 * |---------------------------------------------------------------------------|
 * |Ctrl|GUI |Alt |                        |  Alt|   Fn|Lft|Dwn|Rgh|P0 |P. |Ent|
 * `---------------------------------------------------------------------------'
 */
#define LAYOUT_iso( \
	  K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014,     K015, K016, K017, K018, \
	  K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112,       K114,     K115, K116, K117, K118, \
	  K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212,                 K215, K216, K217, K218, \
	  K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312,         K314,   K315, K316, K317, K318, \
	  K400, K401, K402,                   K406,                     K410,   K412,     K413, K414, K415,   K416, K417, K418  \
) { \
  { K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015, K016, K017, K018 }, \
  { K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, ____, K114, K115, K116, K117, K118 }, \
  { K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, ____, ____, K215, K216, K217, K218 }, \
  { K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, ____, K314, K315, K316, K317, K318 }, \
  { K400, K401, K402, ____, ____, ____, K406, ____, ____, ____, K410, ____, K412, K413, K414, K415, K416, K417, K418 } \
}

#endif
