#include QMK_KEYBOARD_H

enum layer_names {
  _QW,
  _L1,
  _L2,
};

#define CTL_TAB LCTL_T(KC_TAB)
#define L2_QUOT LT(_L2, KC_QUOT)
#define SFT_GRV LSFT_T(KC_GRV)

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
  /* 0: qwerty */
  /*┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬──────┐
    │Esc│ Q │ W │ E │ R │ T │ Y │ U │ I │ O │ P │ Bcksp│
    ├───┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬─────┤
    │Ctrl│ A │ S │ D │ F │ G │ H │ J │ K │ L │ ; │ Fn 2│
    ├────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬───┤
    │Shift │ Z │ X │ C │ V │ B │ N │ M │ , │ . │ / │Shf│
    ├────┬─┴───┼───┴┬──┴───┴─┬─┴───┴─┬─┴──┬┴───┴┬──┴───┤
    │Fn  │  Alt│ Cmd│ Return │ Space │Cmd │Hyper│  Ctrl│
    └────┴─────┴────┴────────┴───────┴────┴─────┴──────┘*/
  [_QW] = LAYOUT( /* Qwerty */
    KC_ESC,  KC_Q,    KC_W,    KC_E,    KC_R,    KC_T,    KC_Y,    KC_U,    KC_I,    KC_O,    KC_P,    KC_BSPC,
    CTL_TAB, KC_A,    KC_S,    KC_D,    KC_F,    KC_G,    KC_H,    KC_J,    KC_K,    KC_L,    KC_SCLN, L2_QUOT,
    SFT_GRV, KC_Z,    KC_X,    KC_C,    KC_V,    KC_B,    KC_N,    KC_M,    KC_COMM, KC_DOT,  KC_SLSH, KC_RSFT,
    MO(_L1), KC_LALT, KC_LGUI,                   KC_ENT,  KC_SPC,                    KC_RGUI, KC_HYPR, KC_RCTL
  ),
  /* 1: fn */
  /*┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬──────┐
    │ ` │ 1 │ 2 │ 3 │ 4 │ 5 │ 6 │ 7 │ 8 │ 9 │ 0 │   Del│
    ├───┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬─────┤
    │    │   │   │   │   │   │ ◀ │ ▼ │ ▲ │ ▶ │   │     │
    ├────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬───┤
    │      │   │   │   │   │   │   │   │ [ │ ] │ \ │   │
    ├────┬─┴───┼───┴┬──┴───┴─┬─┴───┴─┬─┴──┬┴───┴┬──┴───┤
    │    │     │    │        │       │    │     │      │
    └────┴─────┴────┴────────┴───────┴────┴─────┴──────┘*/
  [_L1] = LAYOUT( /* LAYER 1 */
    KC_GRV,  KC_1,    KC_2,    KC_3,    KC_4,    KC_5,    KC_6,    KC_7,    KC_8,    KC_9,    KC_0,    KC_DEL,
    _______, _______, _______, _______, _______, _______, KC_LEFT, KC_DOWN, KC_UP,   KC_RGHT, _______, _______,
    _______, _______, _______, _______, _______, _______, _______, _______, KC_LBRC, KC_RBRC, KC_BSLS, _______,
    _______, _______, _______,                   _______, _______,                   _______, _______, _______
  ),
  /* 2: fn 2 */
  /*┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬──────┐
    │ § │Br-│Br+│   │   │   │   │   │   │ - │ = │ Eject│
    ├───┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬─────┤
    │    │   │   │   │   │   │Hom│PgD│PgU│End│Ins│     │
    ├────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬───┤
    │      │   │   │   │   │Prv│Nxt│Mut│Vo-│Vo+│   │   │
    ├────┬─┴───┼───┴┬──┴───┴─┬─┴───┴─┬─┴──┬┴───┴┬──┴───┤
    │    │     │    │        │ Pause │    │     │      │
    └────┴─────┴────┴────────┴───────┴────┴─────┴──────┘*/
  [_L2] = LAYOUT( /* LAYER 2 */
    KC_NUBS, KC_BRID, KC_BRIU, _______, RESET,   _______, _______, _______, _______, KC_MINS, KC_EQL,  KC_EJCT,
    _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, KC_INS,  _______,
    _______, _______, _______, _______, _______, KC_MPRV, KC_MNXT, KC_MUTE, KC_VOLD, KC_VOLU, _______, _______,
    _______, _______, _______,                   _______, KC_MPLY,                   _______, _______, _______
  ),
};
