# Mekberg's TADA68 layout

More or less a standard Swedish ISO layout, with Mac-centric key positions. All keys not assigned on non-default layers are set to KC_NO
as I don't want them to pass through when activating a layer.

# Layers

### Base Layer

```
,----------------------------------------------------------------------------------------------------------------------------------------------.
|  Esc   |    1   |    2   |    3   |    4   |    5   |    6   |    7   |    8   |    9   |    0   |    +   |    ´   |   Backspace    |  Home  |
|----------------------------------------------------------------------------------------------------------------------------------------------|
|    Tab     |    Q   |    W   |    E   |    R   |    T   |    Y   |    U   |    I   |    O   |    P   |    Å   |    ¨   |            |  End   |
|--------------------------------------------------------------------------------------------------------------------------|          |--------|
|    LCtrl     |    A   |    S   |    D   |    F   |    G   |    H   |    J   |    K   |    L   |   Ö    |   Ä    |   '    |   Enter  |  PgUp  |
|----------------------------------------------------------------------------------------------------------------------------------------------|
|  LShift  |   <>   |    Z   |   X    |   C    |    V   |    B   |    N   |    M   |   ,    |   .    |   -    |   RShift     |   Up   |  PgDn  |
|----------------------------------------------------------------------------------------------------------------------------------------------|
|  LCtrl   |   LAlt   | Command  |                        Space                          |Command |  RAlt  |  Fn    |  Left  |  Down  | Right  |
`----------------------------------------------------------------------------------------------------------------------------------------------'
```

### Fn Layer (layer 1)

```
,----------------------------------------------------------------------------------------------------------------------------------------------.
|        |   F1   |   F2   |   F3   |   F4   |   F5   |   F6   |   F7   |   F8   |   F9   |  F10   |  F11   |  F12   |     Delete     |  Ins   |
|----------------------------------------------------------------------------------------------------------------------------------------------|
|            |        |   Up   |        |        |        |        |        |        |        |        |        |        |            |  Mute  |
|--------------------------------------------------------------------------------------------------------------------------|          |--------|
|  Caps Lock   |  Left  |  Down  | Right  | BLight |        |        |        |        |        |        |        |        |          | VolUp  |
|----------------------------------------------------------------------------------------------------------------------------------------------|
|          |        |        |        |  Bl-   |BLtoggle | Bl+   |        |        |        |        |        |              |  Stop  | VolDn  |
|----------------------------------------------------------------------------------------------------------------------------------------------|
|          |          |          |                                                       |        |        |        |  Prev  |  Play  |  Fwd   |
`----------------------------------------------------------------------------------------------------------------------------------------------'
```

Mainly used for media keys and F-keys, as well as a nav cluster on WASD. Also has backlight keys, that are rarely used.

### Modtap Tab Layer (layer 2)

```
,----------------------------------------------------------------------------------------------------------------------------------------------.
|   Esc  |   F1   |   F2   |   F3   |   F4   |   F5   |   F6   |   F7   |   F8   |   F9   |  F10   |  F11   |  F12   |     Delete     |        |
|----------------------------------------------------------------------------------------------------------------------------------------------|
|            |        |   Up   |        |        |        |        |        |        |        |        |        |        |            |  Mute  |
|--------------------------------------------------------------------------------------------------------------------------|          |--------|
|              |  Left  |  Down  | Right  |        |        |  Left  |  Down  |   Up   | Right  |        |        |        |          | VolUp  |
|----------------------------------------------------------------------------------------------------------------------------------------------|
|          |        |        |        |        |        |        |        |        |        |        |        |              | Stop   | VolDn  |
|----------------------------------------------------------------------------------------------------------------------------------------------|
|          |          |          |                                                       |        |        |        |  Prev  |  Play  |  Fwd   |
`----------------------------------------------------------------------------------------------------------------------------------------------'
```

Tab acts as Tab when tapped, and as Layer 2 when held. Used for HJKL nav keys and Delete.
