#ifndef SIXKEYBOARD_H
#define SIXKEYBOARD_H

#include "quantum.h"

// This macro is an example of using a non-standard row-column matrix. The
// keyboard in question had 11 rows and 8 columns, but the rows were not all
// horizontal, and the columns were not all vertical. For example, row 2
// contained "Print Screen", "N", "M", ",", ".", "/", "Right Shift", and
// "Left Alt". Column 0 contained "F6", "7", "O", "'", "Q", "D", "B",
// "Left Alt", "Up Arrow", and "Down Arrow".
//
// The macro makes programming the keys easier and in a more straight-forward
// manner because it realigns the keys into a 6x15 sensible keyboard layout
// instead of the obtuse 11x8 matrix.


/*
 * ┌───┬───┬───┐
 * │ A │ B │ C │
 * ├───┼───┼───┤
 * │ D │ E │ F │
 * └───┴───┴───┘
 */
#define LAYOUT( \
    k00, k01, k02, \
    k10, k11, k12  \
  ) { \
    { k00, k01, k02 }, \
    { k10, k11, k12 }  \
}


#endif
