# Bluebear’s custom S60X layout

Custom keyboard layout for my S60X, my first ever custom mechanical keyboard kit.

This layout was inspired in part by the HHKB line of keyboards and a quest to find the perfect ergonomic, logical layout for what I do. If you like this layout, please feel free to use it, modify it and share it.

## [BASE Layer](http://www.keyboard-layout-editor.com/##@_name=S60X%20-%20Bluebear%20-%20BASE%20layer&author=Ante%20Laurijssen&switchMount=cherry&switchBrand=outemu&switchType=PG150Q01-1&plate:true;&@_c=#ff7a00&fa@:0&:0&:0&:0&:0&:0&:0&:0&:0&:0&:9;;&=Esc%0A%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Ci%20class/=%27kb%20kb-logo-commodore%27%3E%3C//i%3E&_c=#cccccc;&=!%0A1&=/@%0A2&=#%0A3&=$%0A4&=%25%0A5&=%5E%0A6&=/&%0A7&=*%0A8&=(%0A9&=)%0A0&=%7B%0A%5B&=%7D%0A%5D&=%7C%0A%5C&=~%0A%60;&@_w:1.5;&=Tab&=%22%0A%27&=%3C%0A,&=%3E%0A.&=P&=Y&=F&=G&=C&=R&=L&=?%0A//&=+%0A/=&_w:1.5;&=Backspace;&@_w:1.75;&=Ctrl%20(hold)%0AEsc%20%20(tap)&=A&=O&=E&=U&=I&=D&=H&=T&=N&=S&=/_%0A-&_w:2.25;&=Enter%20(tap)%0ACtrl%20(hold);&@_w:2.25;&=Shift%20(hold)%0A(%20(tap)&=/:%0A/;&=Q&=J&=K&=X&=B&=M&=W&=V&=Z&_w:2.75;&=Shift%20(hold)%0A)%20(tap);&@_w:1.25;&=Mouse%20Layer%20(hold)&_w:1.25;&=Win&_w:1.25;&=Alt&_a:5&w:6.25;&=Space%20(tap)%0AArrowFN%20Layer%20(hold)&_a:4&w:1.25;&=AltGr(h)%0AComp%20(t)&_w:1.25;&=Win&_w:1.25;&=Ctrl%20+%20Shift%20(oneshot)&_w:1.25;&=Ctrl%20+%20Alt%20(oneshot))

- Dvorak keyboard layout
- Hold left control key for LCTL, and tap it for ESC
- Hold enter key for RCTL and tap for ENT
- Hold the space key to momentarily switch to ARROWFN layer
- Left bottom key acts as momentary switch to the MOUSE layer
- Hold right alt key for AltGr and tap for APP(which I have mapped to Compose in OS)
- Hold left shift key for LSFT and tap for ( (Space Cadet style)
- Hold right shift key for RSFT and tap for ) (Space Cadet style)
- Tap key on bottom row, second from the right (where APP usually is) to get CTL-Shift (one shot modifier - next key pressed will be modified by ctl-shift)
- Tap key on bottom right to get CTL-Alt (one shot modifier - next key pressed will be modified by ctl-alt)

## [ARROWFN Layer](http://www.keyboard-layout-editor.com/##@_name=S60X%20-%20Bluebear%20-%20ARROWFN%20Layer&author=Ante%20Laurijssen&switchMount=cherry&switchBrand=outemu&switchType=PG150Q01-1&plate:true%3B&@_c=%23ff6b00&fa@:0&:0&:0&:0&:0&:0&:0&:0&:0&:0&:9%3B%3B&=Esc%0A%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Ci%20class%2F=%27kb%20kb-logo-commodore%27%3E%3C%2F%2Fi%3E&_c=%23cccccc%3B&=F1&=F2&=F3&=F4&=F5&=F6&=F7&=F8&=F9&=F0&=F11&=F12&=To%20MIDI%20Layer&=To%20MORSE%20Layer%3B&@_a:7&w:1.5%3B&=&=&=&=&=&=&=&_a:4%3B&=PgUp&=%3Ci%20class%2F=%27kb%20kb-Arrows-Up%27%3E%3C%2F%2Fi%3E&_a:7%3B&=&=&=&_a:4%3B&=Ins&_w:1.5%3B&=Delete%3B&@_w:1.75%3B&=Caps%20Lock&=Home&_a:7%3B&=&_a:4%3B&=End&_a:7%3B&=&=&=&_a:4%3B&=%3Ci%20class%2F=%27kb%20kb-Arrows-Left%27%3E%3C%2F%2Fi%3E&=%3Ci%20class%2F=%27kb%20kb-Arrows-Down%27%3E%3C%2F%2Fi%3E&=%3Ci%20class%2F=%27kb%20kb-Arrows-Right%27%3E%3C%2F%2Fi%3E&_a:7%3B&=&=&_a:4&w:2.25%3B&=Enter%3B&@_a:7&w:2.25%3B&=&=&=&=&=&=&_a:4%3B&=Space&=PgDn&=Print%20Screen&=Scroll%20Lock&=Pause&_a:7&w:2.75%3B&=%3B&@_w:1.25%3B&=&_w:1.25%3B&=&_w:1.25%3B&=&_w:6.25%3B&=&_w:1.25%3B&=&_w:1.25%3B&=&_w:1.25%3B&=&_w:1.25%3B&=)

- Number row becomes F1 to F12
- C, T, H, N keys become Up, Down, Left, Right (equivalent to IJKL on QWERTY keyboard)
- Access to various other keys normally found on a full sized keyboard (INS, DEL, PSCR, SLCK, PAUSE, PGUP, PGDN, HOME, END)
- Top right button toggles MORSE layer
- Second from right, top row, toggles MIDI_BASE layer
- Holding Space-B lets you send Space repeatedly
- Hitting the LCTL button in this layer toggles caps lock

## [MOUSE Layer](http://www.keyboard-layout-editor.com/##@_name=S60X%20-%20Bluebear%20-%20MOUSE%20Layer&author=Ante%20Laurijssen&switchMount=cherry&switchBrand=outemu&switchType=PG150Q01-1&plate:true;&@_c=#ff7f08&fa@:0&:0&:0&:0&:0&:0&:0&:0&:0&:0&:9;;&=Reset%0A%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Ci%20class/=%27kb%20kb-logo-commodore%27%3E%3C//i%3E&_c=#cccccc;&=F13&=F14&=F15&=F16&=F17&=F18&=F19&=F20&=F21&=F22&=F23&=F24&_a:7;&=&=;&@_a:4&w:1.5;&=Debug&_a:7;&=&=&=&=&=&=&_a:4;&=Mouse%20Button%201&_f:3;&=Mouse%0A%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Ci%20class/=%27kb%20kb-Arrows-Up%27%3E%3C//i%3E&=Mouse%20Button%202&_f:3;&=Mouse%20Wheel%0A%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Ci%20class/=%27kb%20kb-Arrows-Up%27%3E%3C//i%3E&_a:7;&=&=&_w:1.5;&=;&@_a:4&w:1.75;&=Ctl+%0ADel%0A%0A%0A%0A%0AAlt+&_a:7;&=&=&=&=&=&=&_a:4&f:3;&=Mouse%0A%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Ci%20class/=%27kb%20kb-Arrows-Left%27%3E%3C//i%3E&_f:3;&=Mouse%0A%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Ci%20class/=%27kb%20kb-Arrows-Down%27%3E%3C//i%3E&_f:3;&=Mouse%0A%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Ci%20class/=%27kb%20kb-Arrows-Right%27%3E%3C//i%3E&_f:3;&=Mouse%20Wheel%0A%0A%0A%0A%0A%0A%0A%0A%0A%0A%3Ci%20class/=%27kb%20kb-Arrows-Down%27%3E%3C//i%3E&=Mouse%20Button%203&_a:7&w:2.25;&=;&@_a:4&w:2.25;&=Magic%0AToggle%0A%0A%0A%0A%0ASysRq&_a:7;&=&=&=&=&=&=&=&=&=&=&_w:2.75;&=;&@_w:1.25;&=&_w:1.25;&=&_w:1.25;&=&_a:5&w:6.25;&=Power&_a:7&w:1.25;&=&_w:1.25;&=&_w:1.25;&=&_w:1.25;&=)

- Move the mouse with mouse keys
- Hitting the escape key in this layer will give RESET, which puts the controller into dfu mode for flashing firmware onto it
- If Debug is enabled, hitting the TAB key in this layer activates debugging to the console when listening with hid-listen
- TFS button (Three Finger Salute) sends Ctl-Alt-Del
- MAGSYS toggles the Magic SysRq key (works only in Linux)
- Hitting the space key in this layer is like hitting power button on computer
- Number row becomes F13 to F24

## [MIDI_BASE Layer](http://www.keyboard-layout-editor.com/##@_name=S60X%20-%20Bluebear%20-%20MIDI%20BASE%20Layer&author=Ante%20Laurijssen&switchMount=cherry&switchBrand=outemu&switchType=PG150Q01-1&plate:true;&@_c=#ff8300&a:5&fa@:9;;&=%3Ci%20class/=%27kb%20kb-logo-commodore%27%3E%3C//i%3E%0ABASE%0A%0A%0ALayer&_c=#cccccc&a:4&f:3;&=%F0%9F%8E%B6%0ACmaj&_f:3;&=%F0%9F%8E%B6%0AGmaj&_f:3;&=%F0%9F%8E%B6%0ADmaj&_f:3;&=%F0%9F%8E%B6%0AAmaj&_f:3;&=%F0%9F%8E%B6%0AEmaj&_f:3;&=%F0%9F%8E%B6%0ABmaj&_f:3;&=%F0%9F%8E%B6%0AF#maj%0A%0A%0A%0A%0AGbmaj//&_f:3;&=%F0%9F%8E%B6%0AC#maj%0A%0A%0A%0A%0ADbmaj//&_f:3;&=%F0%9F%8E%B6%0AG#maj%0A%0A%0A%0A%0AAbmaj&_f:3;&=%F0%9F%8E%B6%0AD#maj%0A%0A%0A%0A%0AEbmaj//&_f:3;&=%F0%9F%8E%B6%0AA#maj%0A%0A%0A%0A%0ABbmaj//&_f:3;&=%F0%9F%8E%B6%0AFmaj&_a:7;&=&_a:4&f:3;&=To%0AChord%0A%0A%0A%0A%0AMidi;&@_f:3&w:1.5;&=Octave%20Up&_a:7;&=&_a:4&f:3;&=%E2%99%A9%0AC#//Db&_f:3;&=%E2%99%A9%0AD#//Eb&_a:7;&=&_a:4&f:3;&=%E2%99%A9%0AF#//Gb&_f:3;&=%E2%99%A9%0AG#//Ab&_f:3;&=%E2%99%A9%0AA#//Bb&_a:7;&=&_a:4&f:3;&=%E2%99%A9%0AD1b%0A%0A%0A%0A%0AC1#//&_f:3;&=%E2%99%A9%0AE1b%0A%0A%0A%0A%0AD1#//&_a:7;&=&=&_w:1.5;&=;&@_a:4&f:3&w:1.75;&=Octave%20Down&_f:3;&=%E2%99%A9%0AC&_f:3;&=%E2%99%A9%0AD&_f:3;&=%E2%99%A9%0AE&_f:3;&=%E2%99%A9%0AF&_f:3;&=%E2%99%A9%0AG&_f:3;&=%E2%99%A9%0AA&_f:3;&=%E2%99%A9%0AB&_f:3;&=%E2%99%A9%0AC1&_f:3;&=%E2%99%A9%0AD1&_f:3;&=%E2%99%A9%0AE1&_f:3;&=%E2%99%A9%0AF1&_a:7&w:2.25;&=;&@_a:4&f:3&w:2.25;&=%F0%9F%8E%B6%0ACm&_f:3;&=%F0%9F%8E%B6%0AGm&_f:3;&=%F0%9F%8E%B6%0ADm&_f:3;&=%F0%9F%8E%B6%0AAm&_f:3;&=%F0%9F%8E%B6%0AEm&_f:3;&=%F0%9F%8E%B6%0ABm&_f:3;&=%F0%9F%8E%B6%0AF#m%0A%0A%0A%0A%0AGbm//&_f:3;&=%F0%9F%8E%B6%0AC#m%0A%0A%0A%0A%0ADbm//&_f:3;&=%F0%9F%8E%B6%0AG#m%0A%0A%0A%0A%0AAbm//&_f:3;&=%F0%9F%8E%B6%0AD#m%0A%0A%0A%0A%0AEbm&_f:3;&=%F0%9F%8E%B6%0AA#m%0A%0A%0A%0A%0ABbm//&_f:3&w:2.75;&=%F0%9F%8E%B6%0AFm;&@_a:7&w:1.25;&=&_w:1.25;&=&_w:1.25;&=&_a:5&f:3&w:6.25;&=All%20notes%20off&_a:7&w:1.25;&=&_w:1.25;&=&_w:1.25;&=&_w:1.25;&=)

This layer was inspired by the [Satan Midi layout](https://github.com/qmk/qmk_firmware/tree/master/keyboards/satan/keymaps/midi) and gives access to basic MIDI notes. What I added were two layers of MIDI chords (major and minor triads) arranged in a circle of fifths pattern. Thanks to @fredizzimo for helping me with the code for these.

- Top right button toggles MORSE_CHORDS layer
- Escape brings you back to the BASE layer

## [MIDI_CHORD Layer](http://www.keyboard-layout-editor.com/##@_name=S60X%20-%20Bluebear%20-%20MIDI%20CHORD%20Layer&switchMount=cherry&switchBrand=outemu&switchType=PG150Q01-1&plate:true&pcb:false;&@_c=#ff8300&a:5&fa@:9;;&=%3Ci%20class/=%27kb%20kb-logo-commodore%27%3E%3C//i%3E%0ABASE%0A%0A%0ALayer&_c=#cccccc&a:4&f:3;&=%F0%9F%8E%B6%0ACmaj&_f:3;&=%F0%9F%8E%B6%0AGmaj&_f:3;&=%F0%9F%8E%B6%0ADmaj&_f:3;&=%F0%9F%8E%B6%0AAmaj&_f:3;&=%F0%9F%8E%B6%0AEmaj&_f:3;&=%F0%9F%8E%B6%0ABmaj&_f:3;&=%F0%9F%8E%B6%0AF#maj%0A%0A%0A%0A%0AGbmaj//&_f:3;&=%F0%9F%8E%B6%0AC#maj%0A%0A%0A%0A%0ADbmaj//&_f:3;&=%F0%9F%8E%B6%0AG#maj%0A%0A%0A%0A%0AAbmaj&_f:3;&=%F0%9F%8E%B6%0AD#maj%0A%0A%0A%0A%0AEbmaj//&_f:3;&=%F0%9F%8E%B6%0AA#maj%0A%0A%0A%0A%0ABbmaj//&_f:3;&=%F0%9F%8E%B6%0AFmaj&_f:3;&=To%20Midi%20Base&_a:7;&=;&@_a:4&f:3&w:1.5;&=Octave%20Up&_f:3;&=%F0%9F%8E%B6%0ACm&_f:3;&=%F0%9F%8E%B6%0AGm&_f:3;&=%F0%9F%8E%B6%0ADm&_f:3;&=%F0%9F%8E%B6%0AAm&_f:3;&=%F0%9F%8E%B6%0AEm&_f:3;&=%F0%9F%8E%B6%0ABm&_f:3;&=%F0%9F%8E%B6%0AF#m%0A%0A%0A%0A%0AGbm//&_f:3;&=%F0%9F%8E%B6%0AC#m%0A%0A%0A%0A%0ADbm//&_f:3;&=%F0%9F%8E%B6%0AG#m%0A%0A%0A%0A%0AAbm//&_f:3;&=%F0%9F%8E%B6%0AD#m%0A%0A%0A%0A%0AEbm//&_f:3;&=%F0%9F%8E%B6%0AA#m%0A%0A%0A%0A%0ABbm//&_f:3;&=%F0%9F%8E%B6%0AFm&_a:7&w:1.5;&=;&@_a:4&f:3&w:1.75;&=Octave%20Down&_f:3;&=%F0%9F%8E%B6%0AC7&_f:3;&=%F0%9F%8E%B6%0AG7&_f:3;&=%F0%9F%8E%B6%0AD7&_f:3;&=%F0%9F%8E%B6%0AA7&_f:3;&=%F0%9F%8E%B6%0AE7&_f:3;&=%F0%9F%8E%B6%0AB7&_f:3;&=%F0%9F%8E%B6%0AF#7%0A%0A%0A%0A%0AGb7//&_f:3;&=%F0%9F%8E%B6%0AC#7%0A%0A%0A%0A%0ADb7//&_f:3;&=%F0%9F%8E%B6%0AG#7%0A%0A%0A%0A%0AAb7//&_f:3;&=%F0%9F%8E%B6%0AD#7%0A%0A%0A%0A%0AEb7//&_f:3;&=%F0%9F%8E%B6%0AA#7%0A%0A%0A%0A%0ABb7//&_f:3&w:2.25;&=%F0%9F%8E%B6%0AF7;&@_f:3&w:2.25;&=%F0%9F%8E%B6%0ACdim7&_f:3;&=%F0%9F%8E%B6%0AGdim7&_f:3;&=%F0%9F%8E%B6%0ADdim7&_f:3;&=%F0%9F%8E%B6%0AAdim7&_f:3;&=%F0%9F%8E%B6%0AEdim7&_f:3;&=%F0%9F%8E%B6%0ABdim7&_f:3;&=%F0%9F%8E%B6%0Adim7%0A%0A%0A%0A%0AGb&_f:3;&=%F0%9F%8E%B6%0Adim7%0A%0A%0A%0A%0ADb&_f:3;&=%F0%9F%8E%B6%0Adim7%0A%0A%0A%0A%0AAb&_f:3;&=%F0%9F%8E%B6%0Adim7%0A%0A%0A%0A%0AEb&_f:3;&=%F0%9F%8E%B6%0Adim7%0A%0A%0A%0A%0ABb&_f:3&w:2.75;&=%F0%9F%8E%B6%0AFdim7;&@_a:7&w:1.25;&=&_w:1.25;&=&_w:1.25;&=&_a:5&f:3&w:6.25;&=All%20notes%20off&_a:7&w:1.25;&=&_w:1.25;&=&_w:1.25;&=&_w:1.25;&=)

After figuring out how to code my MIDI chord function, I decided to dedicate a full layer to these chords. This chord layout was inspired by the [Stradella Base system](https://en.wikipedia.org/wiki/Stradella_bass_system) found on accordions. This layer is a tool for musical composition and songwriting. Originally, I had written the chord functions using the F(n) functions, but finally ended up using process_record_user and custom keycodes. I think this was a more efficient and elegant way of coding these.

- Second from right, top row, toggles MIDI_BASE layer
- Escape brings you back to the BASE layer

## [MORSE LAYER](http://www.keyboard-layout-editor.com/##@_name=S60X%20-%20Bluebear%20-%20MORSE%20Layer&author=Ante%20Laurijssen&switchMount=cherry&switchBrand=outemu&switchType=PG150Q01-1&plate:true;&@_c=#ff8a00&a:5&fa@:9;;&=%3Ci%20class/=%27kb%20kb-logo-commodore%27%3E%3C//i%3E%0ABASE%0A%0A%0ALayer&_c=#cccccc&a:4&fa@:5&:5;;&=-.-.--%0A.----&=.--.-.%0A..---&=%0A...--&=...-..-%0A....-&=%0A.....&=%0A-....&=.-...%0A--...&=%0A---..&=-.--.%0A----.&=-.--.-%0A-----&_a:7;&=&=&=&=;&@_w:1.5;&=&_a:4;&=.-..-.%0A.----.&=%0A--..--&=%0A.-.-.-&=.--.&=-.--&=..-.&=--.&=-.-.&=.-.&=.-..&=..--..%0A-..-.&=.-.-.%0A-...-&_f:3&w:1.5;&=Backspace;&@_a:7&w:1.75;&=&_a:4&f:3;&=.-&_f:3;&=---&_f:3;&=.&_f:3&n:true;&=..-&_f:3;&=..&_f:3;&=-..&_f:3&n:true;&=....&_f:3;&=-&_f:3;&=-.&_f:3;&=...&_f:3;&=..--.-%0A-....-&_f:3&w:2.25;&=Enter;&@_f:3&w:2.25;&=Shift&_f:3;&=---...%0A-.-.-.&_f:3;&=--.-&_f:3;&=.---&_f:3;&=-.-&_f:3;&=-..-&_f:3;&=-...&_f:3;&=--&_f:3;&=.--&_f:3;&=...-&_f:3;&=--..&_f:3&w:2.75;&=Shift;&@_a:7&w:1.25;&=&_w:1.25;&=&_w:1.25;&=&_a:5&f:3&w:6.25;&=Space%20(%5C%20)&_a:7&w:1.25;&=&_w:1.25;&=&_w:1.25;&=&_w:1.25;&=)

This layer is really just for fun, and because I am a ham radio operator and morse code enthusiast. Hitting the alphanumerical keys in this layer will send a series of dits (.) and dahs (-) representing that character in morse code. This is all done through M(n). There are also a couple of characters that are sent through a shifted key on a regular layout, like @ or !. The same applies on this layer. And because I type using the Dvorak layout, this layer is also arranged in this manner. 

- Escape brings you back to the BASE layer

### THIS IS STILL A WORK IN PROGRESS

This keyboard layout is still a work in progress and there are a couple of kinks left to iron out. But it is still very usable and the midi and morse code layers are lots of fun to use. Please feel free to use, share and improve all, or part of this layout.





