#pragma once

#include "config_common.h"

/* USB Device descriptor parameter */
#define VENDOR_ID       0xFEED
#define PRODUCT_ID      0x6090
#define DEVICE_VER      0x0002
#define MANUFACTURER    SpaceCityKeyboards
#define PRODUCT         GTM Pad
#define DESCRIPTION     Grand Theft Macro Pad

/* key matrix size */
#define MATRIX_ROWS 3
#define MATRIX_COLS 6

/* key matrix pins */
#define MATRIX_ROW_PINS { C4, C5, D1 }
#define MATRIX_COL_PINS { B4, B5, B6, B7, C7, D0 }
#define UNUSED_PINS


#define ENCODERS_PAD_A { D2 }
#define ENCODERS_PAD_B { D3 }
#define ENCODER_RESOLUTION 1

/* COL2ROW or ROW2COL */
#define DIODE_DIRECTION COL2ROW

/* Set 0 if debouncing isn't needed */
#define DEBOUNCE 5

/* Mechanical locking support. Use KC_LCAP, KC_LNUM or KC_LSCR instead in keymap */
#define LOCKING_SUPPORT_ENABLE

/* Locking resynchronize hack */
#define LOCKING_RESYNC_ENABLE


#ifdef RGBLIGHT_ENABLE
#define RGB_DI_PIN B0
#define RGBLIGHT_ANIMATIONS
#define RGBLED_NUM 4
#endif
