#pragma once

#include "quantum.h"

#define ____ KC_NO

/* ANSI
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |           |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301,       K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, ____, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ANSI with small shift
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_small_lshift( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ANSI with small backspace
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |           |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301,       K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, ____, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ANSI with small shift and small backspace
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_small_lshift_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* **************************************************************************************************************************************** */
/* ANSI with 1u keys in the bottom row
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |           |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |      |      |      |     |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_1u( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301,       K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411, K412, K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, ____, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, K412, K413, K414, K415 }  \
}

/* ANSI with small shift and 1u keys in the bottom row
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |      |      |      |     |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_1u_small_lshift( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411, K412, K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, K412, K413, K414, K415 }  \
}

/* ANSI with small backspace and 1u keys in the bottom row
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |           |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |      |      |      |     |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_1u_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301,       K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411, K412, K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, ____, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, K412, K413, K414, K415 }  \
}

/* ANSI with small shift and small backspace and 1u keys in the bottom row
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |      |      |      |     |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_1u_small_lshift_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411, K412, K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, K412, K413, K414, K415 }  \
}

/* **************************************************************************************************************************************** */
/* ANSI with 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |           |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |         |                                       |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_7u( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301,       K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402,                     K407,                 K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, ____, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, ____, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ANSI with small shift and 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |         |                                       |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_7u_small_lshift( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402,                     K407,                 K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, ____, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ANSI with small backspace and 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |           |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |         |                                       |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_7u_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301,       K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402,                     K407,                 K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, ____, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, ____, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ANSI with small shift and small backspace and 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |         |                                       |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_ansi_7u_small_lshift_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402,                     K407,                 K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, ____, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* **************************************************************************************************************************************** */
/* ANSI with blocker
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |           |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |       |      |    |      |     |     |
 * `------'   `--------------------------------------------------------------------------    -------------------'
 */

#define LAYOUT_ansi_blocker( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301,       K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, ____, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ANSI with blocker and small shift
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |       |      |    |      |     |     |
 * `------'   `--------------------------------------------------------------------------    -------------------'
 */

#define LAYOUT_ansi_blocker_small_lshift( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ANSI with blocker and small backspace
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |           |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |       |      |    |      |     |     |
 * `------'   `--------------------------------------------------------------------------    -------------------'
 */

#define LAYOUT_ansi_blocker_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301,       K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, ____, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ANSI with blocker and small shift and small backspace
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |       |      |    |      |     |     |
 * `------'   `--------------------------------------------------------------------------    -------------------'
 */

#define LAYOUT_ansi_blocker_small_lshift_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* **************************************************************************************************************************************** */
/* ANSI with blocker and 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |           |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |     |         |                                       |         |    |     |     |     |
 * `------'   `---------------------------------------------------------------------------    ------------------'
 */

#define LAYOUT_ansi_blocker_7u( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301,       K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,               K407,                 K410,             K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, ____, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, ____, ____, K413, K414, K415 }  \
}

/* ANSI with blocker and small shift and 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |     |         |                                       |         |    |     |     |     |
 * `------'   `---------------------------------------------------------------------------    ------------------'
 */

#define LAYOUT_ansi_blocker_7u_small_lshift( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,               K407,                 K410,             K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, ____, ____, K413, K414, K415 }  \
}

/* ANSI with blocker and small backspace and 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |           |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |     |         |                                       |         |    |     |     |     |
 * `------'   `---------------------------------------------------------------------------    ------------------'
 */

#define LAYOUT_ansi_blocker_7u_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301,       K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,               K407,                 K410,             K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, ____, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, ____, ____, K413, K414, K415 }  \
}

/* ANSI with blocker and small shift and small backspace and 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |               |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |     |         |                                       |         |    |     |     |     |
 * `------'   `---------------------------------------------------------------------------    ------------------'
 */

#define LAYOUT_ansi_blocker_7u_small_lshift_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,               K407,                 K410,             K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, ____, ____, K413, K414, K415 }  \
}

/* **************************************************************************************************************************************** */
/* ISO
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |------------------------------------------------------------------------------------       |-----|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |       |       |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_iso( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113,       K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K114, K213, K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ISO with small backspace
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |------------------------------------------------------------------------------------       |-----|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |       |       |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_iso_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113,       K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K114, K213, K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* **************************************************************************************************************************************** */
/* ISO with 1u keys in the bottom row
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |------------------------------------------------------------------------------------       |-----|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |       |       |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |      |      |      |     |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_iso_1u( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113,       K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K114, K213, K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411, K412, K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, K412, K413, K414, K415 }  \
}

/* ISO with small backspace and 1u keys in the bottom row
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |------------------------------------------------------------------------------------       |-----|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |       |       |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |      |      |      |     |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_iso_1u_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113,       K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K114, K213, K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411, K412, K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, K412, K413, K414, K415 }  \
}

/* **************************************************************************************************************************************** */
/* ISO with 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |------------------------------------------------------------------------------------       |-----|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |       |       |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |         |                                       |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_iso_7u( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113,       K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K114, K213, K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402,                     K407,                 K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, ____, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ISO with small backspace and 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |------------------------------------------------------------------------------------       |-----|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |       |       |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |         |                                       |         |         |      |     |     |
 * `------'   `-------------------------------------------------------------------------------------------------'
 */

#define LAYOUT_iso_7u_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113,       K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K114, K213, K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402,                     K407,                 K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, ____, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}
/* **************************************************************************************************************************************** */
/* ISO with blocker
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |------------------------------------------------------------------------------------       |-----|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |       |       |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |       |      |    |      |     |     |
 * `------'   `--------------------------------------------------------------------------    -------------------'
 */

#define LAYOUT_iso_blocker( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113,       K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K114, K213, K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* ISO with blocker and small backspace
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |------------------------------------------------------------------------------------       |-----|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |       |       |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |      |       |       |                                   |       |      |    |      |     |     |
 * `------'   `--------------------------------------------------------------------------    -------------------'
 */

#define LAYOUT_iso_blocker_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113,       K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K114, K213, K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410, K411,       K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, K411, ____, K413, K414, K415 }  \
}

/* **************************************************************************************************************************************** */
/* ISO with blocker and 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |           |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |------------------------------------------------------------------------------------       |-----|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |       |       |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |     |         |                                       |         |    |     |     |     |
 * `------'   `---------------------------------------------------------------------------    ------------------'
 */

#define LAYOUT_iso_blocker_7u( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113,       K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K114, K213, K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410,             K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, ____, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, ____, ____, K413, K414, K415 }  \
}

/* ISO with blocker and small backspace and 7u spacebar
 * ,------.   ,-------------------------------------------------------------------------------------------------.
 * |      |   |       |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
   |      |   |        |     |     |     |     |     |     |     |     |     |     |     |     |          |     |
 * |------|   |------------------------------------------------------------------------------------       |-----|
 * |      |   |         |     |     |     |     |     |     |     |     |     |     |     |       |       |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |     |     |     |     |     |     |     |     |     |     |     |     |             |     |     |
 * |------|   |-------------------------------------------------------------------------------------------------|
 * |      |   |        |     |         |                                       |         |    |     |     |     |
 * `------'   `---------------------------------------------------------------------------    ------------------'
 */

#define LAYOUT_iso_blocker_7u_small_bspc( \
K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K014, K013, K214, K015, \
K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113,       K115, \
K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K114, K213, K215, \
K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315, \
K400, K401, K402, K403,                   K407,             K410,             K413, K414, K415  \
) { \
{ K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015 }, \
{ K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115 }, \
{ K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215 }, \
{ K300, K301, K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313, K314, K315 }, \
{ K400, K401, K402, K403, ____, ____, ____, K407, ____, ____, K410, ____, ____, K413, K414, K415 }  \
}
