#include "quantum.h"

#ifdef RGB_MATRIX_ENABLE
led_config_t g_led_config = { {
    {      0,      1,      2,      3,      4,      5,      6 },
    {      7,      8,      9,     10,     11,     12,     13 },
    {     14,     15,     16,     17,     18,     19,     20 },
    {     21,     22,     23,     24,     25,     26,     27 },
    {     28,     29,     30,     31,     32,     33,     34 },
    { NO_LED, NO_LED, NO_LED, NO_LED, NO_LED,     33,     34 },
// Need to shift Right hand indexes if full hand LEDs are enabled
#define LO (FULLHAND_LEDS / 2)
    {  LO+62,  LO+63,  LO+64,  LO+65,  LO+66,  LO+67,  LO+68 },
    {  LO+69,  LO+70,  LO+71,  LO+72,  LO+73,  LO+74,  LO+75 },
    {  LO+76,  LO+77,  LO+78,  LO+79,  LO+80,  LO+81,  LO+82 },
    {  LO+83,  LO+84,  LO+85,  LO+86,  LO+87,  LO+88,  LO+89 },
    {  LO+90,  LO+91,  LO+92,  LO+93,  LO+94,  LO+95,  LO+95 },
    { NO_LED, NO_LED, NO_LED, NO_LED, NO_LED,  LO+95,  LO+95 }
#undef LO
}, {
// Left Hand Mapped Left to Right
    {  11,  14 }, {  28,  14 }, {  42,  14 }, {  56,  14 }, {  70,  14 }, {  84,  14 }, { 102,  14 },
    {  11,  28 }, {  28,  28 }, {  42,  28 }, {  56,  28 }, {  70,  28 }, {  84,  28 }, {  98,  25 },
    {  11,  42 }, {  28,  42 }, {  42,  42 }, {  56,  42 }, {  70,  42 }, {  84,  42 }, {  98,  39 },
    {  11,  56 }, {  28,  56 }, {  42,  56 }, {  56,  56 }, {  70,  56 }, {  84,  56 }, {  98,  53 },
    {  11,  70 }, {  28,  70 }, {  42,  70 }, {  56,  70 }, {  70,  70 }, {  83,  87 }, {  93,  97 },
// Edge Light Left
    {   0,  66 }, {   0,  52 }, {   0,  38 }, {   0,  24 }, {   0,  10 }, {  31,   0 }, {  38,   0 },
    {  46,   0 }, {  54,   0 }, {  61,   0 }, {  69,   0 }, {  76,   0 }, {  84,   0 }, { 109,  11 },
    { 109,  24 }, { 109,  39 }, { 109,  53 }, { 110,  73 }, { 112,  85 }, { 106,  95 }, {  95,  98 },
    {  83,  91 }, {  71,  84 }, {  58,  77 }, {  42,  74 }, {  28,  74 }, {  14,  74 },
// Full Hand Left
#ifdef FULLHAND_ENABLE
    {   2,  88 }, {   2, 103 }, {   2, 117 }, {   2, 132 }, {  10, 145 }, {  25, 145 }, {  39, 145 },
    {  54, 145 }, {  69, 145 }, {  79, 136 }, {  87, 124 }, {  94, 111 },
// SF Left
#elif SF_ENABLE
    {   0,  88 }, {   0, 103 }, {   0, 117 }, {   0, 130 }, {   9, 142 }, {  24, 142 }, {  38, 142 },
    {  53, 142 }, {  67, 142 }, {  79, 135 }, {  86, 123 }, {  93, 110 }, {  88, 102 }, {  74, 101 },
    {  60,  91 }, {  45,  98 }, {  33,  92 }, {  23,  86 }, {  10,  80 },
#endif
// Left Hand Mapped Right to Left
    { 213,  14 }, { 196,  14 }, { 182,  14 }, { 168,  14 }, { 154,  14 }, { 140,  14 }, { 122,  14 },
    { 213,  28 }, { 196,  28 }, { 182,  28 }, { 168,  28 }, { 154,  28 }, { 140,  28 }, { 126,  25 },
    { 213,  42 }, { 196,  42 }, { 182,  42 }, { 168,  42 }, { 154,  42 }, { 140,  42 }, { 126,  39 },
    { 213,  56 }, { 196,  56 }, { 182,  56 }, { 168,  56 }, { 154,  56 }, { 140,  56 }, { 126,  53 },
    { 213,  70 }, { 196,  70 }, { 182,  70 }, { 168,  70 }, { 154,  70 }, { 141,  87 }, { 131,  97 },
// Edge Light Right
    { 224,  66 }, { 224,  52 }, { 224,  38 }, { 224,  24 }, { 224,  10 }, { 193,   0 }, { 186,   0 },
    { 178,   0 }, { 170,   0 }, { 163,   0 }, { 155,   0 }, { 148,   0 }, { 140,   0 }, { 115,  11 },
    { 115,  24 }, { 115,  39 }, { 115,  53 }, { 114,  73 }, { 112,  85 }, { 118,  95 }, { 129,  98 },
    { 141,  91 }, { 153,  84 }, { 166,  77 }, { 182,  74 }, { 196,  74 }, { 210,  74 }
// Full Hand Right
#ifdef FULLHAND_ENABLE
   ,{ 222,  88 }, { 222, 103 }, { 222, 117 }, { 222, 132 }, { 214, 145 }, { 199, 145 }, { 185, 145 },
    { 170, 145 }, { 155, 145 }, { 145, 136 }, { 137, 124 }, { 130, 111 }
// SF Right
#elif SF_ENABLE
   ,{ 224,  88 }, { 224, 103 }, { 224, 117 }, { 224, 130 }, { 215, 142 }, { 200, 142 }, { 186, 142 },
    { 171, 142 }, { 157, 142 }, { 145, 135 }, { 138, 123 }, { 131, 110 }, { 136, 102 }, { 150, 101 },
    { 164,  91 }, { 179,  98 }, { 191,  92 }, { 201,  86 }, { 214,  80 }
#endif
}, {
// Left Hand Mapped Left to Right
    1, 4, 4, 4, 4, 4, 1,
    1, 4, 4, 4, 4, 4, 1,
    1, 4, 4, 4, 4, 4, 1,
    1, 4, 4, 4, 4, 4, 1,
    1, 1, 1, 1, 1, 1, 1,
// Edge Light Left
    2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2,
// Full Hand Left
#ifdef FULLHAND_ENABLE
    2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2,
// SF Left
#elif SF_ENABLE
    2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2,
#endif
// Left Hand Mapped Right to Left
    1, 4, 4, 4, 4, 4, 1,
    1, 4, 4, 4, 4, 4, 1,
    1, 4, 4, 4, 4, 4, 1,
    1, 4, 4, 4, 4, 4, 1,
    1, 1, 1, 1, 1, 1, 1,
// Edge Light Right
    2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2
// Full Hand Right
#ifdef FULLHAND_ENABLE
   ,2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2
// SF Right
#elif SF_ENABLE
   ,2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2
#endif
} };

#endif

