# Cranium's Preonic layout

This layout is based on the Preonic default with some changes I find interesting to share.

## Default layer
```
 ,-----------------------------------------------------------------------------------.
 |   `  |   1  |   2  |   3  |   4  |   5  |   6  |   7  |   8  |   9  |   0  | Esc  |
 |------|------|------|------|------|------|------|------|------|------|------|------|
 | Tab  |   Q  |   W  |   E  |   R  |   T  |   Y  |   U  |   I  |   O  |   P  | Esc  |
 |------|------|------|------|------|-------------|------|------|------|------|------|
 | Bksp |   A  |   S  |   D  |   F  |   G  |   H  |   J  |   K  |   L  |   ;  |  "   |
 |------|------|------|------|------|------|------|------|------|------|------|------|
 | Shift|   Z  |   X  |   C  |   V  |   B  |   N  |   M  |   ,  |   .  |   /  |  |   |
 |------|------|------|------|------|------|------|------|------|------|------|------|
 | Ctrl |  F12 |  GUI | Alt  |Lower |    Space    |Raise |AltGr |   [  |   ]  |Enter |
 `-----------------------------------------------------------------------------------'
```
- As a Colemak user, Capslock was rebound to Backspace.
- Escape was moved to the top-right of the keyboard
- Enter was moved to the bottom-right of the keyboard. It's now easy to hit and can even be activated with the palm.
- An F12 was put next to the left CTRL => it's the shortcut I use to toggle the Guake terminal.
- I don't really use the key below my Escape (top-right, 2nd row), so I'll consider any ideas for the moment.


## Lower
```
 ,-----------------------------------------------------------------------------------.
 |  ~   |  F1  |  F2  |  F3  |  F4  |  F5  |  F6  |  F7  |  F8  |  F9  |  F10 |  F11 |
 |------|------|------|------|------|-------------|------|------|------|------|------|
 |      |   !  |   @  |   #  |   $  |   %  |   ^  |   &  |   *  |   (  |   )  |  Del |
 |------|------|------|------|------|-------------|------|------|------|------|------|
 | Del  |  F1  |  F2  |  F3  |  F4  |  F5  |  F6  |   -  |   +  |   =  |      |      |
 |------|------|------|------|------|------|------|------|------|------|------|------|
 | LGUI |  F7  |  F8  |  F9  |  F10 |  F11 |  F12 |   1  |   2  |   3  |   4  |      |
 |------|------|------|------|------|------|------|------|------|------|------|------|
 |      |      |      |      |      |      _      |      |      |      |      |      |
 `-----------------------------------------------------------------------------------'
```
- Not much changes here

## Raise
```
 ,-----------------------------------------------------------------------------------.
 |      |   1  |   2  |   3  |   4  |   5  |   6  |   7  |   8  |   9  |   0  |      |
 |------|------|------|------|------|------|------|------|------|------|------|------|
 |      |   1  |   2  |   3  |   4  |   5  |   6  |   7  |   8  |   9  |   0  |      |
 |------|------|------|------|------|-------------|------|------|------|------|------|
 | Del  |  F1  |  F2  |  F3  |  F4  |  F5  |  F6  |  Up  | Down | Left |Right |      |
 |------|------|------|------|------|------|------|------|------|------|------|------|
 |      |  F7  |  F8  |  F9  |  F10 |  F11 |  F12 | Home | End  |      |      | Shift|
 |------|------|------|------|------|------|------|------|------|------|------|------|
 |      |      |      |      |      |      _      |      |      |      |      |      |
 `-----------------------------------------------------------------------------------'
```
- Perhaps one of the most interesting change: the arrow keys were moved to the right-hand home row, activated with the Raise layer. It means I can use the arrow keys without moving my hand from the home row, by activating the Raise layer with my thumb. It took a while to adapt but it was totally worth it. To note, I also put Home/End on the same layer but one row below, with I also find really useful.

## Adjust
```
 ,-----------------------------------------------------------------------------------.
 |      |      |      |      |      |      |      |      |      |      |      | Sleep|
 |------|------|------|------|------|------|------|------|------|------|------|------|
 |      | Reset| Debug|      |      |      |      |      |      |      |      |      |
 |------|------|------|------|------|-------------|------|------|------|------|------|
 |      |      |      |Aud on|AudOff|AGnorm|AGswap| Vol+ | Vol- | Prev | Next |      |
 |------|------|------|------|------|------|------|------|------|------|------|------|
 |      |Voice-|Voice+|Mus on|MusOff|MidiOn|MidOff|      |      |      |      |      |
 |------|------|------|------|------|------|------|------|------|------|------|------|
 |      |      |      |      |      |    Play     |      |      |      |      | PrScr|
 `-----------------------------------------------------------------------------------'
```
- The "arrow" keys act as Vol+/Vol-/Previous/Next on the Adjust layer (which is quite a natural mapping for these media keys).
