The Matrixman Ergodox / Split-Planck Keyboard Layout
====================================================

### The problem

These layouts were designed to give my aching pinkeys a break

### The Design

 - Pinkeys do less:
   - Left q, a, z, `, _, =, [Shift], [F1] [Click], [Right Click]
   - Right p, ', /, |, -, +, [Shift], [F10], [F11], [F12]
 - Index fingers do more:
   - Left: r, f, v, t, g, b, &, $, !, /, (, {, <, [, [Ctrl], [Tab], [Alt], [PrintScr]
   - Right: u, j, m, y, h, n, 7, 4, 1, \, ), }, >, ], ;, [Ctrl], [Insert], [Alt], [Pause]
 - Thumbs do more:
   - Left: [Esc], :, [Shift], [Tab]
   - Right: [Space], ;, [Shift], [Backspace]
 - Palm Presses too:
   - Left: [Ctrl], "
   - Right: [Ctrl, [Enter]

### The Plan

I keep an Ergodox at home and at work, and when I'm mobile, I carry a planck.
These keymaps are designed to minimize the difficulty of switching between the two.

### Other features

- 10-key at home row for right hand
- "Matching" symbols use same finger on opposite hand: <> [] {} /\ () 1! 2@ 3# 4$ 5% 6^ 7& 8* -_ +=
- Supports vim-like (hjkl) movements:
  - mouse movement and scrolling
  - arrow keys and nav keys (home, end, pg up, pg down)
- All non-modal keys mapped (all keys from a typical 105 key keyboard except caps, num, and scroll lock)

The Planck Layout
-----------------

For a picture, see here: http://www.keyboard-layout-editor.com/#/gists/eb0696806831fc0d93c9

### Prose Layer

    qwert▓▓yuiop
    asdfg▓;hjkl'
    zxcvb▓▓nm,./
    ▓▓▓▓▓▓▓ ▓▓▓▓

### Symbol Layer

    `~*&/<>\789|
    _^%$([])456-
    =#@!{▓▓}123+
    "▓,?:▓▓;0▓.▓

### Nav Layer

    FKEYF▓▓KEYFK
    mouse▓▓arowE
    scrol▓▓seekY
    ▓▓▓▓▓▓▓▓▓▓▓▓


The Ergodox Layout
------------------

For a picture, see here: http://www.keyboard-layout-editor.com/#/gists/9be130e4c9b503317619

Wherever the Ergodox has keys that the Planck doesn't, whichever key would be expected on a typical 105 key is in that place

### Prose Layer

▓▓▓▓▓▓▓          ▓▓▓▓▓▓
▓qwert▓         ▓yuiop\
▓asdfg▓         ;hjkl;'
▓zxcvb           nm,./▓
▓▓▓▓▓▓           ▓▓▓▓▓▓
        ▓▓   ▓▓
       ▓▓▓   ▓ ▓

### Symbol Layer

▓▓▓▓▓▓           ▓▓▓▓▓▓
▓`~*&/<         >\789|\
▓_^%$([         ])456-▓
▓=#@!{           }123+▓
"▓▓▓▓▓▓           0▓.▓▓
        ▓▓   ▓▓
       ?:▓   ▓;.


### Nav Layer

▓▓▓▓▓▓▓          ▓▓▓▓▓▓
▓FKEYF▓         ▓KEYFK▓
▓mouse▓          arowE▓
▓scrol           seekY▓
▓▓▓▓▓▓           ▓▓▓▓▓▓
        ▓▓   ▓▓
       ▓▓▓   ▓▓▓
