Jeremy Cowgar's Planck Keymap
=============================

I am a programmer by trade and suffer from the beginning stages of RSI. As a programmer, I use letters, symbols and cursor navigation most often. To prevent strange finger gymnastics, I wrote a script to rank which non-letter characters occurred in my primary source projects most often and then placed these characters in the easiest to reach locations, within reason and for me. I made heavy use of momentary layer toggling.

Layers
------

The key mapping is made up of 5 layers: Letters, Symbols, Navigation, Numbers, and Function Keys.

The layout can be viewed visually at:

http://www.keyboard-layout-editor.com/#/gists/319474e5e2d199e583371ed1d2aec316

* Purple buttons are dual function keys.
* Green buttons are layer momentary toggle keys.
* Red buttons are layer persistent toggle keys.

The keys have multiple symbols:

* Upper left: standard layer, the letter layer
* Upper right: function layer
* Lower left: navigation layer
* Lower right: symbol layer

The symbols in the layout editor are not entirely clear.

The Z and ? keys double as shift keys. Hold for a shift, tap for a Z or ?

The bottom row from left to right:

* Tab when pressed, Control when held. It also is the volume mute key when in the "Navigation" layer
* Function layer momentary toggle
* Number layer momentary toggle
* Symbol layer momentary toggle. When in the "Number" layer, this key also makes the "Number" layer sticky for using the 10 key for quite a bit of entry
* Space
* Backspace when tapped, Option when held
* Delete when tapped, Command when held
* Return
* Symbol layer momentary toggle. When in the "Number" layer, key also is the zero key.
* Navigation layer momentary toggle
* Navigation layer toggle. This was included for when you are browsing a website, document or otherwise wish to stay in navigation mode. When in the "Number" layer, the key is the = symbol
* Escape when pressed, Control when held. When in the "Number" layer, the key is the + symbol

General Notes
-------------

The letter layer is separated by 2 center rows of keys. This spreads the hands out a little further which helps not twist the wrists as much. The 2 center rows are [], (), [], and Ctrl and Alt keys.

The symbol layer keys are accessed by the thumbs. They are the closest to the thumbs, instead of the number toggle, because in my code I found I used symbols much more often than numbers. There are two symbol layer keys because the symbols spread across the right and left half of the keyboard. Thus, some symbols are easier hit with the left hand modifier or right hand modifier.

The number layer key is only accessible by the left thumb because all of the number keys are on the right side of the keyboard. When in the number layer, you can press the key to the right to make that layer sticky when you are going to do a lot of number entry.

The function layer key is only accessible by the left thumb because all of the function keys are on the right side of the keyboard.

The navigation layer key is only accessible by the right thumb because all of the navigation keys are on the left side of the keyboard. You can press the key to the right of the navigation layer to make the navigation layer sticky when you are doing a lot of navigation, reading a web page for example.

When using the number or navigation layers, the same hand that accesses the momentary layer toggle key also has the 4 primary modifiers under their home row.

* Pointer finger is control
* Middle finger is option
* Ring finger is command
* Pinky finger is shift

This is so you can easily press Cmd+Shift+F4 or when navigating, select text or words of text by pressing Shift+Control, for example.

Some keys are duplicated. For example, () are available in easy to reach locations while in the Number layer because they are often used in math.

The symbol layer has additional helpers for programming including a single keys that enter /=, \*=, -=, +=, !=, <>, ||, and &&. It also includes three special Return keys on the left:

* Up CR which moves the cursor up, to the end of the line and then presses CR
* Down CR which moves the cursor to the end of the line and then presses CR
* Right ; which moves the cursor to the end of the line and presses ; for C styled languages, such as JavaScript which is a primary language I use

Word of Warning
---------------

I have been using the keymap for some time now and believe it to be a good keymap. There are a few things through the week that I wonder if it would have been better if this key were moved to that location.

This keymap may change for further optimization.

Please Give Feedback!
---------------------

I am very interested in your feedback. Send me a message here on GitHub, r/jcowgar or @jcowgar.
