/* Copyright 2018 'Masayuki Sunahara'
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include QMK_KEYBOARD_H

// Defines names for use in layer keycodes and the keymap
enum layer_names {
    _QWERTY,
    _LOWER,
    _RAISE,
    _ADJUST
};

#define KC_LOWER MO(_LOWER)
#define KC_RAISE MO(_RAISE)
#define KC_ADJ   MO(_ADJUST)
#define KC_CTLTB CTL_T(KC_TAB)

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
  [_QWERTY] = LAYOUT(
  //,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
        KC_ESC,     KC_1,     KC_2,     KC_3,     KC_4,     KC_5,  KC_LPRN,     KC_RPRN,     KC_6,     KC_7,     KC_8,     KC_9,     KC_0,  KC_BSPC,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
        KC_TAB,     KC_Q,     KC_W,     KC_E,     KC_R,     KC_T,  KC_LBRC,     KC_RBRC,     KC_Y,     KC_U,     KC_I,     KC_O,     KC_P,  KC_BSLS,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
      KC_CTLTB,     KC_A,     KC_S,     KC_D,     KC_F,     KC_G,  KC_LCBR,     KC_RCBR,     KC_H,     KC_J,     KC_K,     KC_L,  KC_SCLN,  KC_QUOT,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
       KC_LSFT,     KC_Z,     KC_X,     KC_C,     KC_V,     KC_B,   KC_ADJ,      KC_ADJ,     KC_N,     KC_M,  KC_COMM,   KC_DOT,  KC_SLSH,   KC_ENT,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
                                     KC_LALT, KC_LOWER,  KC_LGUI,   KC_SPC,      KC_SPC,  KC_RGUI, KC_RAISE,  KC_RALT
                                //`---------------------------------------'  `---------------------------------------'
  ),

  [_LOWER] = LAYOUT(
  //,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
      KC_GRV, _______, _______, _______, _______, _______, _______,    _______, _______, _______, _______,  KC_MINS,   KC_EQL, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
      _______, _______, _______, _______, _______, _______, _______,    _______, _______, _______, _______, _______, _______, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
      _______, _______, _______, _______, _______, _______, _______,    _______, _______, _______, _______, _______, _______, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
      _______, _______, _______, _______, _______, _______, _______,    _______, _______, _______, _______, _______, _______, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
                                    _______, _______, _______, _______,    _______, _______, _______, _______
                                //`---------------------------------------'  `---------------------------------------'
  ),

  [_RAISE] = LAYOUT(
  //,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
      KC_GRV, _______, _______, _______, _______, _______, _______,    _______, _______, _______, _______,  KC_MINS,   KC_EQL, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
      _______, _______, _______, _______, _______, _______, _______,    _______, _______, _______, _______, _______, _______, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
      _______, _______, _______, _______, _______, _______, _______,    _______, _______, _______, _______, _______, _______, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
      _______, _______, _______, _______, _______, _______, _______,    _______, _______, _______, _______, _______, _______, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
                                    _______, _______, _______, _______,    _______, _______, _______, _______
                                //`---------------------------------------'  `---------------------------------------'
  ),

  [_ADJUST] = LAYOUT(
  //,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
      _______,    KC_F1,    KC_F2,    KC_F3,    KC_F4,    KC_F5, _______,    _______,    KC_F6,    KC_F7,    KC_F8,    KC_F9,   KC_F10, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
      _______, _______, _______, _______, _______, _______, _______,    _______, _______, _______, _______,   KC_F11,   KC_F12, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
      _______, _______, _______, _______, _______, _______, _______,    _______,  KC_HOME,  KC_PGDN,  KC_PGUP,   KC_END, _______, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
      _______, _______, _______, _______, _______, _______, _______,    _______, _______, _______, _______, _______, _______, _______,
  //|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
                                    _______, _______, _______, _______,    _______, _______, _______, _______
                                //`---------------------------------------'  `---------------------------------------'
  )
};
