/*
Copyright 2019 Takuya Urakawa (dm9records.com)
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#pragma once

#include "config_common.h"

/* USB Device descriptor parameter */
/* VID & PID from vusb project, see tmk_core/protocol/vusb/USB-IDs-for-free.txt"*/
// These VID/PID is not verified. Use at your own risk.
#define VENDOR_ID 0x16C0
#define PRODUCT_ID 0x27DB
#define DEVICE_VER 0x0002
#define MANUFACTURER /u/squeezeonein
#define PRODUCT ortho5by12
#define DESCRIPTION 12x5 ortholinear keyboard with through hole components

/* key matrix size, duplex 10x6 */
#define MATRIX_ROWS 10
#define MATRIX_COLS 6

/*
 * Keyboard Matrix Assignments
 *
 * Change this to how you wired your keyboard
 * COLS: AVR pins used for columns, left to right
 * ROWS: AVR pins used for rows, top to bottom
 * DIODE_DIRECTION: COL2ROW = COL = Anode (+), ROW = Cathode (-, marked on diode)
 *                  ROW2COL = ROW = Anode (+), COL = Cathode (-, marked on diode)
 *
                          0   1   2   3   4   5   6   7   8   9     */
#define MATRIX_ROW_PINS { B5, B1, B2, B3, B4, C0, D5, D6, D7, B0 }
#define MATRIX_COL_PINS { C2, D0, D1, D4, C3, C1 }
#define UNUSED_PINS

/* COL2ROW, ROW2COL*/
#define DIODE_DIRECTION ROW2COL

/* Debounce reduces chatter (unintended double-presses) - set 0 if debouncing is not needed */
#define DEBOUNCE 5

/* Mechanical locking support. Use KC_LCAP, KC_LNUM or KC_LSCR instead in keymap */
#define LOCKING_SUPPORT_ENABLE
/* Locking resynchronize hack */
#define LOCKING_RESYNC_ENABLE

#define BOOTMAGIC_LITE_ROW 7
#define BOOTMAGIC_LITE_COLUMN 2
