#pragma once

#include "naked64.h"


//////////////////////////////////////////////////////////////////////////////
// When only use Naked64.
//////////////////////////////////////////////////////////////////////////////
/*
 * ,------------------------------------------       -----------------------------------------.
 * | L00 | L20 | L70 | L31 | L02 | L52 | L13 |       | L63 | L34 | L05 | L45 | L16 | L66 | L37 |
 * |------------------------------------------       ------------------------------------------+
 * | L10 | L30 | L01 | L41 | L12 | L62 | L23 |       | L73 | L44 | L15 | L55 | L26 | L76 | L47 |
 * |------------------------------------------       ------------------------------------------+
 *       | L40 | L11 | L51 | L22 | L72 | L33 |       | L04 | L54 | L25 | L65 | L36 | L07 | L57 |
 *       |------------------------------------       ------------------------------------------+
 *       | L50 | L21 | L61 | L32 | L03 | L43 |       | L14 | L64 | L35 | L75 | L46 | L17 | L67 |
 *       |------------------------------------       ------------------------------------------+
 *       | L60 |     | L71 | L42 |     | L53 |       | L24 | L74 |     | L06 | L56 | L27 | L77 |
 *       |------------------------------------       ------------------------------------------'
 */

#define LAYOUT( \
       L00, L20, L70, L31, L02, L52, L13,    L63, L34, L05, L45, L16, L66, L37, \
       L10, L30, L01, L41, L12, L62, L23,    L73, L44, L15, L55, L26, L76, L47, \
            L40, L11, L51, L22, L72, L33,    L04, L54, L25, L65, L36, L07, L57, \
            L50, L21, L61, L32, L03, L43,    L14, L64, L35, L75, L46, L17, L67, \
            L60,      L71, L42,      L53,    L24, L74,      L06, L56, L27, L77 \
  ) \
  { \
    {  L00,  L01,  L02,  L03,  L04,  L05,  L06,  L07  },  \
    {  L10,  L11,  L12,  L13,  L14,  L15,  L16,  L17  },  \
    {  L20,  L21,  L22,  L23,  L24,  L25,  L26,  L27  },  \
    {  L30,  L31,  L32,  L33,  L34,  L35,  L36,  L37  },  \
    {  L40,  L41,  L42,  L43,  L44,  L45,  L46,  L47  },  \
    {  L50,  L51,  L52,  L53,  L54,  L55,  L56,  L57  },  \
    {  L60,  L61,  L62,  L63,  L64,  L65,  L66,  L67  },  \
    {  L70,  L71,  L72,  L73,  L74,  L75,  L76,  L77  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  }   \
  }

//////////////////////////////////////////////////////////////////////////////
// When connecting Setta21 to Naked64.
//////////////////////////////////////////////////////////////////////////////

#define LAYOUT_with_setta21( \
       L00, L20, L70, L31, L02, L52, L13,    L63, L34, L05, L45, L16, L66, L37,    R00, R01, R02, R03, R04, R05, \
       L10, L30, L01, L41, L12, L62, L23,    L73, L44, L15, L55, L26, L76, L47,         R11, R12, R13, R14, R15, \
            L40, L11, L51, L22, L72, L33,    L04, L54, L25, L65, L36, L07, L57,    R20, R21, R22, R23, R24, R25, \
            L50, L21, L61, L32, L03, L43,    L14, L64, L35, L75, L46, L17, L67,    R30,      R32,      R34, R35, \
            L60,      L71, L42,      L53,    L24, L74,      L06, L56, L27, L77 \
  ) \
  { \
    {  L00,  L01,  L02,  L03,  L04,  L05,  L06,  L07  },  \
    {  L10,  L11,  L12,  L13,  L14,  L15,  L16,  L17  },  \
    {  L20,  L21,  L22,  L23,  L24,  L25,  L26,  L27  },  \
    {  L30,  L31,  L32,  L33,  L34,  L35,  L36,  L37  },  \
    {  L40,  L41,  L42,  L43,  L44,  L45,  L46,  L47  },  \
    {  L50,  L51,  L52,  L53,  L54,  L55,  L56,  L57  },  \
    {  L60,  L61,  L62,  L63,  L64,  L65,  L66,  L67  },  \
    {  L70,  L71,  L72,  L73,  L74,  L75,  L76,  L77  },  \
    {  R00,  R01,  R02,  R03,  R04,  R05,KC_NO,KC_NO  },  \
    {KC_NO,  R11,  R12,  R13,  R14,  R15,KC_NO,KC_NO  },  \
    {  R20,  R21,  R22,  R23,  R24,  R25,KC_NO,KC_NO  },  \
    {  R30,KC_NO,  R32,KC_NO,  R34,  R35,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  },  \
    {KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO,KC_NO  }   \
  }

