#pragma once

#include "quantum.h"

#define LAYOUT( \
  K050, K051, K052, K053, K054, K055, K056, K057, K058, K118, K117, K115, K114, K113, K116, K112, K111, K110, K063, \
  K040, K041, K042, K043, K044, K045, K046, K047, K048, K108, K107, K105, K104, K103, K106, K102, K101, K100, K064, \
  K030, K031, K032, K033, K034, K035, K036, K037, K038, K098, K097, K095, K094, K084,       K096, K092, K091, K090, \
  K020, K021, K022, K023, K024, K025, K026, K027, K028, K088, K087, K085, K093,             K086, K082, K081, K080, \
  K010, K011, K012, K013, K014, K015, K016, K017, K018, K078, K077, K075, K074,       K073, K076, K072, K071, K070, \
  K000, K001, K002,                   K006,                   K008, K007, K005, K004, K003, K066, K062, K061, K060  \
) { \
	{ K000,  K001,  K002,  K003,  K004,  K005,  K006,  K007,  K008 }, \
	{ K010,  K011,  K012,  K013,  K014,  K015,  K016,  K017,  K018 }, \
	{ K020,  K021,  K022,  K023,  K024,  K025,  K026,  K027,  K028 }, \
	{ K030,  K031,  K032,  K033,  K034,  K035,  K036,  K037,  K038 }, \
	{ K040,  K041,  K042,  K043,  K044,  K045,  K046,  K047,  K048 }, \
	{ K050,  K051,  K052,  K053,  K054,  K055,  K056,  K057,  K058 }, \
	{ K060,  K061,  K062,  K063,  K064,  KC_NO, K066,  KC_NO, KC_NO }, \
	{ K070,  K071,  K072,  K073,  K074,  K075,  K076,  K077,  K078 }, \
	{ K080,  K081,  K082,  KC_NO, K084,  K085,  K086,  K087,  K088 }, \
	{ K090,  K091,  K092,  K093,  K094,  K095,  K096,  K097,  K098 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108 }, \
	{ K110,  K111,  K112,  K113,  K114,  K115,  K116,  K117,  K118 }  \
}

/*
 * The layout macro for the layout of hotswap keyboards, with illustrative grid of a typical
 * assignment.
 * ,---------------------------------------------------------------------------
 * |ESC|F1|F2 |F3 |F4 |F5 |F6 |F7 |F8 |F9 |F10|F11|F12|PSC|HOM|END|PGU|PGD|DEL|
 * ,--------------------------------------------------------------------------|
 * | ` |1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 0 | - | + | BKSPC |NLK| / | * | - |
 * |--------------------------------------------------------------------------|
 * | TAB | Q | W | E | R | T | Y | U | I | O | P | [ | ] |  \ | 7 | 8 | 9 |   |
 * |----------------------------------------------------------------------| + |
 * | CTRL  | A | S | D | F | G | H | J | K | L | ; | ' |  RET | 4 | 5 | 6 |   |
 * |----------------------------------------------------------------------|---|
 * | LSHIFT | Z | X | C | V | B | N | M | , | . | / |RSHFT| ↑ | 1 | 2 | 3 |   |
 * |----------------------------------------------------------------------|ENT|
 * |LCTL|LWIN|LALT|         SPACE         |CTL|ALT|FN | ← | ↓ | → | 0 | . |   |
 * `---------------------------------------------------------------------------
 */
#define LAYOUT_hotswap( \
  K050, K051, K052, K053, K054, K055, K056, K057, K058, K118, K117, K115, K114, K113, K116, K112, K111, K110, K063, \
  K040, K041, K042, K043, K044, K045, K046, K047, K048, K108, K107, K105, K104,       K106, K102, K101, K100, K064, \
  K030, K031, K032, K033, K034, K035, K036, K037, K038, K098, K097, K095, K094,       K093, K096, K092, K091,       \
  K020, K021, K022, K023, K024, K025, K026, K027, K028, K088, K087, K085,             K084, K086, K082, K081, K080, \
  K010,       K012, K013, K014, K015, K016, K017, K018, K078, K077, K075, K074,       K073, K076, K072, K071,       \
  K000, K001, K002,                   K006,                   K008, K007, K005, K004, K003, K066, K062, K061, K060  \
) { \
	{ K000,  K001,  K002,  K003,  K004,  K005,  K006,  K007,  K008 }, \
	{ K010,  KC_NO, K012,  K013,  K014,  K015,  K016,  K017,  K018 }, \
	{ K020,  K021,  K022,  K023,  K024,  K025,  K026,  K027,  K028 }, \
	{ K030,  K031,  K032,  K033,  K034,  K035,  K036,  K037,  K038 }, \
	{ K040,  K041,  K042,  K043,  K044,  K045,  K046,  K047,  K048 }, \
	{ K050,  K051,  K052,  K053,  K054,  K055,  K056,  K057,  K058 }, \
	{ K060,  K061,  K062,  K063,  K064,  KC_NO, K066,  KC_NO, KC_NO }, \
	{ KC_NO, K071,  K072,  K073,  K074,  K075,  K076,  K077,  K078 }, \
	{ K080,  K081,  K082,  KC_NO, K084,  K085,  K086,  K087,  K088 }, \
	{ KC_NO, K091,  K092,  K093,  K094,  K095,  K096,  K097,  K098 }, \
	{ K100,  K101,  K102,  KC_NO, K104,  K105,  K106,  K107,  K108 }, \
	{ K110,  K111,  K112,  K113,  K114,  K115,  K116,  K117,  K118 }  \
}

/* LAYOUT_std60_split_num0
 * ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │Esc│F1 │F2 │F3 │F4 │F5 │F6 │F7 │F8 │F9 │F10│F11│F12│Prt│Pau│Hm │End│PUp│PDn│
 * ├───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┼───┴───┼───┼───┼───┼───┤
 * │` ~│1 !│2 @│3 #│4 $│5 %│6 ^│7 &│8 *│9 (│0 )│- _│= +│ Bksp  │NLk│ / │ * │ - │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┼───┼───┼───┤
 * │ Tab │ Q │ W │ E │ R │ T │ Y │ U │ I │ O │ P │[ {│] }│ \ | │7  │8  │9  │ + │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┼───┼───┤   │
 * │CapsLk│ A │ S │ D │ F │ G │ H │ J │ K │ L │; :│' "│ Enter  │4  │5  │6  │   │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────────┼───┼───┼───┼───┤
 * │ Shift  │ Z │ X │ C │ V │ B │ N │ M │, <│. >│/ ?│  Shift   │1  │2  │3  │Ent│
 * ├────┬───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬────┬────┼───┼───┼───┤   │
 * │Ctrl│GUI │Alt │Space                   │Alt │GUI │Menu│Ctrl│0  │00 │ . │   │
 * └────┴────┴────┴────────────────────────┴────┴────┴────┴────┴───┴───┴───┴───┘
 */
#define LAYOUT_std60_split_num0( \
  K50, K51, K52, K53, K54, K55, K56, K57, K58, KB8, KB7, KB5, KB4, KB3, KB6,  KB2, KB1, KB0, K63, \
  K40, K41, K42, K43, K44, K45, K46, K47, K48, KA8, KA7, KA5, KA4,      KA6,  KA2, KA1, KA0, K64, \
  K30,   K31, K32, K33, K34, K35, K36, K37, K38, K98, K97, K95, K94,    K84,  K96, K92, K91,      \
  K20,    K21, K22, K23, K24, K25, K26, K27, K28, K88, K87, K85,        K93,  K86, K82, K81, K80, \
  K10,      K12, K13, K14, K15, K16, K17, K18, K78, K77, K75,           K74,  K76, K72, K71,      \
  K00, K01, K02,                  K06,                   K08, K07, K04, K03,  K66, K62, K61, K60  \
) { \
	{ K00,    K01,    K02,  K03,    K04,  KC_NO,  K06,  K07,    K08   }, \
	{ K10,    KC_NO,  K12,  K13,    K14,  K15,    K16,  K17,    K18   }, \
	{ K20,    K21,    K22,  K23,    K24,  K25,    K26,  K27,    K28   }, \
	{ K30,    K31,    K32,  K33,    K34,  K35,    K36,  K37,    K38   }, \
	{ K40,    K41,    K42,  K43,    K44,  K45,    K46,  K47,    K48   }, \
	{ K50,    K51,    K52,  K53,    K54,  K55,    K56,  K57,    K58   }, \
	{ K60,    K61,    K62,  K63,    K64,  KC_NO,  K66,  KC_NO,  KC_NO }, \
	{ KC_NO,  K71,    K72,  KC_NO,  K74,  K75,    K76,  K77,    K78   }, \
	{ K80,    K81,    K82,  KC_NO,  K84,  K85,    K86,  K87,    K88   }, \
	{ KC_NO,  K91,    K92,  K93,    K94,  K95,    K96,  K97,    K98   }, \
	{ KA0,    KA1,    KA2,  KC_NO,  KA4,  KA5,    KA6,  KA7,    KA8   }, \
	{ KB0,    KB1,    KB2,  KB3,    KB4,  KB5,    KB6,  KB7,    KB8   }  \
}
