/* Copyright 2020 ninjonas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include QMK_KEYBOARD_H
#include "ninjonas.h"

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

  [_QWERTY] = LAYOUT_wrapper(
//  ,------—————————-------------------------------------.                                ,--------—————————-----------------------------------.
     _____________________QWERTY_L1______________________,                                 _____________________QWERTY_R1______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----|                                |------—+——------+——------+——------+——------+--------|
     _____________________QWERTY_L2______________________,                                 _____________________QWERTY_R2______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----+———-----------.  ,——————————————+------—+——------+——------+——------+——------+--------|
     _____________________QWERTY_L3______________________,XXXXXXX,KC_LALT,  T_CPAP,XXXXXXX,_____________________QWERTY_R3______________________,
//  `--------------------------+--------+--------+-------+-------+------|  |------+-------+-------+--------+--------+--------+--------+--------'
                                _____________MOD_LEFT_____________,T_LBRC,  T_RBRC,________MOD_RIGHT________,KC_MUTE
//                             `----------------------------------------'  `----------------------------------------'
  ),

  [_DVORAK] = LAYOUT_wrapper(
//  ,------—————————-------------------------------------.                                ,--------—————————-----------------------------------.
     _____________________DVORAK_L1______________________,                                 _____________________DVORAK_R1______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----|                                |------—+——------+——------+——------+——------+--------|
     _____________________DVORAK_L2______________________,                                 _____________________DVORAK_R2______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----+———-----------.  ,——————————————+------—+——------+——------+——------+——------+--------|
     _____________________DVORAK_L3______________________,XXXXXXX,KC_LALT,  T_CPAP,XXXXXXX,_____________________DVORAK_R3______________________,
//  `--------------------------+--------+--------+-------+-------+------|  |------+-------+-------+--------+--------+--------+--------+--------'
                                _____________MOD_LEFT_____________,T_LBRC,  T_RBRC,________MOD_RIGHT________,KC_MUTE
//                             `----------------------------------------'  `----------------------------------------'
  ),

  [_COLEMAK] = LAYOUT_wrapper(
//  ,------—————————-------------------------------------.                                ,--------—————————-----------------------------------.
     _____________________COLEMAK_L1_____________________,                                 _____________________COLEMAK_R1_____________________,
//  |--------+-----——-+——------+-——-----+——------+——-----|                                |------—+——------+——------+——------+——------+--------|
     _____________________COLEMAK_L2_____________________,                                 _____________________COLEMAK_R2_____________________,
//  |--------+-----——-+——------+-——-----+——------+——-----+———-----------.  ,——————————————+------—+——------+——------+——------+——------+--------|
     _____________________COLEMAK_L3_____________________,XXXXXXX,KC_LALT,  T_CPAP,XXXXXXX,_____________________COLEMAK_R3_____________________,
//  `--------------------------+--------+--------+-------+-------+------|  |------+-------+-------+--------+--------+--------+--------+--------'
                                _____________MOD_LEFT_____________,T_LBRC,  T_RBRC,________MOD_RIGHT________,KC_MUTE
//                             `----------------------------------------'  `----------------------------------------'
  ),

  [_LOWER] = LAYOUT_wrapper(
//  ,------—————————-------------------------------------.                                ,--------—————————-----------------------------------.
     _____________________LOWER_L1_______________________,                                 _____________________LOWER_R1_______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----|                                |------—+——------+——------+——------+——------+--------|
     _____________________LOWER_L2_______________________,                                 _____________________LOWER_R2_______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----+———-----------.  ,——————————————+------—+——------+——------+——------+——------+--------|
     _____________________LOWER_L3_______________________,_______,_______,  _______,_______,_____________________LOWER_R3_______________________,
//  `--------------------------+--------+--------+-------+-------+------|  |------+-------+-------+--------+--------+--------+--------+--------'
                                _______,_______,_______,_______,_______,    _______,_______,_______,_______,_______
//                             `----------------------------------------'  `----------------------------------------'
  ),

  [_RAISE] = LAYOUT_wrapper(
//  ,------—————————-------------------------------------.                                ,--------—————————-----------------------------------.
     _____________________NUM_LEFT_______________________,                                 _____________________NUM_RIGHT______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----|                                |------—+——------+——------+——------+——------+--------|
     _____________________SYM_LEFT_______________________,                                 _____________________SYM_RIGHT______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----+———-----------.  ,——————————————+------—+——------+——------+——------+——------+--------|
     _____________________FUNC_LEFT______________________,_______,_______,  K_CPRF,_______,_____________________FUNC_RIGHT_____________________,
//  `--------------------------+--------+--------+-------+-------+------|  |------+-------+-------+--------+--------+--------+--------+--------'
                                _______,_______,_______,_______,_______,    _______,_______,_______,_______,_______
//                             `----------------------------------------'  `----------------------------------------'
  ),

  [_ADJUST] = LAYOUT_wrapper(
//  ,------—————————-------------------------------------.                                ,--------—————————-----------------------------------.
     _____________________ADJUST_L1______________________,                                 _____________________ADJUST_R1______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----|                                |------—+——------+——------+——------+——------+--------|
     _____________________ADJUST_L2______________________,                                 _____________________ADJUST_R2______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----+———-----------.  ,——————————————+------—+——------+——------+——------+——------+--------|
     _____________________ADJUST_L3______________________,_______,_______,  _______,_______,_____________________ADJUST_R3______________________,
//  `--------------------------+--------+--------+-------+-------+------|  |------+-------+-------+--------+--------+--------+--------+--------'
                                _______,_______,_______,_______,_______,    _______,_______,_______,_______,_______
//                             `----------------------------------------'  `----------------------------------------'
  ),

  [_NUMPAD] = LAYOUT_wrapper(
//  ,------—————————-------------------------------------.                                ,--------—————————-----------------------------------.
      _______, _______, _______, _______, _______,_______,                                 _____________________NUMPAD_1_______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----|                                |------—+——------+——------+——------+——------+--------|
      _______, _______, _______, _______, _______,_______,                                 _____________________NUMPAD_2_______________________,
//  |--------+-----——-+——------+-——-----+——------+——-----+———-----------.  ,——————————————+------—+——------+——------+——------+——------+--------|
      _______, _______, _______, _______,_______,_______,_______,_______,  _______,_______,_____________________NUMPAD_3_______________________,
//  `--------------------------+--------+--------+-------+-------+------|  |------+-------+-------+--------+--------+--------+--------+--------'
                                 _______,_______,_______,_______,_______,    _______,_______,_______,_______,_______
//                             `----------------------------------------'  `----------------------------------------'
  ),

/*
  [_TEMPLATE] = LAYOUT_wrapper(
//  ,------—————————-------------------------------------.                                ,--------—————————-----------------------------------.
      XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,XXXXXXX,                                 XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
//  |--------+-----——-+——------+-——-----+——------+——-----|                                |------—+——------+——------+——------+——------+--------|
      XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,XXXXXXX,                                 XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
//  |--------+-----——-+——------+-——-----+——------+——-----+———-----------.  ,——————————————+------—+——------+——------+——------+——------+--------|
      XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,XXXXXXX,XXXXXXX,XXXXXXX,XXXXXXX,  XXXXXXX,XXXXXXX,XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX, XXXXXXX,
//  `--------------------------+--------+--------+-------+-------+------|  |------+-------+-------+--------+--------+--------+--------+--------'
                                 XXXXXXX,XXXXXXX,XXXXXXX,XXXXXXX,XXXXXXX,  XXXXXXX,XXXXXXX,XXXXXXX, XXXXXXX, XXXXXXX
//                             `----------------------------------------'  `----------------------------------------'
  ),
*/
};