# kinesis_stapelberg keyboard firmware

This folder contains the firmware customization required to run QMK on the custom controller for the Kinesis Advantage created by Michael Stapelberg.
It differs from the `alvicstep` keyboard in that the existing QMK Kinesis Advantage project uses the existing controller board provided by Kinesis.

The controller board hardware is described
[here](http://michael.stapelberg.de/Artikel/kinesis_custom_controller)

Mapping the pin assignments was done using the corresponding matrix description provided at this
[link](https://github.com/stapelberg/kinesis-firmware/blob/master/kb_kinesis/config.kspec)

This code makes no attempt to drive the four LEDs provided on the controller board.


## Building the Hardware

If you want to perform this customization, these parts may be helpful.

| Function                                               | Quantity | Vendor   | Part Number  |
| ------------------------------------------------------ | -------- | -------  | ------------ |
| 13 pin connector for function keys and finger keywells | 4        | Digi-Key | WM14526-ND   |
| 10 pin headers for thumb clusters                      | 4        | Digi-Key | 609-3250-ND  |
| 8 pin cable for thumb clusters                         | 2        | Digi-Key | SAM8928-ND   |
| Teensy++ 2.0                                           | 1        | Digi-Key | 1528-1056-ND |
| 2 pin right angle header for reset                     | 1        | Digi-Key | 952-2244-ND  |
| Reset cables                                           | 1        | Digi-Key | PRT-08672-ND |

The board and connections are shown here
![controller board](https://i.imgur.com/2ZPMwvZ.jpg)

The Teensy mounting detail can be seen here.
I used a socket for prototyping.
![teensy detail](https://i.imgur.com/HrkGUjc.jpg)


Since the proper mounting of the Teensy board places the reset button in a tight space, I added a 2-pin header to the reset and ground pins on the edge of the board.
Shorting these two pins together will reset the board.
I also put female to male header jumper cables on these so they could be accessed outside the enclosure.
The exterior cables can be seen here.
![exterior reset](https://i.imgur.com/JNoxI40.jpg)


## Keymaps

### Default

To build with the default keymap, run `make kinesis/stapelberg` while in the QMK directory.

### Dvorak

This keymap contains a dvorak implementation as well as media and symbol layers.

Run `make kinesis/stapelberg:dvorak` while in the QMK directory.
