# DCompact Layout

**Dvorak, Layered, Mouse-Enabled, Compact -- now with Plover~**

_See [the layout source](keymap.c) for the actual layout_

## Goals

The following are the goals kept in mind when designing the DCompact
layout:

- Provide minimal travel distance when typing English or coding
- Consistent muscle memory translation from standard QWERTY
- Stateless typing experience
- OS-agnostic features, macros, and key placement
- Minimize dependence on mouse usage

These are generally all met or balanced within reason. This layout is
not intended at all to be a familiar layout for much of anyone (except
maybe those who already type in Dvorak) -- this is meant to amplify the
best parts of having limited, ortholinear keys with layering.

## As Reference Material

If you're reading this hoping to find reference material to implement
your own layout, then please feel free to copy over this layout and
make edits where you see fit. I removed a lot of the features I felt
extraneous to my usage and simplified style where I felt needed. This
would hopefully mean that my code should feel like a good base to
develop from for those new to QMK.

_Remember that settings defined in the layout directory override and
merge with those in the keyboard folder_

## Relevant Links

- [Online Dvorak Layout Trainer](https://learn.dvorak.nl/)
- [Dvorak Wikipedia Page](https://en.wikipedia.org/wiki/Dvorak_Simplified_Keyboard)
- [QMK Docs](https://docs.qmk.fm/#/)
- [QMK KeyCode Reference](https://docs.qmk.fm/#/keycodes)

## Contact

Maintainer: [Dan](https://github.com/loksonarius)

