#pragma once

#include "quantum.h"

/* LAYOUT_all
 * ,-----------------------------------------------------------.
 * |00 |01 |02 |03 |04 |05 |06 |07 |08 |09 |0A |0B |0C |0D |49 |
 * |-----------------------------------------------------------|      ,-----.
 * |10   |11 |12 |13 |14 |15 |16 |17 |18 |19 |1A |1B |1C |1D   |      |     |
 * |-----------------------------------------------------------|   ,---.    |
 * |20    |21 |22 |23 |24 |25 |26 |17 |28 |29 |2A |2B |2D      |   |2C |2D  |
 * |-----------------------------------------------------------|   `--------'
 * |30  |31 |32 |33 |34 |35 |36 |37 |38 |39 |3A |3B |3D    |3C |
 * |-----------------------------------------------------------|
 * |40  |41  |42  |           45           |4A  |4B  |4C  |4D  |
 * `-----------------------------------------------------------'
 * 2u Backspace = K0D
 * 2.25u left Shift = K30
 * 2.75u right Shift = K3D
 */
#define LAYOUT_all( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K49, \
    K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D,      \
    K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K2D,      \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3D, K3C,      \
    K40, K41, K42,                K45,                K4A, K4B, K4C, K4D       \
) { \
    { K00,  K01,  K02,  K03,    K04,    K05,  K06,    K07,    K08,    K09,  K0A,  K0B,  K0C,  K0D }, \
    { K10,  K11,  K12,  K13,    K14,    K15,  K16,    K17,    K18,    K19,  K1A,  K1B,  K1C,  K1D }, \
    { K20,  K21,  K22,  K23,    K24,    K25,  K26,    K27,    K28,    K29,  K2A,  K2B,  K2C,  K2D }, \
    { K30,  K31,  K32,  K33,    K34,    K35,  K36,    K37,    K38,    K39,  K3A,  K3B,  K3C,  K3D }, \
    { K40,  K41,  K42,  KC_NO,  KC_NO,  K45,  KC_NO,  KC_NO,  KC_NO,  K49,  K4A,  K4B,  K4C,  K4D }  \
}

/* LAYOUT
 * Present for backwards compatibility with older keymaps. The commit that added
 * split Backspace support put the right 1u key of the split on the bottom row,
 * next to right Alt. The arguments for 1.75/1u right Shift are also in reverse
 * order.
 * ,-----------------------------------------------------------.
 * |00 |01 |02 |03 |04 |05 |06 |07 |08 |09 |0A |0B |0C |0D |49 |
 * |-----------------------------------------------------------|      ,-----.
 * |10   |11 |12 |13 |14 |15 |16 |17 |18 |19 |1A |1B |1C |1D   |      |     |
 * |-----------------------------------------------------------|   ,---.    |
 * |20    |21 |22 |23 |24 |25 |26 |17 |28 |29 |2A |2B |2D      |   |2C |2D  |
 * |-----------------------------------------------------------|   `--------'
 * |30  |31 |32 |33 |34 |35 |36 |37 |38 |39 |3A |3B |3D    |3C |
 * |-----------------------------------------------------------|
 * |40  |41  |42  |           45           |4A  |4B  |4C  |4D  |
 * `-----------------------------------------------------------'
 */
#define LAYOUT( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, \
    K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, \
    K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K2D, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, \
    K40, K41, K42,           K45,                K49, K4A, K4B, K4C, K4D  \
) LAYOUT_all( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K49, \
    K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D,      \
    K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K2D,      \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3D, K3C,      \
    K40, K41, K42,                K45,                K4A, K4B, K4C, K4D       \
)

/* LAYOUT_60_ansi
 * ,-----------------------------------------------------------.
 * |00 |01 |02 |03 |04 |05 |06 |07 |08 |09 |0A |0B |0C |0D     |
 * |-----------------------------------------------------------|
 * |10   |11 |12 |13 |14 |15 |16 |17 |18 |19 |1A |1B |1C |1D   |
 * |-----------------------------------------------------------|
 * |20    |21 |22 |23 |24 |25 |26 |17 |28 |29 |2A |2B |2D      |
 * |-----------------------------------------------------------|
 * |30      |32 |33 |34 |35 |36 |37 |38 |39 |3A |3B |3D        |
 * |-----------------------------------------------------------|
 * |40  |41  |42  |           45           |4A  |4B  |4C  |4D  |
 * `-----------------------------------------------------------'
 */
#define LAYOUT_60_ansi( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, \
    K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, \
    K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,      K2D, \
    K30,      K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,      K3D, \
    K40, K41, K42,                K45,                K4A, K4B, K4C, K4D  \
) { \
    { K00,  K01,   K02,  K03,    K04,    K05,  K06,    K07,    K08,    K09,   K0A,  K0B,  K0C,   K0D }, \
    { K10,  K11,   K12,  K13,    K14,    K15,  K16,    K17,    K18,    K19,   K1A,  K1B,  K1C,   K1D }, \
    { K20,  K21,   K22,  K23,    K24,    K25,  K26,    K27,    K28,    K29,   K2A,  K2B,  KC_NO, K2D }, \
    { K30,  KC_NO, K32,  K33,    K34,    K35,  K36,    K37,    K38,    K39,   K3A,  K3B,  KC_NO, K3D }, \
    { K40,  K41,   K42,  KC_NO,  KC_NO,  K45,  KC_NO,  KC_NO,  KC_NO,  KC_NO, K4A,  K4B,  K4C,   K4D }  \
}
