# dnsnrk's KDB67 MKII Layout

* This is a three layer layout wih some consolidated functionality in the second and third layer.
* The keyboard is mostly used on macOS, but also on Linux and therefore it can swap ALT/CMD.
* There are additional CTRL keys for left and right when caps lock or enter key is held.
* Layers can be toggled (tap twice) or actived momentarily (hold).
* There are 2 seperate FN keys to activate layer 1 and 2 separately, indicated by different RGB colors.
* The main custom feature is using RGB to indicate the current active layer for each key. This is best achieved in solid color RGB modes.

## Layer 0

This is the base QUERTY layer.

* Grave is provided in the top right corner.
* Caps lock is tapped once on and off and indicated by hue inverted LED when on.
* Caps lock and enter become CTRL when held.
* Primary Fn in the last row activates layer 1, indicated by hue shifted LED color.
* Secondary Fn right to the up arrow key activates layer 2, indicated by 2nd hue shifted LED color.
* Toggle layers by tapping Fn twice or switch on by holding Fn.

## Layer 1

This layer activates function keys and provides RGB controls. Keys acting on this layer are indicated by an LED color matching the current Fn key's LED color.

* Number keys become equivalent function keys.
* ESC becomes Grave.
* Grave becomes POWER (very useful on macOS only).
* Q toggles RGB.
* WASD for navigating through RGB modes and adjusting speed.
* <> control RGB saturation.
* Arrow keys shift hue and adjust brightness.
* PgUp, PgDown become HOME and END respectively.
* Backspace acts as delete, pipe as insert.

## Layer 2

This layer comprises most macOS media keys at the top row and some additional programming options. Keys acting on this layer are indicated by an LED color matching the current Fn key's LED color.

* N, M swap ALT/CMD for (N)ormal or (M)acOS.
* E resets (E)EPROM.
* R (R)esets keyboard.
