/* Copyright 2019 coseyfannitutti
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once

#include "quantum.h"

#define _x_ KC_NO

/* This a shortcut to help you visually see your layout.
 *
 * The first section contains all of the arguments representing the physical
 * layout of the board and position of the keys.
 *
 * The second converts the arguments into a two-dimensional array which
 * represents the switch matrix.
 */
#define LAYOUT_all( \
  K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, \
  K10, K11, K12, K13, K14, K15, K16, K17, K18, K19,      K1B, \
  K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, \
  K30, K31, K32,      K34,      K36, K37,      K39, K3A, K3B  \
) { \
{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, }, \
{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, _x_, K1B, }, \
{ K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, }, \
{ K30, K31, K32, _x_, K34, _x_, K36, K37, _x_, K39, K3A, K3B, }  \
}

#define LAYOUT_ansi_40( \
  K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, \
  K10, K11, K12, K13, K14, K15, K16, K17, K18, K19,      K1B, \
  K20,      K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, \
  K30, K31, K32,                K36,           K39, K3A, K3B  \
) { \
{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, }, \
{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, _x_, K1B, }, \
{ K20, _x_, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, }, \
{ K30, K31, K32, _x_, _x_, _x_, K36, _x_, _x_, K39, K3A, K3B, }  \
}

#define LAYOUT_ansi_split_lshift( \
  K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, \
  K10, K11, K12, K13, K14, K15, K16, K17, K18, K19,      K1B, \
  K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, \
  K30, K31, K32,                K36,           K39, K3A, K3B  \
) { \
{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, }, \
{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, _x_, K1B, }, \
{ K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, }, \
{ K30, K31, K32, _x_, _x_, _x_, K36, _x_, _x_, K39, K3A, K3B, }  \
}

#define LAYOUT_ansi_split_space( \
  K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, \
  K10, K11, K12, K13, K14, K15, K16, K17, K18, K19,      K1B, \
  K20,      K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, \
  K30, K31, K32,      K34,      K36, K37,      K39, K3A, K3B  \
) { \
{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, }, \
{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, _x_, K1B, }, \
{ K20, _x_, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, }, \
{ K30, K31, K32, _x_, K34, _x_, K36, K37, _x_, K39, K3A, K3B, }  \
}
