#include QMK_KEYBOARD_H


#define _BASE 0
#define _FNO 1
#define _FNT 2

#define ________ KC_TRNS
#define XXXXXXXX KC_NO

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

  /*
   * Base layer
   *
   * -------------------------------------------------------------------------------------------
   * |  `  |  1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  |  0  |  -  |  =  |  \  | Del |
   * -------------------------------------------------------------------------------------------
   * | Tab    |  Q  |  W  |  E  |  R  |  T  |  Y  |  U  |  I  |  O  |  P  |  [  |  ]  |  Bksp  |
   * -------------------------------------------------------------------------------------------
   * | Fn1      |  A  |  S  |  D  |  F  |  G  |  H  |  J  |  K  |  L  |  ;  |  '  |  Enter     |
   * -------------------------------------------------------------------------------------------
   * | Shift       |  Z  |  X  |  C  |  V  |  B  |  N  |  M  |  ,  |  .  |  /  |  Up     | Fn2 |
   * -------------------------------------------------------------------------------------------
   * | Ctrl  | Win   | Alt   |              Space              | AltGr | Left  | Down  | Right |
   * -------------------------------------------------------------------------------------------
   */
  [_BASE] = LAYOUT_60_ansi_split_bs_rshift(
    KC_GRV,   KC_1,     KC_2,     KC_3,     KC_4,     KC_5,     KC_6,     KC_7,     KC_8,     KC_9,     KC_0,     KC_MINS,  KC_EQL,   KC_BSLS,  KC_DEL, \
    KC_TAB,   KC_Q,     KC_W,     KC_E,     KC_R,     KC_T,     KC_Y,     KC_U,     KC_I,     KC_O,     KC_P,     KC_LBRC,  KC_RBRC,  KC_BSPC,  \
    MO(_FNO), KC_A,     KC_S,     KC_D,     KC_F,     KC_G,     KC_H,     KC_J,     KC_K,     KC_L,     KC_SCLN,  KC_QUOT,            KC_ENT,   \
    KC_LSFT,            KC_Z,     KC_X,     KC_C,     KC_V,     KC_B,     KC_N,     KC_M,     KC_COMM,  KC_DOT,   KC_SLSH,  KC_UP,    MO(_FNT), \
    KC_LCTL,  KC_LGUI,  KC_LALT,                      KC_SPC,                                           KC_RALT,  KC_LEFT,  KC_DOWN,  KC_RGHT
  ),

  /*
   * Fn1 layer
   *
   * -------------------------------------------------------------------------------------------
   * | Esc | F1  | F2  | F3  | F4  | F5  | F6  | F7  | F8  | F9  | F10 | F11 | F12 | Prsc| Ins |
   * -------------------------------------------------------------------------------------------
   * |        |     |     |     |     |     |     |     |     |     |     |     |     |        |
   * -------------------------------------------------------------------------------------------
   * | NONE     |     |     |     |     |     |     |     |     |     |     |     |            |
   * -------------------------------------------------------------------------------------------
   * |             |     |     |     |     |     |     |     |     |     |     |  PgUp   |     |
   * -------------------------------------------------------------------------------------------
   * |       |       |       |                                 |       | Home  | PgDn  | End   |
   * -------------------------------------------------------------------------------------------
   */
  [_FNO] = LAYOUT_60_ansi_split_bs_rshift(
    KC_ESC,   KC_F1,    KC_F2,    KC_F3,    KC_F4,    KC_F5,    KC_F6,    KC_F7,    KC_F8,    KC_F9,    KC_F10,   KC_F11,   KC_F12,   KC_PSCR,  KC_INS, \
    ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, \
    ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________,           ________, \
    ________,           ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, KC_PGUP,  ________, \
    ________, ________, ________,                     ________,                                         ________, KC_HOME,  KC_PGDN,  KC_END
  ),

  /*
   * Fn2 layer
   *
   * TODO: macro buttons
   *
   * -------------------------------------------------------------------------------------------
   * |     |     |     |     |     |     |     |     |     |     |     |     |     |     |     |
   * -------------------------------------------------------------------------------------------
   * |        |     |     |     |     |     |     |     |     | Prev| Play| Next|     |        |
   * -------------------------------------------------------------------------------------------
   * | CapsLk   |     |     |     |     |     |     |     |     | Vol-| Vol+| Mute|            |
   * -------------------------------------------------------------------------------------------
   * |             |     |     |     |     |     |     |     |     | Stop|     |         | NONE|
   * -------------------------------------------------------------------------------------------
   * | Reset | Menu  |       |                                 |  M1   |  M2   |  M3   |  M4   |
   * -------------------------------------------------------------------------------------------
   */
  [_FNT] = LAYOUT_60_ansi_split_bs_rshift(
    ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, ________, \
    ________, ________, ________, ________, ________, ________, ________, ________, ________, KC_MPRV,  KC_MPLY,  KC_MNXT,  ________, ________, \
    KC_CAPS,  ________, ________, ________, ________, ________, ________, ________, ________, KC_VOLD,  KC_VOLU,  KC_MUTE,            ________, \
    ________,           ________, ________, ________, ________, ________, ________, ________, ________, KC_MSTP,  ________, ________, ________, \
    RESET,    KC_MENU,  ________,                     ________,                                         ________, ________, ________, ________
  ),
};
