#include QMK_KEYBOARD_H

#define ______ KC_TRNS

#define LAYER_1 1
#define LAYER_2 2
#define LAYER_3 3

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

  /* Base Layer
   * ,-----------------------------------------------------------------------------------------.
   * | ` ~ |  1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  |  0  |  -  |  =  |   Bkspc   |
   * |-----------------------------------------------------------------------------------------+
   * | Tab    |  Q  |  W  |  E  |  R  |  T  |  Y  |  U  |  I  |  O  |  P  |  [  |  ]  |    \   |
   * |-----------------------------------------------------------------------------------------+
   * | LAY1    |  A  |  S  |  D  |  F  |  G  |  H  |  J  |  K  |  L  |  ;  |  '  |    Enter    |
   * |-----------------------------------------------------------------------------------------+
   * | Shift     |  Z  |  X  |  C  |  V  |  B  |  N  |  M  |  ,  |  .  |  /  | RSh |  U  | LAY2|
   * |-----------------------------------------------------------------------------------------+
   * | Ctrl |  Cmd  |  Alt  |   LAY1    | LAY2 |      SPACE     | RAlt | LAY1 |  L  |  D  |  R |
   * `-----------------------------------------------------------------------------------------'
   */

  LAYOUT_all(
      KC_GRAVE, KC_1, KC_2, KC_3, KC_4, KC_5, KC_6, KC_7, KC_8, KC_9, KC_0, KC_MINS, KC_EQL, ______, KC_BSPC,

      KC_TAB, KC_Q, KC_W, KC_E, KC_R, KC_T, KC_Y, KC_U, KC_I, KC_O, KC_P, KC_LBRC, KC_RBRC, KC_BSLS,

      MO(LAYER_1), KC_A, KC_S, KC_D, KC_F, KC_G, KC_H, KC_J, KC_K, KC_L, KC_SCLN, KC_QUOT, KC_ENT,

      KC_LSFT, ______, KC_Z, KC_X, KC_C, KC_V, KC_B, KC_N, KC_M, KC_COMM, KC_DOT, KC_SLSH, KC_RSFT, KC_UP, MO(LAYER_2),

      KC_LCTL, KC_LGUI, KC_LALT, MO(LAYER_1),  MO(LAYER_1), KC_SPC, KC_RALT, MO(LAYER_1), KC_LEFT, KC_DOWN, KC_RIGHT
      ),

  /* Layer 1
   * ,-----------------------------------------------------------------------------------------.
   * | Esc |  F1 |  F2 |  F3 |  F4 |  F5 |  F6 |  F7 |  F8 |  F9 | F10 | F11 | F12 |   DEL     |
   * |-----------------------------------------------------------------------------------------+
   * |       | PREV | PLAY | NEXT |     |     |     |     |  Up |      |     |     |    |      |
   * |-----------------------------------------------------------------------------------------+
   * |         |    |    |    |   |   |     | Home| Left | Down | Right | End |     |          |
   * |-----------------------------------------------------------------------------------------+
   * |           |     |     |     |     |     |     |     |     |     |     |     |VOL+|      |
   * |-----------------------------------------------------------------------------------------+s
   * |      |       |       |                                   |     |      |     |VOL-| MUTE |
   * `-----------------------------------------------------------------------------------------'
   KC_VOLD, KC_VOLU, KC_MUTE,
   KC_MPRV, KC_MPLY, KC_MNXT,
   */

  LAYOUT_all(
      KC_ESC, KC_F1,   KC_F2,   KC_F3,   KC_F4,   KC_F5,   KC_F6,   KC_F7,   KC_F8,   KC_F9,  KC_F10, KC_F11, KC_F12, ______, KC_DEL,

      ______, KC_MPRV, KC_MPLY, KC_MNXT, ______, ______, ______, ______, KC_UP, ______, ______, ______, ______, ______,

      ______, ______, ______, ______, ______, ______, KC_HOME, KC_LEFT, KC_DOWN, KC_RIGHT, KC_END, ______, ______,

      ______, ______, ______, ______, ______, ______, ______, ______, ______, ______, ______, ______, ______, KC_VOLU, ______,

      ______, ______, ______, ______, ______, ______, ______, ______, ______, KC_VOLD, KC_MUTE
      ),

  /* Layer 2
   * ,-----------------------------------------------------------------------------------------.
   * | RESET |  F1 |  F2 |  F3 |  F4 |  F5 |  F6 |  F7 |  F8 |  F9 | F10 | F11 | F12 |  RESET  |
   * |-----------------------------------------------------------------------------------------+
   * |        |RBB T|RGB M| Hue+| Hue-| Sat+| Sat-| Val+| Val-|     |     |      |      |      |
   * |-----------------------------------------------------------------------------------------+
   * |         | BL T| BL M| BL+ | BL- |     |     |     |     |     |     |     |             |
   * |-----------------------------------------------------------------------------------------+
   * |           |     |     |     |     |     |     |     |     |     |     |     |     |     |
   * |-----------------------------------------------------------------------------------------+
   * |      |       |       |                                   |     |      |     |     |     |
   * `-----------------------------------------------------------------------------------------'
   */

  LAYOUT_all(
      RESET, KC_F1,   KC_F2,   KC_F3,   KC_F4,   KC_F5,   KC_F6,   KC_F7,   KC_F8,   KC_F9,  KC_F10, KC_F11, KC_F12, ______, RESET,

      ______, RGB_TOG, RGB_MOD, RGB_HUI, RGB_HUD, RGB_SAI, RGB_SAD, RGB_VAI, RGB_VAD, ______, ______, ______, ______, ______,

      ______, BL_TOGG, BL_STEP, BL_INC, BL_DEC, ______, ______, ______, ______, ______, ______, ______, ______,

      ______, ______, ______, ______, ______, ______, ______, ______, ______, ______, ______, ______, ______, ______, ______,

      ______, ______, ______, ______, ______, ______, ______, ______, ______, ______, ______
      ),
};
