#include QMK_KEYBOARD_H

enum layer_names {
  _QW,
  _L1,
  _L2,
};

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
  /* 0: qwerty */
  /*┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┐
    │Esc│ 1 │ 2 │ 3 │ 4 │ 5 │ 6 │ 7 │ 8 │ 9 │ 0 │ - │ = │ Bcksp │
    ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┤
    │ Tab │ Q │ W │ E │ R │ T │ Y │ U │ I │ O │ P │ [ │ ] │ Ent │
    ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐    │
    │ Ctrl │ A │ S │ D │ F │ G │ H │ J │ K │ L │ ; │ ' │ \ │    │
    ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴────┤
    │Shft│ ` │ Z │ X │ C │ V │ B │ N │ M │ , │ . │ / │  Shift   │
    ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬────┬────┤
    │ Fn │Alt │Cmd │         Space          │Cmd │Hypr│Ctrl│Fn 2│
    └────┴────┴────┴────────────────────────┴────┴────┴────┴────┘*/
  [_QW] = LAYOUT_60_iso( /* Layer 0: Qwerty */
    KC_ESC,  KC_1,    KC_2,    KC_3,    KC_4,    KC_5,    KC_6,    KC_7,    KC_8,    KC_9,    KC_0,    KC_MINS, KC_EQL,  KC_BSPC,
    KC_TAB,  KC_Q,    KC_W,    KC_E,    KC_R,    KC_T,    KC_Y,    KC_U,    KC_I,    KC_O,    KC_P,    KC_LBRC, KC_RBRC,
    KC_LCTL, KC_A,    KC_S,    KC_D,    KC_F,    KC_G,    KC_H,    KC_J,    KC_K,    KC_L,    KC_SCLN, KC_QUOT, KC_BSLS, KC_ENT,
    KC_LSFT, KC_GRV,  KC_Z,    KC_X,    KC_C,    KC_V,    KC_B,    KC_N,    KC_M,    KC_COMM, KC_DOT,  KC_SLSH, KC_RSFT,
    MO(_L1), KC_LALT, KC_LGUI,                   KC_SPC,                                      KC_RGUI, KC_HYPR, KC_RCTL, MO(_L2)
  ),
  /* 1: fn */
  /*┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┐
    │ § │Br-│Br+│   │   │BL-│BL+│Pre│Pau│Nxt│Mut│Vo-│Vo+│  Del  │
    ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┤
    │     │   │   │   │   │   │   │   │   │   │   │   │   │ Ins │
    ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐    │
    │      │   │   │   │   │   │ ◀ │ ▼ │ ▲ │ ▶ │   │   │   │    │
    ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴────┤
    │    │   │   │   │   │   │BL~│   │   │   │   │   │          │
    ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬────┬────┤
    │    │    │    │                        │    │    │    │    │
    └────┴────┴────┴────────────────────────┴────┴────┴────┴────┘*/
  [_L1] = LAYOUT_60_iso( /* Layer 1: Functions */
    KC_NUBS, KC_BRID, KC_BRIU, _______, _______, BL_DEC,  BL_INC,  KC_MRWD, KC_MPLY, KC_MFFD, KC_MUTE, KC_VOLD, KC_VOLU, KC_DEL,
    _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______,
    _______, _______, _______, _______, _______, _______, KC_LEFT, KC_DOWN, KC_UP,   KC_RGHT, _______, _______, _______, KC_INS,
    _______, _______, _______, _______, _______, _______, BL_TOGG, _______, _______, _______, _______, _______, _______,
    _______, _______, _______,                   _______,                                     _______, _______, _______, _______
  ),
  /* 2: fn 2 */
  /*┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┐
    │Pwr│F1 │F2 │F3 │F4 │F5 │F6 │F7 │F8 │F9 │F10│F11│F12│ Eject │
    ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┤
    │     │   │   │   │   │   │   │   │   │   │   │   │   │     │
    ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐    │
    │ Caps │   │   │   │   │   │Hom│PgD│PgU│End│   │   │   │    │
    ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴────┤
    │    │   │   │   │   │   │Rst│   │   │   │   │   │          │
    ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬────┬────┤
    │    │    │    │                        │    │    │    │    │
    └────┴────┴────┴────────────────────────┴────┴────┴────┴────┘*/
  [_L2] = LAYOUT_60_iso( /* Layer 2: Functions */
    KC_PWR,   KC_F1,  KC_F2,   KC_F3,   KC_F4,   KC_F5,   KC_F6,   KC_F7,   KC_F8,   KC_F9,   KC_F10,  KC_F11,  KC_F12,  KC_EJCT,
    _______, RGB_HUI, RGB_SAI, RGB_VAI, RGB_TOG, RGB_M_T, RGB_MOD, _______, _______, _______, _______, _______, _______,
    KC_CAPS, RGB_HUD, RGB_SAD, RGB_VAD, RGB_M_SW,RGB_M_G, KC_HOME, KC_PGDN, KC_PGUP, KC_END,  _______, _______, _______, _______,
    _______, RGB_M_P, RGB_M_B, RGB_M_R, RGB_M_K, _______, RESET  , _______, _______, _______, _______, _______, _______,
    _______, _______, _______,                   _______,                                     _______, _______, _______, _______
  ),
};
