#pragma once

#include "quantum.h"

#define red_led_off   PORTF |= (1<<5)
#define red_led_on    PORTF &= ~(1<<5)
#define blu_led_off   PORTF |= (1<<4)
#define blu_led_on    PORTF &= ~(1<<4)
#define grn_led_off   PORTD |= (1<<1)
#define grn_led_on    PORTD &= ~(1<<1)

#define set_led_off     red_led_off; grn_led_off; blu_led_off
#define set_led_red     red_led_on;  grn_led_off; blu_led_off
#define set_led_blue    red_led_off; grn_led_off; blu_led_on
#define set_led_green   red_led_off; grn_led_on;  blu_led_off
#define set_led_yellow  red_led_on;  grn_led_on;  blu_led_off
#define set_led_magenta red_led_on;  grn_led_off; blu_led_on
#define set_led_cyan    red_led_off; grn_led_on;  blu_led_on
#define set_led_white   red_led_on;  grn_led_on;  blu_led_on

// This a shortcut to help you visually see your layout.
// The first section contains all of the arguements
// The second converts the arguments into a two-dimensional array

#define LAYOUT( \
  k00, k01, k02, k03, k04, k05,      k06, k07, k08, k09, k10, k11, \
  k12, k13, k14, k15, k16, k17,      k18, k19, k20, k21, k22, k23, \
  k24, k25, k26, k27, k28, k29,      k30, k31, k32, k33, k34, k35, \
  k36, k37, k38, k39, k40, k41,      k42, k43, k44, k45, k46, k47, \
                      k48, k49,      k50, k51 \
) \
{ \
  { k03, k40, k26,   k15,   k28,   k01,   k42, k31, k20,   k33,   k08,   k10   }, \
  { k00, k37, k14,   k27,   k16,   k36,   k47, k19, k32,   k21,   k46,   k11   }, \
  { k12, k25, k02,   k39,   k17,   k49,   k50, k18, k44,   k09,   k34,   k23   }, \
  { k24, k13, k38,   k04,   k05,   k48,   k51, k06, k07,   k45,   k22,   k35   }, \
  { k29, k41, KC_NO, KC_NO, KC_NO, KC_NO, k30, k43, KC_NO, KC_NO, KC_NO, KC_NO }  \
}
