# Overview

This layout is based on Balance Twelve (mirror variant) by Sasha Viminitz. Please see [this page](https://mathematicalmulticore.wordpress.com/the-keyboard-layout-project/) 
for more information. It's designed for left-handers who use their right hand for the mouse.

## To build

```
sudo make atreus:yttyx
```

## To flash (example)

```
sudo avrdude -p atmega32u4 -c avr109 -U flash:w:atreus_yttyx.hex -P /dev/ttyACM0
```

## Layers

### Base:

    .--------.-------.-------.-------.--------.                           .-------.-------.-------.-------.------.
    | P      | L     | C     | D     | W      |                           | U     | O     | Y     | K     | Q    |
    |--------+-------+-------+-------+--------|                           |-------+-------+-------+-------+------|
    | N      | R     | S     | T     | M      |                           | A     | E     | I     | H     | V    |
    |--------+-------+-------+-------+--------|                           |-------+-------+-------+-------+------|
    | Z Sft  | J Ctl | F Alt | G     | B      |                           | ,     | . Alt | ; Ctl | X Sft | Sup  |
    '--------'-------'-------+-------+--------+-----.               .-----+-------+-------+-------'-------'------'
                             | BS P1 | Spc P2 | P3  |               |     | Sft   |       |
                             '-------'--------'-----'               '-----'-------'-------'

### P1: Punctuation (1)


    .--------.-------.-------.-------.-------.                              .------.-------.-------.-------.------.
    | Esc    |       |       |       | RS    |                              | |    | /     | ^     |      |  ~   |
    |--------+-------+-------+-------+-------|                              |------+-------+-------+-------+------|
    | Tab    |       |       |       |       |                              | &    | \     | `     | $     | Ent  |
    |--------+-------+-------+-------+-------|                              |------+-------+-------+-------+------|
    | Sft    | Ctl   | Alt   | Del   |       |                              | %    | Alt   | Ctl   | Sft   | Sup  |
    '--------'-------'-------+-------+-------+-----.                  .-----+------+-------+-------'-------'------'
                             | P1    |       |     |                  |     | Sft  |       |
                             '-------'-------'-----'                  '-----'------'-------'

### P2: Punctuation (2)

    .-------.-------.-------.-------.-------.                               .-------.-------.-------.-------.------.
    | Esc   |       | NC    | FV    |       |                               | (     | )     | "     | ?     |      |
    |-------+-------+-------+-------+-------|                               |-------+-------+-------+-------+------|
    | Tab   | Ctl-X | Ctl-C | Ctl-V | Ctl-Z |                               | {     | }     | '     | !     | Ent  |
    |-------+-------+-------+-------+-------|                               |-------+-------+-------+-------+------|
    | Sft   | Ctl   | Alt   | Del   | Ent   |                               | #     | Alt   | Ctl   | Sft   | Sup  |
    '-------'-------'-------+-------+-------+-----.                   .-----+-------+-------+-------'-------'------'
                            | BS    | P2    |     |                   |     | Sft   |       |
                            '-------'-------'-----'                   '-----'-------'-------'

### P3: Punctuation (3)

    .-------.-------.-------.-------.-------.                             .------.-------.-------.-------.------.
    | Esc   |       | Break | Pscr  | ScLk  |                             | <    | >     | +     | _     | =    |
    |-------+-------+-------+-------+-------|                             |------+-------+-------+-------+------|
    | Tab   |       |       | Caps  |       |                             | [    | ]     | *     | -     | Ent  |
    |-------+-------+-------+-------+-------|                             |------+-------+-------+-------+------|
    | Sft   | Ctl   | Alt   | Del   |       |                             | @    | Alt   | Ctl   | Sft   | Sup  |
    '-------'-------'-------+-------+-------+-----.                 .-----+------+-------+-------'-------'------'
                            | BS    |       | P3  |                 |     | Sft  |       |
                            '-------'-------'-----'                 '-----'------'-------'

### Numerals / Cursor control

    .-------.-------.-------.------.-------.                              .------.-------.-------.------.------.
    | 1     | 2     | 3     | 4    | 5     |                              | Home | Up    | End   | PgUp |      |
    |-------+-------+-------+------+-------|                              |------+-------+-------+------+------|
    | 6     | 7     | 8     | 9    | 0     |                              | Left | Down  | Right | PgDn |      |
    |-------+-------+-------+------+-------|                              |------+-------+-------+------+------|
    | Sft   | Ctl   | Alt   | Del  | .     |                              | Ins  | Alt   | Ctl   | Sft  | Sup  |
    '-------'-------'-------+------+-------+-----.                  .-----+------+-------+-------'------'------'
                            | BS   | BA    |     |                  |     | Sft  |       |
                            '------'-------'-----'                  '-----'------'-------'

### FV: Function keys / Cursor control (Vim)

    .-------.------.-------.-----.-------.                                .------.-------.-----.-------.------.
    | F1    | F2   | F3    | F4  | F5    |                                | 0    | K     | $   | Ctl-B |      |
    |-------+------+-------+-----+-------|                                |------+-------+-----+-------+------|
    | F6    | F7   | F8    | F9  | F10   |                                | H    | J     | L   | Ctl-F |      |
    |-------+------+-------+-----+-------|                                |------+-------+-----+-------+------|
    | Sft   | Ctl  | Alt   | F11 | F12   |                                |      | Alt   | Ctl | Sft   | Sup  |
    '-------'------'-------+-----+-------+-----.                    .-----+------+-------+-----'-------'------'
                           | BS  | BA    |     |                    |     | Sft  |       |
                           '-----'-------'-----'                    '-----'------'-------'

### RS: Reset

    .-------.------.-------.-----.-------.                                .------.-------.-----.-------.------.
    | RESET |      |       |     |       |                                |      |       |     |       |      |
    |-------+------+-------+-----+-------|                                |------+-------+-----+-------+------|
    |       |      |       |     |       |                                |      |       |     |       |      |
    |-------+------+-------+-----+-------|                                |------+-------+-----+-------+------|
    |       |      |       |     |       |                                |      |       |     |       |      |
    '-------'------'-------+-----+-------+-----.                    .-----+------+-------+-----'-------'------'
                           |     | BA    |     |                    |     |      |       |
                           '-----'-------'-----'                    '-----'------'-------'
