Jeremy's Atreus Key Mapping
===========================

I am a programmer by trade that suffers from the beginning stages of RSI. As a programmer I use letters, symbols and cursor navigation most often. To prevent strange finger gymnastics, I wrote a script to rank which non-letter characters occurred in my primary source projects most often and then placed these characters in the easiest to reach locations, for me. I made heavy use of momentary layer toggling.

My layout is also geared toward a software based Colemak mapping. I would like it to be hardware, but I use my Laptop on the go frequently and thus my laptop keyboard. I have moved the keycaps to reflect the Colemak layout. My laptop is a MacBook Pro (2015).

## Main Layers

1. [Letters](http://www.keyboard-layout-editor.com/#/gists/6861cb9df09ce78efaddf8aa7471e3ac)
2. [Symbols](http://www.keyboard-layout-editor.com/#/gists/8956a18b508a78e93b9c38ec3fcccaa5)
3. [Navigation](http://www.keyboard-layout-editor.com/#/gists/6ed492b714a7f54eb1c5de09b87fd8c4)
4. [Numbers](http://www.keyboard-layout-editor.com/#/gists/399ceb5624e8388e48a3a5eacac8e973)
5. [Function Keys](http://www.keyboard-layout-editor.com/#/gists/7fd7dc24c7048316f3724b1893c64e89)

## Notes

### General

Some characters can be accessed multiple ways. This was done because you may be in a given layer, such as numbers, where when doing math, you may need quick access to the parentheses characters for grouping. This prevents some layer switching.

I own an ErgoDox and plan on porting this as a base layer, then using the extra keys the ErgoDox provides accordingly. My goal, though, is to be fully functional on this base setup and build everything into muscle memory.

### Symbol Layer

1. I placed characters that deal with an if statement close together, such as !, & and |.
2. All matching brace/bracket characters are together as well.

### Number Layer

1. Everything I did was a compromise when trying to mimic a ten-key. I did the best I could.
2. Operators are duplicated on the right and left. I do not find it comfortable to use my pinky much, so I tend to use my left hand for +, -, * and / but those were also placed on the right hand to mimic the ten-key.
3. Parentheses were added for typing on the calculator.

### Cursor Layer

1. It includes basic audio controls because they didn't really fit anywhere else
2. It contains basic file manipulation. I'm not sure that was a good idea. I do save all the time, but Cmd+S isn't exactly hard.
3. It contains the backspace and delete keys right on top of the left and right arrows.
4. Cmd and Opt keys are duplicated. This makes for very easy navigation, for example on a Mac, Opt+Left/Right moves word by word. It also backspaces or deletes word by word.

### Function Layer

1. Almost all other layers I saw grouped the F keys into a bunch of three. This only gives nine function keys in order if you attempt to stay as close to the home row as possible. I went with a group of four, which gives all twelve function keys to the right hand, one row below and above the home row.
2. I duplicated the Command and Option keys the same as on the cursor layer. This makes it dead easy to hit modified function keys such as Cmd+Opt+F5. It's also easy to toss in a Shift modifier in there with the right thumb since the bottom row is preserved.
