# Введение

У вашей компьютерной клавиатуры внутри есть процессор, похожий на тот, что внутри вашего компьютера. Этот процессор выполняет программное обеспечение, которое отвечает за обнаружение нажатий клавиш и отсылку сигналов состояния клавиатуры, когда клавиши нажимаются и отпускаются. Роль такого ПО выполняет QMK, детектируя нажатия клавиш и отсылая эту информацию главному компьютеру. Сбор собственной раскладки эквивалентен сборке выполняемой программы для вашей клавиатуры.

QMK старается дать вам большую силу, оставляя простые вещи легкими и делай сложные — возможными. Вам не надо уметь программировать, чтобы создавать мощные прошивки — вам только надо следовать нескольким простым синтаксическим правилам.

# Первое знакомство

Перед тем, как вы сможете собирать раскладки, вам необходимо установить некоторое программное обеспечение и настроить ваше окружение для сборки. Это нужно сделать только один раз, вне зависимости от того, для скольких клавиатур вы планируете компилировать прошивки.

Если вы предпочитаете графический пользовательский интерфейс, пожалуйста, рассмотрите возможность использования онлайн [QMK Конфигуратора](https://config.qmk.fm). Пожалуйста, обратитесь к [Собираем вашу первую прошивку с помощью онлайн GUI](ru-ru/newbs_building_firmware_configurator.md). 


## Загрузка ПО

### Текстовый редактор

Вам понадобится программа, умеющая редактировать и сохранять **обычные текстовые** файлы. Если вы используете Windows, вы можете делать это Блокнотом, а в Linux вы можете использовать gedit. Обе программы являются простыми, но функциональными редакторами. В macOS остерегайтесь стандартного приложения TextEdit: он не будет сохранять обычные текстовые файлы, пока вы явно не выберите _Make Plain Text_ из меню _Format_.

Вы также можете скачать и установить отдельный текстовый редактор наподобие [Sublime Text](https://www.sublimetext.com/) или [VS Code](https://code.visualstudio.com/). Возможно, это наилучший вариант независимо от платформы, поскольку эти программы сделаны специально для редактирования кода.

?> Не уверены, какой выбрать текстовый редактор? Лоуренс Брэдфорд (Laurence Bradford) написал [отличное введение](https://learntocodewith.me/programming/basics/text-editors/) в тему.

### QMK Toolbox

QMK Toolbox является дополнительной графической программой для Windows и macOS, которая позволяет вам разрабатывать и отлаживать вашу клавиатуру. Вы, вероятно, посчитаете ее бесценной для легкого процесса прошивки вашей клавиатуры и просмотра отладочных сообщений, которые она отображает.

[Скачайте последний выпуск здесь.](https://github.com/qmk/qmk_toolbox/releases/latest)

* Для Windows: `qmk_toolbox.exe` (переносимое приложение) или `qmk_toolbox_install.exe` (установщик)
* Для macOS: `QMK.Toolbox.app.zip` (переносимое приложение) или `QMK.Toolbox.pkg` (установщик)

## Настройте ваше окружение

Мы постарались сделать установку QMK максимально легкой. Вам нужно только подготовить ваше Linux или Unix окружение, после этого позвольте QMK установить все остальное.

?> Если вы никогда раньше не работали с командной строкой Linux/Unix, существует несколько базовых концептов и команд, которые необходимо выучить. Эти ресурсы дадут вам достаточно знаний, чтобы работать с QMK:<br>
[Обязательные к изучению команды Linux](https://www.guru99.com/must-know-linux-commands.html)<br>
[Несколько базовых команд Unix](https://www.tjhsst.edu/~dhyatt/superap/unixcmd.html)

### Windows

Вам нужно будет установить MSYS2 и Git.

* Следуйте инструкциям по установки на [домашней странице MSYS2](https://www.msys2.org).
* Закройте все открытые терминалы MSYS2 и откройте новый терминал MSYS2 MinGW 64-bit.
* Установите Git, выполнив эту команду: `pacman -S git`.

### macOS

Вам нужно будет установить Homebrew. Следуйте инструкциям на [домашней странице Homebrew](https://brew.sh).

После установки Homebrew продолжите чтение с _Установите QMK_. На этом шаге вам надо будет запустить скрипт, который установит остальные пакеты.

### Linux

Вам нужно будет установить Git. Скорее всего, он у вас уже есть, но если нет, одна из следующих команд должна установить его:

* Debian / Ubuntu / Devuan: `apt-get install git`
* Fedora / Red Hat / CentOS: `yum install git`
* Arch: `pacman -S git`

?> Docker также является вариантом для всех платформ. [Нажмите сюда для получения подробностей.](ru-ru/getting_started_build_tools.md#docker)

## Установите QMK

Как только вы настроили ваше Linux/Unix окружение, вы готовы к загрузке QMK. Мы сделаем это при помощи Git, "клонировав" репозиторий QMK. Откройте Терминал или окно MSYS2 MinGW и оставьте его открытым до конца данного руководства. Выполните эти команды внутри него:

```shell
git clone --recurse-submodules https://github.com/qmk/qmk_firmware.git
cd qmk_firmware
```

?> Если вы уже знаете, [как пользоваться GitHub](ru-ru/getting_started_github.md), мы рекомендуем вам вместо этого создать и клонировать свой собственный форк. Если вы не понимаете, что это значит, просто проигнорируйте это сообщение.

QMK включает в себя скрипт, который поможет вам установить все оставшееся, что вам понадобится. Вы должны запустить его, набрав эту команду:

    util/qmk_install.sh

## Протестируйте ваше окружение для сборки

Теперь, когда ваше окружение QMK для сборки настроено, вы можете собрать прошивку для вашей клавиатуры. Начните с попытки собрать раскладку для клавиатуры по умолчанию. У вас должно это получиться с помощью команды в этом формате:

    make <keyboard>:default

Например, чтобы собрать прошивку для Clueboard 66%, вы введете:

    make clueboard/66/rev3:default

Когда все закончится, вы должны увидеть большой лог, который заканчивается примерно так:

```
Linking: .build/clueboard_66_rev3_default.elf                                                       [OK]
Creating load file for flashing: .build/clueboard_66_rev3_default.hex                               [OK]
Copying clueboard_66_rev3_default.hex to qmk_firmware folder                                        [OK]
Checking file size of clueboard_66_rev3_default.hex                                                 [OK]
 * The firmware size is fine - 26356/28672 (2316 bytes free)
```

# Создаем вашу раскладку

Теперь вы готовы создать свою персональную раскладку! Для этого перейдите к [Собираем вашу первую прошивку](ru-ru/newbs_building_firmware.md).
