# Введение

Эта страница пытается объяснить основную информацию, которую вы должны знать, чтобы работать с проектом QMK. Предполагается, что вы знакомы с навигацией в оболочке Unix, но не предполагается, что вы знакомы с C или с компиляцией с использованием make.

## Базовая структура QMK

QMK - это форк [Джуна Вако (Jun Wako)](https://github.com/tmk) проекта [tmk_keyboard](https://github.com/tmk/tmk_keyboard). Оригинальный код TMK с изменениями можно найти в папке `tmk_core`. Дополнения QMK к проекту можно найти в папке `quantum`. Проекты клавиатур можно найти в папках `handwired` и `keyboard`.

### Структура пространства пользователя

Внутри папки `users` находится каталог для каждого пользователя. Это место для пользователей, куда они могут поместить код, чтобы использовать его с разными клавиатурами. Для получения дополнительной информации обратитесь к документации по [функциям пользовательского пространства](ru-ru/feature_userspace.md).

### Структура проекта клавиатуры

Внутри папки `keyboards` есть подпапки `handwired` и есть подкаталоги поставщиков и производителей, для примера, `clueboard` - это каталог для каждого проекта клавиатуры, например, `qmk_firmware/keyboards/clueboard/2x1800`. В нем вы найдете следующую структуру:
* `keymaps/`: Различные раскладки клавиш, которые можно собрать.
* `rules.mk`: Файл, который устанавливает параметры по умолчанию для команды "make". Не редактируйте этот файл напрямую, вместо этого используйте `rules.mk`, относящийся к конкретной раскладке.
* `config.h`: Файл, который устанавливает параметры времени компиляции по умолчанию. Не редактируйте этот файл напрямую, вместо этого используйте `config.h`, относящийся к конкретной раскладке.
* `info.json`: Файл настройки раскладки для QMK Configurator. Посмотрите [Поддержку конфигуратора](ru-ru/reference_configurator_support.md) для дополнительной информации.
* `readme.md`: Краткий обзор клавиатуры.
* `<keyboardName>.h`: В этом файле определяется раскладка клавиатуры по матрице переключателей клавиатуры.
* `<keyboardName>.c`: В этом файле вы можете найти пользовательский код для клавиатуры.

Для получения дополнительной информации о структуре проекта обратитесь к [Руководству QMK по клавиатуре](ru-ru/hardware_keyboard_guidelines.md).

### Структура раскладки клавиатуры

В каждой папке раскладки клавиатуры могут быть найдены следующие файлы. Обязательным является только файл `keymap.c`, и если остальные файлы не найдены, то будут выбраны параметры по умолчанию.

* `config.h`: настройки вашей раскладки клавиатуры.
* `keymap.c`: весь код вашей раскладки клавиатуры (обязателен).
* `rules.mk`: активированные функции QMK.
* `readme.md`: описание вашей раскладки клавиш, как ее могут использовать другие, и объяснения функций. Пожалуйста, загрузите изображения на сервис, такой как imgur.

# Файл `config.h`

Существует 3 возможных местоположения `config.h`:

* клавиатура (`/keyboards/<keyboard>/config.h`)
* пространство пользователя (`/users/<user>/config.h`)
* раскладка клавиш (`/keyboards/<keyboard>/keymaps/<keymap>/config.h`)

Система сборки автоматически загружает файлы конфигурации в указанном выше порядке. Если вы хотите переопределить любую настройку, заданную предыдущим `config.h`, вам сначала нужно будет включить некоторый шаблонный код для настроек, которые вы хотите изменить.

```
#pragma once
```

Затем, чтобы переопределить настройку из предыдущего файла `config.h`, вы должны сделать `#undef` и `#define` для неё снова.

Код и настройка шаблона вместе выглядят так:
```
#pragma once

// Переопределения производятся здесь!
#undef MY_SETTING
#define MY_SETTING 4
```
