* [Complete Newbs Guide](pt-br/newbs.md)
  * [Getting Started](pt-br/newbs_getting_started.md)
  * [Building Your First Firmware](pt-br/newbs_building_firmware.md)
  * [Flashing Firmware](pt-br/newbs_flashing.md)
  * [Testing and Debugging](pt-br/newbs_testing_debugging.md)
  * [Git Best Practices](pt-br/newbs_best_practices.md)
  * [Learning Resources](pt-br/newbs_learn_more_resources.md)

* [QMK Basics](pt-br/README.md)
  * [QMK Introduction](pt-br/getting_started_introduction.md)
  * [QMK CLI](pt-br/cli.md)
  * [QMK CLI Config](pt-br/cli_configuration.md)
  * [Contributing to QMK](pt-br/contributing.md)
  * [How to Use GitHub](pt-br/getting_started_github.md)
  * [Getting Help](pt-br/getting_started_getting_help.md)

* [Breaking Changes](pt-br/breaking_changes.md)
  * [2019 Aug 30](pt-br/ChangeLog/20190830.md)

* [FAQ](faq.md)
  * [General FAQ](pt-br/faq_general.md)
  * [Build/Compile QMK](pt-br/faq_build.md)
  * [Debugging/Troubleshooting QMK](pt-br/faq_debug.md)
  * [Keymap](pt-br/faq_keymap.md)
  * [Driver Installation with Zadig](pt-br/driver_installation_zadig.md)

* Detailed Guides
  * [Install Build Tools](pt-br/getting_started_build_tools.md)
  * [Vagrant Guide](pt-br/getting_started_vagrant.md)
  * [Build/Compile Instructions](pt-br/getting_started_make_guide.md)
  * [Flashing Firmware](pt-br/flashing.md)
  * [Customizing Functionality](pt-br/custom_quantum_functions.md)
  * [Keymap Overview](pt-br/keymap.md)

* [Hardware](hardware.md)
  * [AVR Processors](pt-br/hardware_avr.md)
  * [Drivers](pt-br/hardware_drivers.md)

* Reference
  * [Keyboard Guidelines](pt-br/hardware_keyboard_guidelines.md)
  * [Config Options](pt-br/config_options.md)
  * [Keycodes](pt-br/keycodes.md)
  * [Coding Conventions - C](pt-br/coding_conventions_c.md)
  * [Coding Conventions - Python](pt-br/coding_conventions_python.md)
  * [Documentation Best Practices](pt-br/documentation_best_practices.md)
  * [Documentation Templates](pt-br/documentation_templates.md)
  * [Glossary](pt-br/reference_glossary.md)
  * [Unit Testing](pt-br/unit_testing.md)
  * [Useful Functions](pt-br/ref_functions.md)
  * [Configurator Support](pt-br/reference_configurator_support.md)
  * [info.json Format](pt-br/reference_info_json.md)
  * [Python CLI Development](pt-br/cli_development.md)

* [Features](pt-br/features.md)
  * [Basic Keycodes](pt-br/keycodes_basic.md)
  * [US ANSI Shifted Keys](pt-br/keycodes_us_ansi_shifted.md)
  * [Quantum Keycodes](pt-br/quantum_keycodes.md)
  * [Advanced Keycodes](pt-br/feature_advanced_keycodes.md)
  * [Audio](pt-br/feature_audio.md)
  * [Auto Shift](pt-br/feature_auto_shift.md)
  * [Backlight](pt-br/feature_backlight.md)
  * [Bluetooth](pt-br/feature_bluetooth.md)
  * [Bootmagic](pt-br/feature_bootmagic.md)
  * [Combos](pt-br/feature_combo.md)
  * [Command](pt-br/feature_command.md)
  * [Debounce API](pt-br/feature_debounce_type.md)
  * [DIP Switch](pt-br/feature_dip_switch.md)
  * [Dynamic Macros](pt-br/feature_dynamic_macros.md)
  * [Encoders](pt-br/feature_encoders.md)
  * [Grave Escape](pt-br/feature_grave_esc.md)
  * [Haptic Feedback](pt-br/feature_haptic_feedback.md)
  * [HD44780 LCD Controller](pt-br/feature_hd44780.md)
  * [Key Lock](pt-br/feature_key_lock.md)
  * [Layouts](pt-br/feature_layouts.md)
  * [Leader Key](pt-br/feature_leader_key.md)
  * [LED Matrix](pt-br/feature_led_matrix.md)
  * [Macros](pt-br/feature_macros.md)
  * [Mouse Keys](pt-br/feature_mouse_keys.md)
  * [OLED Driver](pt-br/feature_oled_driver.md)
  * [One Shot Keys](pt-br/one_shot_keys.md)
  * [Pointing Device](pt-br/feature_pointing_device.md)
  * [PS/2 Mouse](pt-br/feature_ps2_mouse.md)
  * [RGB Lighting](pt-br/feature_rgblight.md)
  * [RGB Matrix](pt-br/feature_rgb_matrix.md)
  * [Space Cadet](pt-br/feature_space_cadet.md)
  * [Split Keyboard](pt-br/feature_split_keyboard.md)
  * [Stenography](pt-br/feature_stenography.md)
  * [Swap Hands](pt-br/feature_swap_hands.md)
  * [Tap Dance](pt-br/feature_tap_dance.md)
  * [Terminal](pt-br/feature_terminal.md)
  * [Thermal Printer](pt-br/feature_thermal_printer.md)
  * [Unicode](pt-br/feature_unicode.md)
  * [Userspace](pt-br/feature_userspace.md)
  * [Velocikey](pt-br/feature_velocikey.md)

* For Makers and Modders
  * [Hand Wiring Guide](pt-br/hand_wire.md)
  * [ISP Flashing Guide](pt-br/isp_flashing_guide.md)
  * [ARM Debugging Guide](pt-br/arm_debugging.md)
  * [I2C Driver](pt-br/i2c_driver.md)
  * [SPI Driver](pt-br/spi_driver.md)
  * [GPIO Controls](pt-br/internals_gpio_control.md)
  * [Proton C Conversion](pt-br/proton_c_conversion.md)

* For a Deeper Understanding
  * [How Keyboards Work](pt-br/how_keyboards_work.md)
  * [Understanding QMK](pt-br/understanding_qmk.md)

* Other Topics
  * [Using Eclipse with QMK](pt-br/other_eclipse.md)
  * [Using VSCode with QMK](pt-br/other_vscode.md)
  * [Support](pt-br/getting_started_getting_help.md)
  * [How to add translations](pt-br/translating.md)

* QMK Internals (In Progress)
  * [Defines](pt-br/internals_defines.md)
  * [Input Callback Reg](pt-br/internals_input_callback_reg.md)
  * [Midi Device](pt-br/internals_midi_device.md)
  * [Midi Device Setup Process](pt-br/internals_midi_device_setup_process.md)
  * [Midi Util](pt-br/internals_midi_util.md)
  * [Send Functions](pt-br/internals_send_functions.md)
  * [Sysex Tools](pt-br/internals_sysex_tools.md)
