# QMK 用語集

<!---
  original document: 0.9.46:docs/reference_glossary.md
  git diff 0.9.46 HEAD -- docs/reference_glossary.md | cat
-->

## ARM
Atmel、Cypress、Kinetis、NXP、ST、TI など多くの企業が生産する 32 ビット MCU のライン。

## AVR
[Atmel](http://www.microchip.com/) が生産する 8 ビット MCU のライン。AVR は TMK がサポートしていた元のプラットフォームでした。

## AZERTY
標準的な Français (フランス) キーボードレイアウト。キーボードの最初の6つのキーから命名されました。

## バックライト
キーボードのライトの総称。バックライトが一般的ですが、それだけではなく、キーキャップあるいはスイッチを通して光る LED の配列。

## Bluetooth
短距離のピアツーピア無線プロトコル。キーボード用のもっとも一般的なワイヤレスプロトコル。

## ブートローダ
MCU の保護領域に書き込まれる特別なプログラムで、MCU が独自のファームウェアを通常は USB 経由でアップグレードできるようにします。

## ブートマジック
よくあるキーの交換あるいは無効化など、様々なキーボードの挙動の変更をその場で実行できる機能。

## C
システムコードに適した低レベルプログラミング言語。QMK のほとんどのコードは C で書かれています。

## Colemak
人気が出始めている代替キーボードレイアウト。

## コンパイル
人間が読めるコードを MCU が実行できるマシンコードに変換するプロセス。

## Dvorak
1930年代に Dr. August Dvorak によって開発された代替キーボードレイアウト。Dvorak Simplified Keyboard の短縮形。

## 動的マクロ
キーボードに記録されたマクロで、キーボードのプラグを抜くか、コンピュータを再起動すると失われます。

* [動的マクロドキュメント](ja/feature_dynamic_macros.md)

## Eclipse
多くの C 開発者に人気のある IDE。

* [Eclipse セットアップ手順](ja/other_eclipse.md)

## ファームウェア
MCU を制御するソフトウェア

## git
コマンドラインで使用されるバージョン管理ソフトウェア

## GitHub
QMK プロジェクトのほとんどをホストする Web サイト。git、課題管理、および QMK の実行に役立つその他の機能を統合して提供します。

## ISP
インシステムプログラミング。外部ハードウェアと JTAG ピンを使って AVR チップをプログラミングする方法。

## hid_listen
キーボードからデバッグメッセージを受信するためのインタフェース。[QMK Flasher](https://github.com/qmk/qmk_flasher) あるいは [PJRC の hid_listen](https://www.pjrc.com/teensy/hid_listen.html) を使ってこれらのメッセージを見ることができます。

## キーコード
特定のキーを表す2バイトの数値。`0x00`-`0xFF` は[基本キーコード](ja/keycodes_basic.md)に使われ、`0x100`-`0xFFFF` は [Quantum キーコード](ja/quantum_keycodes.md) に使われます。

## キーダウン
キーが押された時に発生し、キーが放される前に完了するイベント。

## キーアップ
キーが放された時に発生するイベント。

## キーマップ
物理的なキーボードレイアウトにマップされたキーコードの配列。キーの押下およびリリース時に処理されます。

## レイヤー
1つのキーが複数の目的を果たすために使われる抽象化。最上位のアクティブなレイヤーが優先されます。

## リーダーキー
リーダーキーに続けて1, 2 あるいは3つのキーをタップすることで、キーの押下あるいは他の quantum 機能をアクティブにする機能。

* [リーダーキードキュメント](ja/feature_leader_key.md)

## LED
発光ダイオード。キーボードの表示に使われる最も一般的なデバイス。

## Make
全てのソースファイルをコンパイルするために使われるソフトウェアパッケージ。キーボードファームウェアをコンパイルするために、様々なオプションを指定して `make` を実行します。

## マトリックス
MCU がより少ないピン数でキー押下を検出できるようにする列と行の配線パターン。マトリックスには多くの場合、NKRO を可能にするためのダイオードが組み込まれています。

## マクロ
単一のキーのみを押した後で、複数のキー押下イベント (HID レポート) を送信できる機能。

* [マクロドキュメント](ja/feature_macros.md)

## MCU
マイクロコントロールユニット。キーボードを動かすプロセッサ。

## モディファイア
別のキーを入力する間押したままにして、そのキーのアクションを変更するキー。例として、Ctrl、Alt および Shift があります。
(訳注：モディファイヤ、モディファイヤキー、修飾キーなど、訳語が統一されていませんが同じものです)

## マウスキー
キーボードからマウスカーソルを制御し、クリックできる機能。

* [マウスキードキュメント](ja/feature_mouse_keys.md)

## N キーロールオーバー (NKRO)
一度に任意の数のキーの押下を送信できるキーボードに当てはまる用語。

## ワンショットモディファイア
別のキーが放されるまで押されているかのように機能するモディファイア。キーを押している間に mod を押し続けるのではなく、mod を押してからキーを押すことができます。スティッキーキーまたはデッドキーとも呼びます。

## ProMicro
低コストの AVR 開発ボード。このデバイスのクローンは ebay で非常に安価(5ドル未満)に見つかることがありますが、多くの場合 pro micro の書き込みに苦労します。

## プルリクエスト
QMK にコードを送信するリクエスト。全てのユーザが個人のキーマップのプルリクエストを送信することを推奨します。

## QWERTY
標準の英語キーボードレイアウト。多くの場合、他の言語の標準レイアウトへのショートカット。キーボードの最初の6文字から命名されました。

## QWERTZ
標準的な Deutsche (ドイツ語) キーボードレイアウト。キーボードの最初の6文字から命名されました。

## ロールオーバー
キーが既に押されている間にキーを押すことを指す用語。似たものに 2KRO、6KRO、NKRO が含まれます。

## スキャンコード
単一のキーを表す USB 経由の HID レポートの一部として送信される1バイトの数値。これらの値は、[USB-IF](http://www.usb.org/) が発行する [HID Usage Tables](https://www.usb.org/sites/default/files/documents/hut1_12v2.pdf) に記載されています。

## スペースカデットシフト
左または右 shift を1回以上タップすることで、様々なタイプの括弧を入力できる特別な shift キーのセット。

* [スペースカデットシフトドキュメント](ja/feature_space_cadet_shift.md)

## タップ
キーを押して放す。状況によってはキーダウンイベントとキーアップイベントを区別する必要がありますが、タップは常に両方を一度に指します。

## タップダンス
押す回数に基づいて、同じキーに複数のキーコードを割り当てることができる機能。

* [タップダンスドキュメント](ja/feature_tap_dance.md)

## Teensy
手配線での組み立てによく用いられる低コストの AVR 開発ボード。halfkay ブートローダによって書き込みが非常に簡単になるために、数ドル高いにもかかわらず teensy がしばしば選択されます。

## アンダーライト
キーボードの下側を照らす LED の総称。これらの LED は通常 PCB の底面からキーボードが置かれている表面に向けて照らします。

## ユニコード
大規模なコンピュータの世界では、ユニコードは任意の言語で文字を表現するためのエンコード方式のセットです。QMK に関しては、様々な OS スキームを使ってスキャンコードの代わりにユニコードコードポイントを送信することを意味します。

* [ユニコードドキュメント](ja/feature_unicode.md)

## 単体テスト
QMK に対して自動テストを実行するためのフレームワーク。単体テストは、変更が何も壊さないことを確信するのに役立ちます。

* [単体テストドキュメント](ja/unit_testing.md)

## USB
ユニバーサルシリアルバス。キーボード用の最も一般的な有線インタフェース。

## USB ホスト (あるいは単にホスト)
USB ホストは、あなたのコンピュータ、またはキーボードが差し込まれているデバイスのことです。

# 探している用語が見つかりませんでしたか？

質問についての [issue を開いて](https://github.com/qmk/qmk_firmware/issues) 、質問した用語についてここに追加することができます。さらに良いのは、定義についてのプルリクエストを開くことです。:)
