# Quantum キーコード

<!---
  original document: 0.9.55:docs/quantum_keycodes.md
  git diff 0.9.55 HEAD -- docs/quantum_keycodes.md | cat
-->

Quantum キーコードにより、カスタムアクションを定義することなく、基本的なものが提供するものより簡単にキーマップをカスタマイズすることができます。

quantum 内の全てのキーコードは `0x0000` と `0xFFFF` の間の数値です。`keymap.c` の中では、関数やその他の特別な場合があるように見えますが、最終的には C プリプロセッサによってそれらは単一の4バイト整数に変換されます。QMK は標準的なキーコードのために `0x0000` から `0x00FF` を予約しています。これらは、`KC_A`、`KC_1` および `KC_LCTL` のようなキーコードで、USB HID 仕様で定義された基本的なキーです。

このページでは、高度な quantum 機能を実装するために使われる `0x00FF` と `0xFFFF` の間のキーコードを説明します。独自のカスタムキーコードを定義する場合は、それらもこの範囲に配置されます。

## QMK キーコード :id=qmk-keycodes

| キー           | エイリアス | 説明                                                   |
|----------------|------------|--------------------------------------------------------|
| `RESET`        |            | 書き込みのために、キーボードを bootloader モードにする |
| `DEBUG`        |            | デバッグモードの切り替え                               |
| `EEPROM_RESET` | `EEP_RST`  | キーボードの EEPROM (永続化メモリ) を再初期化する      |
