# キーマップの概要

<!---
  original document: 0.9.44:docs/keymap.md
  git diff 0.9.44 HEAD -- docs/keymap.md | cat
-->

QMK のキーマップは C のソースファイルの中で定義されます。そのデータ構造は配列の配列です。外側はレイヤーを要素とする配列で、レイヤーはキーを要素とする配列。ほとんどのキーボードは `LAYOUT()` マクロを定義して、この配列の配列を作成しやすくしています。


## キーマップとレイヤー :id=keymap-and-layers
QMKでは、**`const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS]`**は、**アクションコード**を保持している **16 bit** データの中でキーマップ情報の複数の**レイヤー**を保持します。最大で**32個のレイヤー**を定義することができます。

普通のキー定義の場合、**アクションコード**の上位8ビットは全て0で、下位8ビットは**キーコード**としてキーによって生成された USB HID usage コードを保持します。

各レイヤーは同時に有効にできます。レイヤーには 0 から 31 までのインデックスが付けられ、上位のレイヤーが優先されます。

    Keymap: 32 Layers                   Layer: action code matrix
    -----------------                   ---------------------
    stack of layers                     array_of_action_code[row][column]
           ____________ precedence               _______________________
          /           / | high                  / ESC / F1  / F2  / F3   ....
      31 /___________// |                      /-----/-----/-----/-----
      30 /___________// |                     / TAB /  Q  /  W  /  E   ....
      29 /___________/  |                    /-----/-----/-----/-----
       :   _:_:_:_:_:__ |               :   /LCtrl/  A  /  S  /  D   ....
       :  / : : : : : / |               :  /  :     :     :     :
       2 /___________// |               2 `--------------------------
       1 /___________// |               1 `--------------------------
       0 /___________/  V low           0 `--------------------------


TMK の歴史的経緯から、キーマップに保存されたアクションコードは、一部のドキュメントではキーコードと呼ばれる場合があります。

### キーマップレイヤーステータス :id=keymap-layer-status

キーマップレイヤーの状態は、2つの32ビットパラメータによって決定されます。

* **`default_layer_state`** は、常に有効で参照される基本キーマップレイヤー (0-31) を示します (デフォルトレイヤー)。
* **`layer_state`** は現在の各レイヤーのオン/オフの状態をビットで持ちます。

キーマップレイヤー '0' は通常 `default_layer` で、他のレイヤーはファームウェアの起動後に最初はオフになっていますが、これは `config.h` で異なる設定にすることが可能です。例えば Qwerty ではなく Colemak に切り替えるなど、キーレイアウトを完全に切り替える場合、`default_layer` を変更すると便利です。

    Initial state of Keymap          Change base layout
    -----------------------          ------------------

      31                               31
      30                               30
      29                               29
       :                                :
       :                                :   ____________
       2   ____________                 2  /           /
       1  /           /              ,->1 /___________/
    ,->0 /___________/               |  0
    |                                |
    `--- default_layer = 0           `--- default_layer = 1
         layer_state   = 0x00000001       layer_state   = 0x00000002

一方、`layer_state` を変更して、基本レイヤーをナビゲーションキー、ファンクションキー (F1-F12)、メディアキー、特別なアクションなどの機能を持つ他のレイヤーでオーバーレイすることができます。

    Overlay feature layer
    ---------------------      bit|status
           ____________        ---+------
      31  /           /        31 |   0
      30 /___________// -----> 30 |   1
      29 /___________/  -----> 29 |   1
       :                        : |   :
       :   ____________         : |   :
       2  /           /         2 |   0
    ,->1 /___________/  ----->  1 |   1
    |  0                        0 |   0
    |                                 +
    `--- default_layer = 1            |
         layer_state   = 0x60000002 <-'



### レイヤーの優先順位と透過性
***上位のレイヤーはレイヤーのスタックでより高い優先順位を持つ***ことに注意してください。ファームウェアは最上位のアクティブレイヤーから下に向かってキーコードを検索します。ファームウェアがアクティブなレイヤーで `KC_TRNS` (透過)以外のキーコードを見つけると、検索を停止し、下位レイヤーは参照されません。

           ____________
          /           /  <--- Higher layer
         /  KC_TRNS  //
        /___________//   <--- Lower layer (KC_A)
        /___________/
    
    上記シナリオでは、上位レイヤーに非透過のキーが定義されているとそのキーが使われますが、`KC_TRNS` (または同等のキーコード)が定義されている場合は常に下位レベルのキーコード(`KC_A`)が使われます。

**メモ:** 特定のレイヤーの透過性を示す有効な方法:
* `KC_TRANSPARENT`
* `KC_TRNS` (別名)
* `_______` (別名)

これらのキーコードは、処理する非透過のキーコードを探すときに、下位レイヤーを検索させることができます。

## `keymap.c` の分析

この例では、[デフォルトの Clueboard 66% キーマップの古いバージョン](https://github.com/qmk/qmk_firmware/blob/ca01d94005f67ec4fa9528353481faa622d949ae/keyboards/clueboard/keymaps/default/keymap.c)を見ていきます。そのファイルを別のブラウザウィンドウで開くとコンテキスト内のすべてを見ることができるので便利です。

`keymap.c` ファイルには、あなたが関心があるであろう以下の2つの主要なセクションがあります:

* [定義](#definitions)
* [レイヤー/キーマップデータ構造](#layers-and-keymaps)

### 定義 :id=definitions

ファイルの上部に以下のものがあります:

    #include QMK_KEYBOARD_H
    
    // 便利な定義
    #define GRAVE_MODS  (MOD_BIT(KC_LSHIFT)|MOD_BIT(KC_RSHIFT)|MOD_BIT(KC_LGUI)|MOD_BIT(KC_RGUI)|MOD_BIT(KC_LALT)|MOD_BIT(KC_RALT))
    
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    *  KC_TRNS (透過) の代わりに _______ を使うことができます   *
     *  あるいは、KC_NO (NOOP)  として XXXXXXX を使うことができます    *
    * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    
    // 各レイヤーは読みやすいように名前を持ちます。
    // アンダースコアは何も意味を持ちません
    // STUFF あるいは他の名前のレイヤーを持つことができます。
    // レイヤー名は全て同じ長さである必要はなく、
    // また名前を完全に省略して単に数字を使うことができます。
    #define _BL 0
    #define _FL 1
    #define _CL 2

これらはキーマップとカスタム関数を作成するときに使うことができる便利な定義です。`GRAVE_MODS` 定義は後でカスタム関数で使われ、その下の `_BL`、`_FL`、`_CL` 定義は各レイヤーを参照しやすくします。

注意: 古いキーマップファイルに `_______` および `XXXXXXX` の定義が含まれているかもしれません。これらはそれぞれ `KC_TRNS` および `KC_NO` の代わりに使うことができ、レイヤーがどのキーを上書きしているかを簡単に確認することができます。これらの定義はデフォルトで含まれるため、今では不要になりました。

### レイヤーとキーマップ :id=layers-and-keymaps

このファイルの主要部分は `keymaps[]` 定義です。ここで、レイヤーとそれらの内容を列挙します。ファイルのこの部分は、以下の定義から始まります:

    const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

この後で、LAYOUT() マクロのリストがあります。LAYOUT() は単一のレイヤーを定義するためのキーのリストです。通常、1つ以上の"基本レイヤー" (QWERTY、Dvorak、Colemak など)があり、その上に1つ以上の"機能"レイヤーを重ねます。レイヤーの処理方法により、"より上位"のレイヤーの上に"より下位"のレイヤーを重ねることはできません。

QMK の `keymaps[][MATRIX_ROWS][MATRIX_COLS]` は、16ビットのアクションコード( quantum キーコードとも呼ばれる)を保持します。一般的なキーを表すキーコードの場合、その上位バイトは0で、その下位バイトはキーボードの USB HID usage ID です。

> QMK のフォーク元の TMK は、代わりに `const uint8_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS]` を使い、8ビットキーコードを保持します。一部のキーコード値は、`fn_actions[]` 配列を介して特定のアクションコードの実行を引き起こすために予約されています。

#### 基本レイヤー

Clueboard の基本レイヤーの例です:

    /* Keymap _BL: Base Layer (Default Layer)
    */
    [_BL] = LAYOUT(
    F(0),    KC_1,    KC_2,   KC_3,   KC_4,   KC_5,   KC_6,   KC_7,   KC_8,   KC_9,    KC_0,     KC_MINS,  KC_EQL,   KC_GRV,  KC_BSPC,          KC_PGUP, \
    KC_TAB,  KC_Q,    KC_W,   KC_E,   KC_R,   KC_T,   KC_Y,   KC_U,   KC_I,   KC_O,    KC_P,     KC_LBRC,  KC_RBRC,  KC_BSLS,                   KC_PGDN, \
    KC_CAPS, KC_A,    KC_S,   KC_D,   KC_F,   KC_G,   KC_H,   KC_J,   KC_K,   KC_L,    KC_SCLN,  KC_QUOT,  KC_NUHS,  KC_ENT,                             \
    KC_LSFT, KC_NUBS, KC_Z,   KC_X,   KC_C,   KC_V,   KC_B,   KC_N,   KC_M,   KC_COMM, KC_DOT,   KC_SLSH,  KC_RO,    KC_RSFT,          KC_UP,            \
    KC_LCTL, KC_LGUI, KC_LALT, KC_MHEN,          KC_SPC,KC_SPC,                        KC_HENK,  KC_RALT,  KC_RCTL,  MO(_FL), KC_LEFT, KC_DOWN, KC_RGHT),

これについて注意すべきいくつかの興味深いこと:

* C ソースの観点からは、これは単一の配列に過ぎませんが、物理デバイス上の各キーがどこにあるかをより簡単に可視化するために、空白が埋め込まれています。
* 単純なキーボードスキャンコードの先頭には KC_ が付いていますが、"特別な"キーには付いていません。
* 左上のキーはカスタム機能 0 (`F(0)`) をアクティブにします。
* "Fn" キーは `MO(_FL)` で定義され、そのキーが押されている間は `_FL` レイヤーに移動します。

#### 機能オーバーレイレイヤー

機能レイヤーはコードの観点から基本レイヤーと違いはありません。ただし概念的には、置き換えの代わりにオーバーレイとしてそのレイヤーを構築します。多くの人にとってはこの区別は重要ではありませんが、より複雑なレイヤー設定を構築するにつれて、ますます重要になります。

    [_FL] = LAYOUT(
    KC_GRV,  KC_F1,   KC_F2,  KC_F3,  KC_F4,  KC_F5,  KC_F6,  KC_F7,  KC_F8,  KC_F9,   KC_F10,   KC_F11,   KC_F12,   _______, KC_DEL,           BL_STEP, \
    _______, _______, _______,_______,_______,_______,_______,_______,KC_PSCR,KC_SLCK, KC_PAUS,  _______,  _______,  _______,                   _______, \
    _______, _______, MO(_CL),_______,_______,_______,_______,_______,_______,_______, _______,  _______,  _______,  _______,                           \
    _______, _______, _______,_______,_______,_______,_______,_______,_______,_______, _______,  _______,  _______,  _______,          KC_PGUP,         \
    _______, _______, _______, _______,        _______,_______,                        _______,  _______,  _______,  MO(_FL), KC_HOME, KC_PGDN, KC_END),

注意すべきいくつかの興味深いこと:

* `_______` 定義を使って、`KC_TRNS` を `_______` に変換しました。これによりこのレイヤーで変更されたキーを簡単に見つけることができます。
* このレイヤーで `_______` キーのいずれかを押すと、次の下位のアクティブなレイヤーのキーがアクティブになります。

# 核心となる詳細

これで独自のキーマップを作成するための基本的な概要が得られました。詳細は以下のリソースを見てください:

* [キーコード](ja/keycodes.md)
* [キーマップ FAQ](ja/faq_keymap.md)

これらのドキュメントの改善に積極的に取り組んでいます。それらを改善する方法について提案がある場合は、[issue を報告](https://github.com/qmk/qmk_firmware/issues/new)してください！
