# マウスキー

<!---
  original document: 0.9.44:docs/feature_mouse_keys.md
  git diff 0.9.44 HEAD -- docs/feature_mouse_keys.md | cat
-->

マウスキーは、キーボードを使ってマウスをエミュレートできる機能です。様々な速度でポインタを移動し、5つのボタンを押し、8方向にスクロールすることができます。

## キーボードにマウスキーを追加

マウスキーを使うためには、少なくともマウスキーサポートを有効にし、マウスアクションをキーボードのキーにマップする必要があります。

### マウスキーを有効にする

マウスキーを有効にするには、キーマップの `rules.mk` に以下の行を追加します:

```c
MOUSEKEY_ENABLE = yes
```

### マウスアクションのマッピング

キーマップでキー押下をマウスアクションにマップするために、以下のキーコードを使うことができます:

| キー | エイリアス | 説明 |
|----------------|---------|-----------------|
| `KC_MS_UP` | `KC_MS_U` | カーソルを上に移動 |
| `KC_MS_DOWN` | `KC_MS_D` | カーソルを下に移動 |
| `KC_MS_LEFT` | `KC_MS_L` | カーソルを左に移動 |
| `KC_MS_RIGHT` | `KC_MS_R` | カーソルを右に移動 |
| `KC_MS_BTN1` | `KC_BTN1` | ボタン1を押す |
| `KC_MS_BTN2` | `KC_BTN2` | ボタン2を押す |
| `KC_MS_BTN3` | `KC_BTN3` | ボタン3を押す |
| `KC_MS_BTN4` | `KC_BTN4` | ボタン4を押す |
| `KC_MS_BTN5` | `KC_BTN5` | ボタン5を押す |
| `KC_MS_WH_UP` | `KC_WH_U` | ホイールを向こう側に回転 |
| `KC_MS_WH_DOWN` | `KC_WH_D` | ホイールを手前側に回転 |
| `KC_MS_WH_LEFT` | `KC_WH_L` | ホイールを左に倒す |
| `KC_MS_WH_RIGHT` | `KC_WH_R` | ホイールを右に倒す |
| `KC_MS_ACCEL0` | `KC_ACL0` | 速度を0に設定 |
| `KC_MS_ACCEL1` | `KC_ACL1` | 速度を1に設定 |
| `KC_MS_ACCEL2` | `KC_ACL2` | 速度を2に設定 |

## マウスキーの設定

マウスキーはカーソルを移動するための3つの異なるモードをサポートします:

* **加速 (デフォルト):** 移動キーを押したままにすると、カーソルが最大速度に達するまでカーソルを加速します。
* **定速:** 移動キーを押したままにすると、カーソルを一定の速度で移動します。
* **混合:** 移動キーを押したままにすると、カーソルが最大速度に達するまでカーソルを加速し、加速キーと移動キーを同時に押すとカーソルは一定の速度で移動します。

同じ原則がスクロールにも適用されます。

時間、間隔、遅延の設定オプションは、ミリ秒で指定されます。スクロール速度はデフォルトスクロールステップの倍数として渡されます。例えば、スクロール速度8は、各スクロールアクションがオペレーティングシステムまたはアプリケーションで定義されるデフォルトのスクロールステップの8倍の距離進むことを意味します。

### 加速モード

これはデフォルトのモードです。キーマップの `config.h` ファイルの以下の設定を使ってカーソルとスクロールの加速を調整することができます:

| 定義 | デフォルト | 説明 |
|----------------------------|-------|---------------------------------------------------------|
| `MOUSEKEY_DELAY` | 300 | 移動キーを押してからカーソルが移動するまでの遅延 |
| `MOUSEKEY_INTERVAL` | 50 | カーソル移動間の時間 |
| `MOUSEKEY_MAX_SPEED` | 10 | 加速が停止する最大のカーソル速度 |
| `MOUSEKEY_TIME_TO_MAX` | 20 | 最大カーソル速度に達するまでの時間 |
| `MOUSEKEY_WHEEL_DELAY` | 300 | ホイールキーを押してからホイールが動くまでの遅延 |
| `MOUSEKEY_WHEEL_INTERVAL` | 100 | ホイールの動きの間の時間 |
| `MOUSEKEY_WHEEL_MAX_SPEED` | 8 | スクロールアクションごとのスクロールステップの最大数 |
| `MOUSEKEY_WHEEL_TIME_TO_MAX` | 40 | 最大スクロール速度に達するまでの時間 |

ヒント:

* `MOUSEKEY_DELAY` の設定が低すぎるとカーソルが応答しなくなります。設定が高すぎると小さな動きが難しくなります。
* カーソルの動きをスムーズにするには、`MOUSEKEY_INTERVAL` の値を低くします。ディスプレイのリフレッシュレートが60Hzの場合、`16` (1/60) に設定することができます。これによりカーソルの速度が大幅に向上するため、`MOUSEKEY_MAX_SPEED` を下げた方が良いかもしれません。
* `MOUSEKEY_TIME_TO_MAX` または `MOUSEKEY_WHEEL_TIME_TO_MAX` を `0` に設定すると、それぞれカーソルの速度またはスクロールの加速が無効になります。この方法では、一方を加速しながら他方を一定にすることができますが、これは定速モードでは不可能です。
* `MOUSEKEY_WHEEL_INTERVAL` の設定が低すぎるとスクロールがとても速くなります。設定が高すぎるとホイールキーを押したままにした時にスクロールがとても遅くなります

カーソルの加速は、X Window System MouseKeysAccel 機能と同じアルゴリズムを使います。詳細については [Wikipedia](https://en.wikipedia.org/wiki/Mouse_keys) をご覧ください。

### 定速モード

このモードでは、カーソルおよびマウスホイールの両方について複数の異なる速度を定義することができます。加速はありません。`KC_ACL0`、`KC_ACL1` および `KC_ACL2` は、カーソルとスクロールの速度をそれぞれの設定に変更します。

速度の選択は、一時的とタップ選択のどちらかを選べます:

* **一時的:** 選択された速度は、それぞれのキーを押している間のみアクティブになります。キーを放すと、マウスキーは変更される前の速度に戻ります。
* **タップ選択:** それぞれのキーを押すと選択された速度がアクティブになり、キーを放した後もアクティブのままになります。デフォルトの速度は `KC_ACL1` です。未変更の速度はありません。

最も遅い速度から最も速い速度までのデフォルトの速度は以下の通りです:

* **一時的:** `KC_ACL0` < `KC_ACL1` < *変更無し* < `KC_ACL2`
* **タップ選択:** `KC_ACL0` < `KC_ACL1` < `KC_ACL2`

定速モードを使うには、少なくともキーマップの keymaps ディレクトリの `config.h` ファイルに `MK_3_SPEED` を定義する必要があります。

```c
#define MK_3_SPEED
```

一時的モードを有効にするには、`MK_MOMENTARY_ACCEL` も定義します:

```c
#define MK_MOMENTARY_ACCEL
```

カーソル移動あるいはスクロールを調整する場合は、以下の設定を使います:

| 定義 | デフォルト | 説明 |
|---------------------|-------------|-------------------------------------------|
| `MK_3_SPEED` | *定義なし* | 定速カーソルを有効にする |
| `MK_MOMENTARY_ACCEL` | *定義なし* | 一時的モードを有効にする |
| `MK_C_OFFSET_UNMOD` | 16 | 移動ごとのカーソルオフセット (変更無し) |
| `MK_C_INTERVAL_UNMOD` | 16 | カーソルの移動間の時間 (変更無し) |
| `MK_C_OFFSET_0` | 1 | 移動ごとのカーソルオフセット (`KC_ACL0`) |
| `MK_C_INTERVAL_0` | 32 | カーソル移動間の時間 (`KC_ACL0`) |
| `MK_C_OFFSET_1` | 4 | 移動ごとのカーソルオフセット (`KC_ACL1`) |
| `MK_C_INTERVAL_1` | 16 | カーソル移動間の時間 (`KC_ACL1`) |
| `MK_C_OFFSET_2` | 32 | 移動ごとのカーソルオフセット (`KC_ACL2`) |
| `MK_C_INTERVAL_2` | 16 | カーソル移動間の時間 (`KC_ACL2`) |
| `MK_W_OFFSET_UNMOD` | 1 | スクロールアクションごとのスクロールステップ (変更無し) |
| `MK_W_INTERVAL_UNMOD` | 40 | スクロールステップ間の時間 (変更無し) |
| `MK_W_OFFSET_0` | 1 | スクロールアクションごとのスクロールステップ (`KC_ACL0`) |
| `MK_W_INTERVAL_0` | 360 | スクロールステップ間の時間 (`KC_ACL0`) |
| `MK_W_OFFSET_1` | 1 | スクロールアクションごとのスクロールステップ (`KC_ACL1`) |
| `MK_W_INTERVAL_1` | 120 | スクロールステップ間の時間 (`KC_ACL1`) |
| `MK_W_OFFSET_2` | 1 | スクロールアクションごとのスクロールステップ (`KC_ACL2`) |
| `MK_W_INTERVAL_2` | 20 | スクロールステップ間の時間 (`KC_ACL2`) |

### 混合モード

このモードは **加速** モードのように機能しますが、`KC_ACL0`、`KC_ACL1`、`KC_ACL2` を押したままにすることで
一時的(押している間)にカーソルとスクロール速度を定速に設定できます。
加速キーが押されていない場合、このモードは **加速** モードと同じで、関連する全ての設定を使って変更できます。

* **KC_ACL0:** この加速はカーソルをできるだけ遅い速度に設定します。これはカーソルを非常に小さく詳細に移動する場合に便利です。
* **KC_ACL1:** この加速はカーソルを最大(ユーザ定義)速度の半分に設定します。
* **KC_ACL2:** この加速はカーソルを最大(コンピュータ定義)速度に設定します。これは、正確性を多少犠牲にしてカーソルを大きく移動する場合に便利です。

混合モードを使うには、キーマップの `config.h` ファイルに少なくとも `MK_COMBINED` を定義しなければなりません:

```c
#define MK_COMBINED
```
