# Zadig を使ったブートローダドライバのインストール

<!---
  original document: 0.9.43:docs/driver_installation_zadig.md
  git diff 0.9.43 HEAD -- docs/driver_installation_zadig.md | cat
-->

QMK はホストにたいして通常の HID キーボードデバイスとして振る舞うため特別なドライバは必要ありません。しかし、Windows でのキーボードへの書き込みは、多くの場合、キーボードをリセットした時に現れるブートローダデバイスで*行います*。

2つの注目すべき例外があります: 通常 Pro Micro で見られる Caterina ブートローダや、PJRC Teensy に書き込まれている HalfKay ブートローダは、それぞれシリアルポートと汎用 HID デバイスとして振る舞うため、ドライバは必要ありません。

[Zadig](https://zadig.akeo.ie/) ユーティリティを使うことをお勧めします。MSYS2 あるいは WSL を使って開発環境をセットアップした場合、`qmk_install.sh` スクリプトはドライバをインストールするかどうかをたずねます。

## インストール

`RESET` キーコード (別のレイヤにあるかもしれません)を押すか、通常はキーボードの下面にあるリセットスイッチを押して、キーボードをブートローダモードにします。どちらもキーボードに無い場合は、Escape または Space+`B` を押しながら接続してみてください (詳細は、[ブートマジック](ja/feature_bootmagic.md) ドキュメントを見てください)。一部のキーボードはブートマジックの代わりに[コマンド](ja/feature_command.md)を使います。この場合、キーボードが接続されている状態で「左Shift + 右Shift + `B`」あるいは「左Shift + 右Shift + Escape」を押すと、ブートローダモードに入ることができます。
一部のキーボードはブートローダに入るために特定の操作をする必要があります。例えば、[ブートマジック Lite](ja/feature_bootmagic.md#bootmagic-lite) キー (デフォルト: Escape) は別のキー(例えば、左Control)かもしれません。また、コマンドを有効にするキーの組み合わせ (デフォルト: 左Shift + 右Shift) は何か他のキー(例えば 左Control + 右Control)を押し続ける必要がある場合があります。不明な場合は、キーボードの README ファイルを参照してください。

USBaspLoader を使ってデバイスをブートローダモードにするには、`BOOT` ボタンを押しながら `RESET` ボタンをタップしてください。
あるいは `BOOT` を押し続けながら USB ケーブルを挿入します。

Zadig は自動的にブートローダデバイスを検知します。**Options → List All Devices** を確認する必要がある場合があります。

- Atmel AVR MCU を搭載したキーボードの場合、ブートローダは `ATm32U4DFU` に似た名前が付けられ、ベンダー ID は `03EB` です。
- USBasp ブートローダは `USBasp` として表示され、VID/PID は`16C0:05DC` です。
- QMK-DFU ブートローダを使って書き込まれた AVR キーボードは `<keyboard name> Bootloader` という名前が付けられ、VID は `03EB` です。
- ほとんどの ARM キーボードでは、`STM32 BOOTLOADER` と呼ばれ、VID/PID は `0483:DF11` です。

!> Zadig が `HidUsb` ドライバを使用する1つ以上のデバイスを表示する場合、キーボードはおそらくブートローダモードではありません。矢印はオレンジ色になり、システムドライバの変更を確認するように求められます。この場合、続行**しないでください**！

矢印が緑色で表示されたら、ドライバを選択し、**Install Driver** をクリックします。`libusb-win32` ドライバは通常 AVR で動作し、`WinUSB`は ARM で動作しますが、それでもキーボードに書き込みできない場合は、リストから異なるドライバをインストールしてみてください。USBAspLoader デバイスは `libusbK` ドライバを使わなければなりません。

![ブートローダドライバが正常にインストールされた Zadig](https://i.imgur.com/b8VgXzx.png)

最後に、新しいドライバがロードされたことを確認するためにキーボードのプラグを抜いて再接続します。書き込みに QMK Toolbox を使う場合は、ドライバの変更を認識しない場合があるため、QMK Toolkit を終了して再起動します。

## 間違ったデバイスのインストールからの回復

キーボードが入力できなくなった場合は、ブートローダではなくキーボード自体のドライバを間違って入れ替えた可能性があります。これはキーボードがブートローダモードでない場合に起こりえます。これは Zadig で簡単に確認することができます - 健全なキーボードには、全てのインタフェースに `HidUsb` ドライバがインストールされています:

![Zadig から見た健全なキーボード](https://i.imgur.com/Hx0E5kC.png)

デバイスマネージャーを開き、キーボードと思われるデバイスを探します。

![デバイスマネージャーにおける、間違ったドライバがインストールされたキーボード](https://i.imgur.com/L3wvX8f.png)

右クリックし、**デバイスのアンインストール** をクリックします。最初に **このデバイスのドライバーソフトウェアを削除します** にチェックが付いていることを確認してください。

!["ドライバの削除"にチェックボックスにチェックが付いた、デバイスのアンインストールダイアログ](https://i.imgur.com/aEs2RuA.png)

**Action → Scan for hardware changes** をクリックします。この時点で、再び入力できるようになっているはずです。Zadig でキーボードデバイスが `HidUsb` ドライバを使っていることを再確認します。そうであれば完了です。キーボードは再び機能するはずです！

?> Windows が新しいドライバを使えるようにするために、この時点でコンピュータを完全に再起動する必要があるかもしれません。
