# Quantum Mechanical Keyboard Firmware

<!---
  original document: 0.8.58:docs/README.md
  git diff 0.8.58 HEAD -- docs/README.md | cat
-->

[![現在のバージョン](https://img.shields.io/github/tag/qmk/qmk_firmware.svg)](https://github.com/qmk/qmk_firmware/tags)
[![ビルド状態](https://travis-ci.org/qmk/qmk_firmware.svg?branch=master)](https://travis-ci.org/qmk/qmk_firmware)
[![Discord](https://img.shields.io/discord/440868230475677696.svg)](https://discord.gg/Uq7gcHh)
[![ドキュメントの状態](https://img.shields.io/badge/docs-ready-orange.svg)](https://docs.qmk.fm)
[![GitHub 貢献者](https://img.shields.io/github/contributors/qmk/qmk_firmware.svg)](https://github.com/qmk/qmk_firmware/pulse/monthly)
[![GitHub フォーク](https://img.shields.io/github/forks/qmk/qmk_firmware.svg?style=social&label=Fork)](https://github.com/qmk/qmk_firmware/)

## QMK ファームウェアとは何でしょうか？

QMK (*Quantum Mechanical Keyboard*)は、コンピュータ入力デバイスの開発を中心としたオープンソースコミュニティです。コミュニティには、キーボード、マウス、MIDI デバイスなど、全ての種類の入力デバイスが含まれます。協力者の中心グループは、[QMK ファームウェア](https://github.com/qmk/qmk_firmware)、[QMK Configurator](https://config.qmk.fm)、[QMK ツールボックス](https://github.com/qmk/qmk_toolbox)、[qmk.fm](https://qmk.fm)、そして、このドキュメントを、あなたのようなコミュニティメンバーの助けを借りて保守しています。

## 始めましょう

QMK は初めてですか？始めるには2つの方法があります:

* 基本: [QMK Configurator](https://config.qmk.fm)
    * ドロップダウンからあなたのキーボードを選択し、キーボードをプログラムします。
    * 見ることができる [紹介ビデオ](https://www.youtube.com/watch?v=-imgglzDMdY) があります。
    * 読むことができる概要 [ドキュメント](ja/newbs_building_firmware_configurator.md) があります。
* 発展: [ソースを使用します](ja/newbs.md)
    * より強力ですが、使うのはより困難です。

## 自分用にアレンジします

QMK には、探求すべき多くの[機能](ja/features.md)と、深く知るためのリファレンスドキュメントがたくさんあります。ほとんどの機能は[キーマップ](ja/keymap.md)を変更し、[キーコード](ja/keycodes.md)を変更することで活用されます。

## 手助けが必要ですか？

[サポートページ](ja/support.md) をチェックして、QMK の使い方について手助けを得る方法を確認してください。

## 貢献する

QMK コミュニティに貢献する方法はたくさんあります。始める最も簡単な方法は、それを使って友人に QMK という単語を広めることです。

* フォーラムやチャットルームで人々を支援します:
    * [/r/olkb](https://www.reddit.com/r/olkb/)
    * [Discord サーバ](https://discord.gg/Uq7gcHh)
* 下にある「Edit This Page」をクリックしてドキュメントに貢献します
* [ドキュメントをあなたの言語に翻訳します](ja/translating.md)
* [バグを報告します](https://github.com/qmk/qmk_firmware/issues/new/choose)
* [プルリクエストを開きます](ja/contributing.md)
