**En Français**

* [Guide pour débutant complet](fr-fr/newbs.md)
  * [Pour débuter](fr-fr/newbs_getting_started.md)
  * [Compiler son premier firmware](fr-fr/newbs_building_firmware.md)
  * [Flasher le Firmware](fr-fr/newbs_flashing.md)
  * [Test et Débuggage](fr-fr/newbs_testing_debugging.md)
  * [Bonnes pratiques Git](fr-fr/newbs_best_practices.md)
  * [Ressources d'apprentissage](fr-fr/newbs_learn_more_resources.md)

* [Les bases de QMK](fr-fr/README.md)
  * [Indroduction à QMK](fr-fr/getting_started_introduction.md)
  * [QMK CLI](fr-fr/cli.md)
  * [Configuration de la CLI QMK](fr-fr/cli_configuration.md)
  * [Contribuer à QMK](fr-fr/contributing.md)
  * [Comment utiliser GitHub](fr-fr/getting_started_github.md)
  * [Trouver de l'aide](fr-fr/getting_started_getting_help.md)

* [Breaking changes](fr-fr/breaking_changes.md)
  * [30 août 2019](fr-fr/ChangeLog/20190830.md)

* [FAQ](fr-fr/faq.md)
  * [FAQ Générale](fr-fr/faq_general.md)
  * [Compiler QMK](fr-fr/faq_build.md)
  * [Débugguer / Dépanner QMK](fr-fr/faq_debug.md)
  * [Keymap / Disposition](fr-fr/faq_keymap.md)
  * [Installer les drivers avec Zadig](fr-fr/driver_installation_zadig.md)

**En Anglais**

* Guides détaillés
  * [Installation des outils de compilation](fr-fr/getting_started_build_tools.md)
  * [Guide Vagrant](fr-fr/getting_started_vagrant.md)
  * [Commandes de compilations](fr-fr/getting_started_make_guide.md)
  * [Flasher les firmwares](fr-fr/flashing.md)
  * [Personnaliser les fonctionnalités](fr-fr/custom_quantum_functions.md)
  * [Aperçu des fonctionnalités des dispositions](fr-fr/keymap.md)

* [Hardware](fr-fr/hardware.md)
  * [Processeurs AVR](fr-fr/hardware_avr.md)
  * [Pilotes / Drivers](fr-fr/hardware_drivers.md)

* Réferences
  * [Lignes de conduite des claviers](fr-fr/hardware_keyboard_guidelines.md)
  * [Options de configurations](fr-fr/config_options.md)
  * [Keycodes / Codes des caractères](fr-fr/keycodes.md)
  * [Conventions de codage - C](fr-fr/coding_conventions_c.md)
  * [Conventions de codage - Python](fr-fr/coding_conventions_python.md)
  * [Meilleurs pratiques sur la documentation](fr-fr/documentation_best_practices.md)
  * [Modèles de documentation](fr-fr/documentation_templates.md)
  * [Glossaire](fr-fr/reference_glossary.md)
  * [Tests unitaires](fr-fr/unit_testing.md)
  * [Fonctions utiles](fr-fr/ref_functions.md)
  * [Support de configuration](fr-fr/reference_configurator_support.md)
  * [Format du fichier info.json](fr-fr/reference_info_json.md)
  * [Développer la CLI en Python](fr-fr/cli_development.md)

* [Fonctionnalités](fr-fr/features.md)
  * [Keycodes basiques](fr-fr/keycodes_basic.md)
  * [Touches utilisées avec Shift (US ANSI)](fr-fr/keycodes_us_ansi_shifted.md)
  * [Keycodes quantiques](fr-fr/quantum_keycodes.md)
  * [Keycodes avancés](fr-fr/feature_advanced_keycodes.md)
  * [Fonctionnalités audio](fr-fr/feature_audio.md)
  * [Majuscule automatique](fr-fr/feature_auto_shift.md)
  * [Rétroéclairage](fr-fr/feature_backlight.md)
  * [Bluetooth](fr-fr/feature_bluetooth.md)
  * [Bootmagic](fr-fr/feature_bootmagic.md)
  * [Combos](fr-fr/feature_combo.md)
  * [Commande](fr-fr/feature_command.md)
  * [API anti-rebond](fr-fr/feature_debounce_type.md)
  * [DIP Switch](fr-fr/feature_dip_switch.md)
  * [Macros dynamiques](fr-fr/feature_dynamic_macros.md)
  * [Interrupteurs rotatifs](fr-fr/feature_encoders.md)
  * [Grave Escape](fr-fr/feature_grave_esc.md)
  * [Retour haptique](fr-fr/feature_haptic_feedback.md)
  * [Contrôleur LCD HD44780](fr-fr/feature_hd44780.md)
  * [Touche à verrou / Lock-key](fr-fr/feature_key_lock.md)
  * [Dispositions / layouts](fr-fr/feature_layouts.md)
  * [Touche leader](fr-fr/feature_leader_key.md)
  * [Matrice LED](fr-fr/feature_led_matrix.md)
  * [Macros](fr-fr/feature_macros.md)
  * [Boutons de souris](fr-fr/feature_mouse_keys.md)
  * [Pilotes / Drivers OLED](fr-fr/feature_oled_driver.md)
  * [Touche one-shot](fr-fr/one_shot_keys.md)
  * [Périphériques de pointage](fr-fr/feature_pointing_device.md)
  * [Souris PS/2](fr-fr/feature_ps2_mouse.md)
  * [Éclairage RGB](fr-fr/feature_rgblight.md)
  * [Matrice RGB](fr-fr/feature_rgb_matrix.md)
  * [Space Cadet](fr-fr/feature_space_cadet.md)
  * [Claviers scindés / splittés](fr-fr/feature_split_keyboard.md)
  * [Stenographie](fr-fr/feature_stenography.md)
  * [Inversion des mains](fr-fr/feature_swap_hands.md)
  * [Tap Dance](fr-fr/feature_tap_dance.md)
  * [Terminale](fr-fr/feature_terminal.md)
  * [Imprimante thermique](fr-fr/feature_thermal_printer.md)
  * [Caractères unicodes](fr-fr/feature_unicode.md)
  * [Dossier utilisateur](fr-fr/feature_userspace.md)
  * [Velocikey](fr-fr/feature_velocikey.md)

* Pour les makers et les bricoleurs
  * [Guide des claviers soudés à la main](fr-fr/hand_wire.md)
  * [Guide de flash de l’ISP](fr-fr/isp_flashing_guide.md)
  * [Guide du débogage ARM](fr-fr/arm_debugging.md)
  * [Drivers I2C](fr-fr/i2c_driver.md)
  * [Drivers SPI](fr-fr/spi_driver.md)
  * [Contrôles des GPIO](fr-fr/internals_gpio_control.md)
  * [Conversion en Proton C](fr-fr/proton_c_conversion.md)

* Pour aller plus loin
  * [Comment fonctionnent les claviers](fr-fr/how_keyboards_work.md)
  * [Comprendre QMK](fr-fr/understanding_qmk.md)

* Autres sujets
  * [Utiliser Eclipse avec QMK](fr-fr/other_eclipse.md)
  * [Utiliser VSCode avec QMK](fr-fr/other_vscode.md)
  * [Support](fr-fr/getting_started_getting_help.md)
  * [Comment ajouter des traductions](fr-fr/translating.md)

* À l’intérieur de QMK (En cours de documentation)
  * [Définitions](fr-fr/internals_defines.md)
  * [Input Callback Reg](fr-fr/internals_input_callback_reg.md)
  * [Appareils Midi](fr-fr/internals_midi_device.md)
  * [Installation d’un appareil Midi](fr-fr/internals_midi_device_setup_process.md)
  * [Utilitaires Midi](fr-fr/internals_midi_util.md)
  * [Fonctions Midi](fr-fr/internals_send_functions.md)
  * [Outils Sysex](fr-fr/internals_sysex_tools.md)
