# QMK Breaking Change - 30 août 2019

Quatre fois par an, QMK lance un processus pour fusionner les Breaking Changes. Un Breaking Change est un changement qui modifie la manière dont QMK fonctionne introduisant des incompatibilités ou des comportements dangereux. Nous n'effectuons ces changements que 4 fois par an afin que les utilisateurs n'aient pas peur de casser leurs keymaps en mettant à jour leur version de QMK.

Ce document présente les fusions de Breaking Change. Voici la liste des changements.

## Formattage de code Core avec clang-format

* Tous les fichiers core (`drivers/`, `quantum/`, `tests/`, et `tmk_core/`) seront formatés avec clang-format
* Un processus travis pour reformatter les PRs lors de la fusion a été mis en place
* Vous pouvez utiliser la nouvelle commande CLI `qmk cformat` afin de formater avant de soumettre votre PR si vous le souhaitez.

## Nettoyage des descripteurs LUFA USB

* Nettoyage du code lié aux descripteurs USB HID sur les claviers AVR, afin de les rendre plus simple à lire et compréhensibles
* Plus d'information:  https://github.com/qmk/qmk_firmware/pull/4871
* Normalement pas de changement de fonctionnement et aucune keymap modifiée.

## Migration des entrées de `ACTION_LAYER_MOMENTARY()` dans `fn_actions` vers des keycodes `MO()`

* `fn_actions` est déprécié, et ses fonctionnalités ont été remplacées par des keycodes directs et `process_record_user()`
* Supprimer cette fonctionnalité obsolète devrait aboutir à une réduction importante de la taille du firmware et de la complexité du code
* Il est recommandé que toutes les keymaps affectées remplacent `fn_actions` vers les fonctionnalités de [keycode custom](https://docs.qmk.fm/#/custom_quantum_functions) et [macro](https://docs.qmk.fm/#/feature_macros)

## Mise à jour Atreus vers les conventions de codage courantes

* Les doublons include guards ont contourné le comportement de traitement des headers attendu
* Il est recommandé pour toutes les keymaps affectées de supprimer le doublon de `<keyboard>/config.h` et `<keyboard>/keymaps/<user>/config.h` et de ne garder que des surcharges au niveau keymap

## Récupération des changements de fichier keymap langage de la fork ZSA

* Corrige une issue dans le fichier `keymap_br_abnt2.h` qui inclut la mauvaise souce (`keymap_common.h` au lieu de `keymap.h`)
* Met à jour le fichier `keymap_swedish.h` afin d'être spécifique au suédois et plus "nordique" en général.
* Toutes les keymaps qui utilisent ceci devront supprimer `NO_*` et le remplacer par `SE_*`.

## Mise à jour du repo afin d'utiliser LUFA comme un sous-module git

* `/lib/LUFA` supprimé du dépôt
* LUFA, définis comme un sous-module, pointe vers qmk/lufa
* Ceci devrait ajouter plus de flexibilité vers LUFA, et nous permet de garder le sous-module à jour bien plus facilement. Il avait environ 2 ans de retard, sans manière simple de corriger. Ce changement devrait simplifier la mise à jour dans le futur.

## Migration des entrées `ACTION_BACKLIGHT_*()` dans `fn_actions` vers des keycodes `BL_`

* `fn_actions` est déprécié, et ses fonctionnalités ont été remplacées par des keycodes directs et `process_record_user()`
* Toutes les keymaps utilisant ces actions doivent avoir les clés `KC_FN*` remplacées par les clés `BL_*` équivalentes
* Si vous utilisez actuellement `KC_FN*` vous devrez remplacer `fn_actions` avec les fonctionnalités de [keycode custom](https://docs.qmk.fm/#/custom_quantum_functions) et [macro](https://docs.qmk.fm/#/feature_macros)

## Remplacer l'alias `KC_DELT` par `KC_DEL`

* `KC_DELT` était un alias redondant et non documenté pour `KC_DELETE`
* Il a été supprimé et toutes ses utilisations ont été remplacées par l'alias plus courant `KC_DEL`
* Environ 90 keymaps (surtout des boards ErgoDox) ont été modifiées à cette fin
